/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;

@ProviderType
public class WorkflowHandlerRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowHandlerRegistryUtil.class);
    private static final WorkflowHandlerRegistryUtil _instance = new WorkflowHandlerRegistryUtil();
    private final Map<String, WorkflowHandler<?>> _scopeableWorkflowHandlerMap = new ConcurrentSkipListMap();
    private final ServiceRegistrationMap<WorkflowHandler<?>> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<WorkflowHandler<?>, WorkflowHandler<?>> _serviceTracker;
    private final Map<String, WorkflowHandler<?>> _workflowHandlerMap = new TreeMap();

    public static List<WorkflowHandler<?>> getScopeableWorkflowHandlers() {
        return _instance._getScopeableWorkflowHandlers();
    }

    public static <T> WorkflowHandler<T> getWorkflowHandler(String className) {
        return _instance._getWorkflowHandler(className);
    }

    public static List<WorkflowHandler<?>> getWorkflowHandlers() {
        return _instance._getWorkflowHandlers();
    }

    public static void register(List<WorkflowHandler<?>> workflowHandlers) {
        for (WorkflowHandler<?> workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.register(workflowHandler);
        }
    }

    public static void register(WorkflowHandler<?> workflowHandler) {
        _instance._register(workflowHandler);
    }

    public static <T> void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, groupId, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> T startWorkflowInstance(final long companyId, final long groupId, final long userId, String className, final long classPK, final T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (serviceContext.getWorkflowAction() != 1) {
            return model;
        }
        final WorkflowHandler<T> workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler == null) {
            if (WorkflowThreadLocal.isEnabled()) {
                throw new WorkflowException("No workflow handler found for " + className);
            }
            return model;
        }
        boolean hasWorkflowInstanceInProgress = _instance._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK);
        if (hasWorkflowInstanceInProgress) {
            if (_log.isWarnEnabled()) {
                _log.warn("Workflow already started for class " + className + " with primary key " + classPK + " in group " + groupId);
            }
            return model;
        }
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (WorkflowThreadLocal.isEnabled() && WorkflowEngineManagerUtil.isDeployed()) {
            workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        int status = 1;
        if (workflowDefinitionLink == null) {
            status = 0;
        }
        workflowContext = new HashMap<String, Serializable>(workflowContext);
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("userId", (Serializable)((Object)String.valueOf(userId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        workflowContext.put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault())));
        workflowContext.put("serviceContext", serviceContext);
        workflowContext.put("taskComments", (Serializable)((Object)GetterUtil.getString(serviceContext.getAttribute("comments"))));
        T updatedModel = workflowHandler.updateStatus(status, workflowContext);
        if (workflowDefinitionLink != null) {
            final Map<String, Serializable> tempWorkflowContext = workflowContext;
            TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    workflowHandler.startWorkflowInstance(companyId, groupId, userId, classPK, model, tempWorkflowContext);
                    return null;
                }
            });
        }
        return updatedModel;
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static void unregister(List<WorkflowHandler<?>> workflowHandlers) {
        for (WorkflowHandler<?> workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.unregister(workflowHandler);
        }
    }

    public static void unregister(WorkflowHandler<?> workflowHandler) {
        _instance._unregister(workflowHandler);
    }

    public static <T> T updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        String className = (String)((Object)workflowContext.get("entryClassName"));
        WorkflowHandler<T> workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler != null) {
            return workflowHandler.updateStatus(status, workflowContext);
        }
        return null;
    }

    private WorkflowHandlerRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(WorkflowHandler.class, (ServiceTrackerCustomizer)new WorkflowHandlerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private List<WorkflowHandler<?>> _getScopeableWorkflowHandlers() {
        return ListUtil.fromMapValues(this._scopeableWorkflowHandlerMap);
    }

    private WorkflowHandler<?> _getWorkflowHandler(String className) {
        return this._workflowHandlerMap.get(className);
    }

    private List<WorkflowHandler<?>> _getWorkflowHandlers() {
        return ListUtil.fromMapValues(this._workflowHandlerMap);
    }

    private boolean _hasWorkflowInstanceInProgress(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance(companyId, workflowInstanceLink.getWorkflowInstanceId());
        return !workflowInstance.isComplete();
    }

    private void _register(WorkflowHandler<?> workflowHandler) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(WorkflowHandler.class, workflowHandler);
        this._serviceRegistrations.put(workflowHandler, (Object)serviceRegistration);
    }

    private void _unregister(WorkflowHandler<?> workflowHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove(workflowHandler);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class WorkflowHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<WorkflowHandler<?>, WorkflowHandler<?>> {
        private WorkflowHandlerServiceTrackerCustomizer() {
        }

        public WorkflowHandler<?> addingService(ServiceReference<WorkflowHandler<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            WorkflowHandler workflowHandler = (WorkflowHandler)registry.getService(serviceReference);
            WorkflowHandlerRegistryUtil.this._workflowHandlerMap.put(workflowHandler.getClassName(), workflowHandler);
            if (workflowHandler.isScopeable()) {
                WorkflowHandlerRegistryUtil.this._scopeableWorkflowHandlerMap.put(workflowHandler.getClassName(), workflowHandler);
            }
            return workflowHandler;
        }

        public void modifiedService(ServiceReference<WorkflowHandler<?>> serviceReference, WorkflowHandler<?> workflowHandler) {
        }

        public void removedService(ServiceReference<WorkflowHandler<?>> serviceReference, WorkflowHandler<?> workflowHandler) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            WorkflowHandlerRegistryUtil.this._workflowHandlerMap.remove(workflowHandler.getClassName());
            if (workflowHandler.isScopeable()) {
                WorkflowHandlerRegistryUtil.this._scopeableWorkflowHandlerMap.remove(workflowHandler.getClassName());
            }
        }
    }
}

