/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Tuple;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ProgressTracker
implements Serializable {
    public static final String PERCENT = ProgressTracker.class.getName() + "_PERCENT";
    private int _percent;
    private final Map<Integer, Tuple> _progress = new HashMap<Integer, Tuple>();
    private final String _progressId;
    private int _status = 0;

    public ProgressTracker(String progressId) {
        this._progressId = progressId;
        this.addProgress(0, 0, "");
    }

    public void addProgress(int status, int percent, String message) {
        Tuple tuple = new Tuple(percent, message);
        this._progress.put(status, tuple);
    }

    public void finish(HttpServletRequest request) {
        this.finish(request.getSession());
    }

    public void finish(HttpSession session) {
        session.removeAttribute(PERCENT + this._progressId);
    }

    public void finish(PortletRequest portletRequest) {
        this.finish(portletRequest.getPortletSession());
    }

    public void finish(PortletSession portletSession) {
        portletSession.removeAttribute(PERCENT + this._progressId, 1);
    }

    public String getMessage() {
        Tuple tuple = this._progress.get(this._status);
        String message = GetterUtil.getString(tuple.getObject(1));
        return message;
    }

    public int getPercent() {
        return this._percent;
    }

    public int getStatus() {
        return this._status;
    }

    public void initialize(HttpServletRequest request) {
        this.initialize(request.getSession());
    }

    public void initialize(HttpSession session) {
        session.setAttribute(PERCENT + this._progressId, (Object)this);
    }

    public void initialize(PortletRequest portletRequest) {
        this.initialize(portletRequest.getPortletSession());
    }

    public void initialize(PortletSession portletSession) {
        portletSession.setAttribute(PERCENT + this._progressId, (Object)this, 1);
    }

    public void setPercent(int percent) {
        this._percent = percent;
    }

    public void setStatus(int status) {
        this._status = status;
        Tuple tuple = this._progress.get(this._status);
        this._percent = GetterUtil.getInteger(tuple.getObject(0));
    }

    public void start(HttpServletRequest request) {
        this.start(request.getSession());
    }

    public void start(HttpSession session) {
        this.initialize(session);
        this.setPercent(1);
    }

    public void start(PortletRequest portletRequest) {
        this.start(portletRequest.getPortletSession());
    }

    public void start(PortletSession portletSession) {
        this.initialize(portletSession);
        this.setPercent(1);
    }
}

