/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.persistence.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class TableMapperImpl<L extends BaseModel<L>, R extends BaseModel<R>>
implements TableMapper<L, R> {
    protected SqlUpdate addTableMappingSqlUpdate;
    protected SqlUpdate deleteLeftPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteRightPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteTableMappingSqlUpdate;
    protected MappingSqlQuery<Long> getLeftPrimaryKeysSqlQuery;
    protected MappingSqlQuery<Long> getRightPrimaryKeysSqlQuery;
    protected BasePersistence<L> leftBasePersistence;
    protected String leftColumnName;
    protected PortalCache<Long, long[]> leftToRightPortalCache;
    protected TableMapper<R, L> reverseTableMapper;
    protected BasePersistence<R> rightBasePersistence;
    protected String rightColumnName;
    protected PortalCache<Long, long[]> rightToLeftPortalCache;

    public TableMapperImpl(String tableName, String companyColumnName, String leftColumnName, String rightColumnName, BasePersistence<L> leftBasePersistence, BasePersistence<R> rightBasePersistence) {
        this.leftColumnName = leftColumnName;
        this.rightColumnName = rightColumnName;
        this.leftBasePersistence = leftBasePersistence;
        this.rightBasePersistence = rightBasePersistence;
        DataSource dataSource = leftBasePersistence.getDataSource();
        this.addTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "INSERT INTO " + tableName + " (" + companyColumnName + ", " + leftColumnName + ", " + rightColumnName + ") VALUES (?, ?, ?)", ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.deleteLeftPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + leftColumnName + " = ?", ParamSetter.BIGINT);
        this.deleteRightPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + rightColumnName + " = ?", ParamSetter.BIGINT);
        this.deleteTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + leftColumnName + " = ? AND " + rightColumnName + " = ?", ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.getLeftPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, "SELECT " + leftColumnName + " FROM " + tableName + " WHERE " + rightColumnName + " = ?", RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.getRightPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, "SELECT " + rightColumnName + " FROM " + tableName + " WHERE " + leftColumnName + " = ?", RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.leftToRightPortalCache = MultiVMPoolUtil.getPortalCache(TableMapper.class.getName() + "-" + tableName + "-LeftToRight");
        this.rightToLeftPortalCache = MultiVMPoolUtil.getPortalCache(TableMapper.class.getName() + "-" + tableName + "-RightToLeft");
    }

    @Override
    public boolean addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey) {
        ModelListener<L>[] leftModelListeners;
        if (this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        Class<R> rightModelClass = this.rightBasePersistence.getModelClass();
        for (ModelListener<L> leftModelListener : leftModelListeners = this.leftBasePersistence.getListeners()) {
            leftModelListener.onBeforeAddAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
        }
        Class<L> leftModelClass = this.leftBasePersistence.getModelClass();
        ModelListener<R>[] rightModelListeners = this.rightBasePersistence.getListeners();
        for (ModelListener<R> modelListener : rightModelListeners) {
            modelListener.onBeforeAddAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
        }
        try {
            this.addTableMappingSqlUpdate.update(companyId, leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        for (ModelListener<Object> modelListener : leftModelListeners) {
            modelListener.onAfterAddAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener<Object> modelListener : rightModelListeners) {
            modelListener.onAfterAddAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
        }
        return true;
    }

    @Override
    public boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        return this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, true);
    }

    @Override
    public int deleteLeftPrimaryKeyTableMappings(long leftPrimaryKey) {
        return TableMapperImpl.deleteTableMappings(this.leftBasePersistence, this.rightBasePersistence, this.leftToRightPortalCache, this.rightToLeftPortalCache, this.getRightPrimaryKeysSqlQuery, this.deleteLeftPrimaryKeyTableMappingsSqlUpdate, leftPrimaryKey);
    }

    @Override
    public int deleteRightPrimaryKeyTableMappings(long rightPrimaryKey) {
        return TableMapperImpl.deleteTableMappings(this.rightBasePersistence, this.leftBasePersistence, this.rightToLeftPortalCache, this.leftToRightPortalCache, this.getLeftPrimaryKeysSqlQuery, this.deleteRightPrimaryKeyTableMappingsSqlUpdate, rightPrimaryKey);
    }

    @Override
    public boolean deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        ModelListener<R>[] rightModelListeners;
        ModelListener<L>[] leftModelListeners;
        if (!this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        Class<R> rightModelClass = this.rightBasePersistence.getModelClass();
        for (ModelListener<L> leftModelListener : leftModelListeners = this.leftBasePersistence.getListeners()) {
            leftModelListener.onBeforeRemoveAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
        }
        Class<L> leftModelClass = this.leftBasePersistence.getModelClass();
        for (ModelListener<R> rightModelListener : rightModelListeners = this.rightBasePersistence.getListeners()) {
            rightModelListener.onBeforeRemoveAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
        }
        int rowCount = 0;
        try {
            rowCount = this.deleteTableMappingSqlUpdate.update(leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (rowCount > 0) {
            for (ModelListener<L> modelListener : leftModelListeners) {
                modelListener.onAfterRemoveAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
            }
            for (ModelListener<Object> modelListener : rightModelListeners) {
                modelListener.onAfterRemoveAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        MultiVMPoolUtil.removePortalCache(this.leftToRightPortalCache.getPortalCacheName());
        MultiVMPoolUtil.removePortalCache(this.rightToLeftPortalCache.getPortalCacheName());
    }

    @Override
    public List<L> getLeftBaseModels(long rightPrimaryKey, int start, int end, OrderByComparator<L> obc) {
        return TableMapperImpl.getBaseModels(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, this.leftBasePersistence, start, end, obc);
    }

    @Override
    public long[] getLeftPrimaryKeys(long rightPrimaryKey) {
        return TableMapperImpl.getPrimaryKeys(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, true);
    }

    @Override
    public TableMapper<R, L> getReverseTableMapper() {
        return this.reverseTableMapper;
    }

    @Override
    public List<R> getRightBaseModels(long leftPrimaryKey, int start, int end, OrderByComparator<R> obc) {
        return TableMapperImpl.getBaseModels(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, this.rightBasePersistence, start, end, obc);
    }

    @Override
    public long[] getRightPrimaryKeys(long leftPrimaryKey) {
        return TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, true);
    }

    @Override
    public boolean matches(String leftColumnName, String rightColumnName) {
        return this.leftColumnName.equals(leftColumnName) && this.rightColumnName.equals(rightColumnName);
    }

    public void setReverseTableMapper(TableMapper<R, L> reverseTableMapper) {
        this.reverseTableMapper = reverseTableMapper;
    }

    protected static <M extends BaseModel<M>, S extends BaseModel<S>> int deleteTableMappings(BasePersistence<M> masterBasePersistence, BasePersistence<S> slaveBasePersistence, PortalCache<Long, long[]> masterToSlavePortalCache, PortalCache<Long, long[]> slaveToMasterPortalCache, MappingSqlQuery<Long> mappingSqlQuery, SqlUpdate deleteSqlUpdate, long masterPrimaryKey) {
        ModelListener<M>[] masterModelListeners = masterBasePersistence.getListeners();
        ModelListener<S>[] slaveModelListeners = slaveBasePersistence.getListeners();
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(masterToSlavePortalCache, mappingSqlQuery, masterPrimaryKey, false);
        Class<M> masterModelClass = null;
        Class<S> slaveModelClass = null;
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            masterModelClass = masterBasePersistence.getModelClass();
            slaveModelClass = slaveBasePersistence.getModelClass();
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onBeforeRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onBeforeRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        masterToSlavePortalCache.remove(masterPrimaryKey);
        for (long slavePrimaryKey : slavePrimaryKeys) {
            slaveToMasterPortalCache.remove(slavePrimaryKey);
        }
        int rowCount = 0;
        try {
            rowCount = deleteSqlUpdate.update(masterPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onAfterRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onAfterRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        return rowCount;
    }

    protected static <T extends BaseModel<T>> List<T> getBaseModels(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, BasePersistence<T> slaveBasePersistence, int start, int end, OrderByComparator<T> obc) {
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(portalCache, mappingSqlQuery, masterPrimaryKey, true);
        if (slavePrimaryKeys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> slaveBaseModels = new ArrayList<T>(slavePrimaryKeys.length);
        try {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                slaveBaseModels.add(slaveBasePersistence.findByPrimaryKey(Long.valueOf(slavePrimaryKey)));
            }
        }
        catch (NoSuchModelException nsme) {
            throw new SystemException(nsme);
        }
        if (obc != null) {
            Collections.sort(slaveBaseModels, obc);
        }
        return ListUtil.subList(slaveBaseModels, start, end);
    }

    protected static long[] getPrimaryKeys(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, boolean updateCache) {
        long[] primaryKeys = portalCache.get(masterPrimaryKey);
        if (primaryKeys == null) {
            List<Long> primaryKeysList = null;
            try {
                primaryKeysList = mappingSqlQuery.execute(masterPrimaryKey);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            primaryKeys = new long[primaryKeysList.size()];
            for (int i = 0; i < primaryKeys.length; ++i) {
                primaryKeys[i] = primaryKeysList.get(i);
            }
            Arrays.sort(primaryKeys);
            if (updateCache) {
                PortalCacheHelperUtil.putWithoutReplicator(portalCache, masterPrimaryKey, primaryKeys);
            }
        }
        return primaryKeys;
    }

    protected boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey, boolean updateCache) {
        long[] rightPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, updateCache);
        return Arrays.binarySearch(rightPrimaryKeys, rightPrimaryKey) >= 0;
    }
}

