/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalServiceUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public abstract class BaseUserNotificationHandler
implements UserNotificationHandler {
    private static final String _BODY_TEMPLATE_DEFAULT = "<div class=\"title\">[$TITLE$]</div><div class=\"body\">[$BODY$]</div>";
    private static final Log _log = LogFactoryUtil.getLog(BaseUserNotificationHandler.class);
    private boolean _actionable;
    private boolean _openDialog;
    private String _portletId;
    private String _selector = "";

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public String getSelector() {
        return this._selector;
    }

    @Override
    public UserNotificationFeedEntry interpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        try {
            UserNotificationFeedEntry userNotificationFeedEntry = this.doInterpret(userNotificationEvent, serviceContext);
            if (userNotificationFeedEntry != null) {
                userNotificationFeedEntry.setOpenDialog(this.isOpenDialog());
                userNotificationFeedEntry.setPortletId(this.getPortletId());
            } else {
                Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getPortletId());
                String body = StringUtil.replace(_BODY_TEMPLATE_DEFAULT, new String[]{"[$BODY$]", "[$TITLE$]"}, new String[]{serviceContext.translate("notification-for-x-was-deleted", portlet.getDisplayName()), serviceContext.translate("notification-no-longer-applies", new Object[0])});
                userNotificationFeedEntry = new UserNotificationFeedEntry(false, body, "");
            }
            return userNotificationFeedEntry;
        }
        catch (Exception e) {
            _log.error("Unable to interpret notification", e);
            return null;
        }
    }

    @Override
    public boolean isDeliver(long userId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        UserNotificationDefinition userNotificationDefinition = UserNotificationManagerUtil.fetchUserNotificationDefinition(this._portletId, classNameId, notificationType);
        if (userNotificationDefinition == null) {
            return deliveryType == 10000;
        }
        UserNotificationDeliveryType userNotificationDeliveryType = userNotificationDefinition.getUserNotificationDeliveryType(deliveryType);
        if (userNotificationDeliveryType == null) {
            return false;
        }
        UserNotificationDelivery userNotificationDelivery = UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this._portletId, classNameId, notificationType, deliveryType, userNotificationDeliveryType.isDefault());
        return userNotificationDelivery.isDeliver();
    }

    @Override
    public boolean isOpenDialog() {
        return this._openDialog;
    }

    protected UserNotificationFeedEntry doInterpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        String body = this.getBody(userNotificationEvent, serviceContext);
        if (Validator.isNull(body)) {
            return null;
        }
        String link = this.getLink(userNotificationEvent, serviceContext);
        return new UserNotificationFeedEntry(this.isActionable(), body, link);
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getBodyTemplate() throws Exception {
        if (this.isActionable()) {
            StringBundler sb = new StringBundler(6);
            sb.append("<div class=\"title\">[$TITLE$]</div><div ");
            sb.append("class=\"body\"><div class=\"button-holder\"><a ");
            sb.append("class=\"btn btn-lg btn-primary\"");
            sb.append("href=\"[$CONFIRM_URL$]\">[$CONFIRM$]</a><a ");
            sb.append("class=\"btn btn-lg btn-default\" href=\"");
            sb.append("[$IGNORE_URL$]\">[$IGNORE$]</a></div></div>");
            return sb.toString();
        }
        return _BODY_TEMPLATE_DEFAULT;
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected boolean isActionable() {
        return this._actionable;
    }

    protected void setActionable(boolean actionable) {
        this._actionable = actionable;
    }

    protected void setOpenDialog(boolean openDialog) {
        this._openDialog = openDialog;
    }

    protected void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected void setSelector(String selector) {
        this._selector = selector;
    }
}

