/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.portal.kernel.mobile.device.Capability;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceRecognitionProvider;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.NoKnownDevices;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DeviceDetectionUtil {
    private static final DeviceDetectionUtil _instance = new DeviceDetectionUtil();
    private volatile DeviceRecognitionProvider _defaultDeviceRecognitionProvider;
    private volatile DeviceRecognitionProvider _deviceRecognitionProvider;
    private final ServiceTracker<DeviceRecognitionProvider, DeviceRecognitionProvider> _serviceTracker;

    public static Device detectDevice(HttpServletRequest request) {
        DeviceRecognitionProvider deviceRecognitionProvider = DeviceDetectionUtil.getDeviceRecognitionProvider();
        if (deviceRecognitionProvider == null) {
            return UnknownDevice.getInstance();
        }
        return deviceRecognitionProvider.detectDevice(request);
    }

    public static DeviceRecognitionProvider getDeviceRecognitionProvider() {
        PortalRuntimePermission.checkGetBeanProperty(DeviceDetectionUtil.class);
        if (DeviceDetectionUtil._instance._deviceRecognitionProvider != null) {
            return DeviceDetectionUtil._instance._deviceRecognitionProvider;
        }
        return DeviceDetectionUtil._instance._defaultDeviceRecognitionProvider;
    }

    public static Set<VersionableName> getKnownBrands() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrands();
    }

    public static Set<VersionableName> getKnownBrowsers() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrowsers();
    }

    public static Set<String> getKnownDeviceIdsByCapability(Capability capability) {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        Map<Capability, Set<String>> deviceIds = knownDevices.getDeviceIds();
        return deviceIds.get(capability);
    }

    public static Set<VersionableName> getKnownOperatingSystems() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getOperatingSystems();
    }

    public static Set<String> getKnownPointingMethods() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getPointingMethods();
    }

    public DeviceDetectionUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(DeviceRecognitionProvider.class, (ServiceTrackerCustomizer)new DeviceRecognitionProviderServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    protected static KnownDevices getKnownDevices() {
        DeviceRecognitionProvider deviceRecognitionProvider = DeviceDetectionUtil.getDeviceRecognitionProvider();
        KnownDevices knownDevices = null;
        knownDevices = deviceRecognitionProvider == null ? NoKnownDevices.getInstance() : deviceRecognitionProvider.getKnownDevices();
        return knownDevices;
    }

    private class DeviceRecognitionProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<DeviceRecognitionProvider, DeviceRecognitionProvider> {
        private DeviceRecognitionProviderServiceTrackerCustomizer() {
        }

        public DeviceRecognitionProvider addingService(ServiceReference<DeviceRecognitionProvider> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            DeviceRecognitionProvider deviceRecognitionProvider = (DeviceRecognitionProvider)registry.getService(serviceReference);
            String type = (String)serviceReference.getProperty("type");
            if (Validator.isNotNull(type) && type.equals("default")) {
                DeviceDetectionUtil.this._defaultDeviceRecognitionProvider = deviceRecognitionProvider;
            } else {
                DeviceDetectionUtil.this._deviceRecognitionProvider = deviceRecognitionProvider;
            }
            return deviceRecognitionProvider;
        }

        public void modifiedService(ServiceReference<DeviceRecognitionProvider> serviceReference, DeviceRecognitionProvider deviceRecognitionProvider) {
        }

        public void removedService(ServiceReference<DeviceRecognitionProvider> serviceReference, DeviceRecognitionProvider deviceRecognitionProvider) {
            Registry registry = RegistryUtil.getRegistry();
            String type = (String)serviceReference.getProperty("type");
            if (type.equals("default")) {
                DeviceDetectionUtil.this._defaultDeviceRecognitionProvider = null;
            } else {
                DeviceDetectionUtil.this._deviceRecognitionProvider = null;
            }
            registry.ungetService(serviceReference);
        }
    }
}

