/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.ProxyFactory;
import java.util.Collections;
import java.util.List;

public class ClusterExecutorUtil {
    private static final Log _log = LogFactoryUtil.getLog(ClusterExecutorUtil.class);
    private static final ClusterExecutor _clusterExecutor = ProxyFactory.newServiceTrackedInstance(ClusterExecutor.class);

    public static void addClusterEventListener(ClusterEventListener clusterEventListener) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.addClusterEventListener(clusterEventListener);
    }

    public static FutureClusterResponses execute(ClusterRequest clusterRequest) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return null;
        }
        return clusterExecutor.execute(clusterRequest);
    }

    public static ClusterExecutor getClusterExecutor() {
        PortalRuntimePermission.checkGetBeanProperty(ClusterExecutorUtil.class);
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil is not initialized");
            }
            return null;
        }
        return _clusterExecutor;
    }

    public static List<ClusterNode> getClusterNodes() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return Collections.emptyList();
        }
        return clusterExecutor.getClusterNodes();
    }

    public static ClusterNode getLocalClusterNode() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return null;
        }
        return clusterExecutor.getLocalClusterNode();
    }

    public static boolean isClusterNodeAlive(String clusterNodeId) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return false;
        }
        return clusterExecutor.isClusterNodeAlive(clusterNodeId);
    }

    public static boolean isEnabled() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        return clusterExecutor != null;
    }

    public static void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.removeClusterEventListener(clusterEventListener);
    }
}

