/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.map.BitMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public final class BooleanType
extends Type {
    static final BooleanType booleanType = new BooleanType();

    private BooleanType() {
        super(16, 16, 0L, 0);
    }

    @Override
    public int displaySize() {
        return 5;
    }

    @Override
    public int getJDBCTypeCode() {
        return 16;
    }

    @Override
    public Class getJDBCClass() {
        return Boolean.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.Boolean";
    }

    @Override
    public String getNameString() {
        return "BOOLEAN";
    }

    @Override
    public String getDefinition() {
        return "BOOLEAN";
    }

    @Override
    public boolean isBooleanType() {
        return true;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        switch (operation) {
            case 40: {
                if (!other.isBooleanType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        boolean boolb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        boolean boola = (Boolean)a;
        return boola == (boolb = ((Boolean)b).booleanValue()) ? 0 : (boolb ? -1 : 1);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        switch (otherType.typeCode) {
            case 16: {
                return a;
            }
            case 14: 
            case 15: {
                BinaryData b = (BinaryData)a;
                if (b.bitLength(session) != 1L) break;
                return BitMap.isSet(b.getBytes(), 0) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 40: {
                a = Type.SQL_VARCHAR.convertToType(session, a, otherType);
            }
            case 1: 
            case 12: {
                a = ((CharacterType)otherType).trim(session, a, ' ', true, true);
                if (((String)a).equalsIgnoreCase("TRUE")) {
                    return Boolean.TRUE;
                }
                if (((String)a).equalsIgnoreCase("FALSE")) {
                    return Boolean.FALSE;
                }
                if (!((String)a).equalsIgnoreCase("UNKNOWN")) break;
                return null;
            }
            case 2: 
            case 3: {
                return NumberType.isZero(a) ? Boolean.FALSE : Boolean.TRUE;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                if (((Number)a).longValue() == 0L) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.error(3438);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        switch (otherType.typeCode) {
            case 16: {
                return a;
            }
        }
        if (otherType.isLobType()) {
            throw Error.error(5561);
        }
        if (otherType.isCharacterType()) {
            if ("0".equals(a)) {
                return Boolean.FALSE;
            }
            if ("1".equals(a)) {
                return Boolean.TRUE;
            }
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof Boolean) {
            return a;
        }
        if (a instanceof String) {
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof Number) {
            return NumberType.isZero(a) ? Boolean.FALSE : Boolean.TRUE;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertToDefaultType(session, a);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return (Boolean)a != false ? "TRUE" : "FALSE";
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "UNKNOWN";
        }
        return (Boolean)a != false ? "TRUE" : "FALSE";
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return otherType.typeCode == 0 || otherType.isBooleanType() || otherType.isCharacterType() || otherType.isIntegralType() || otherType.isBitType() && otherType.precision == 1L;
    }

    @Override
    public int canMoveFrom(Type otherType) {
        return otherType.isBooleanType() ? 0 : -1;
    }

    public static BooleanType getBooleanType() {
        return booleanType;
    }
}

