/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.hsqldb.map.BitMap;

public final class ServerAcl {
    protected static final byte[] ALL_SET_4BYTES = new byte[]{-1, -1, -1, -1};
    protected static final byte[] ALL_SET_16BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private PrintWriter pw = null;
    private List aclEntries;
    private static AclEntry PROHIBIT_ALL_IPV4;
    private static AclEntry PROHIBIT_ALL_IPV6;
    private File aclFile;
    private long lastLoadTime = 0L;

    public static String dottedNotation(byte[] uba) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uba.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(uba[i] & 0xFF);
        }
        return sb.toString();
    }

    public static String colonNotation(byte[] uba) {
        if (uba.length / 2 * 2 != uba.length) {
            throw new RuntimeException("At this time .colonNotation only handles even byte quantities");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uba.length; i += 2) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(Integer.toHexString((uba[i] & 0xFF) * 256 + (uba[i + 1] & 0xFF)));
        }
        return sb.toString();
    }

    public void setPrintWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append("Entry " + (i + 1) + ": " + this.aclEntries.get(i));
        }
        return sb.toString();
    }

    public boolean permitAccess(String s) {
        try {
            return this.permitAccess(InetAddress.getByName(s).getAddress());
        }
        catch (UnknownHostException uke) {
            this.println("'" + s + "' denied because failed to resolve to an addr");
            return false;
        }
    }

    public boolean permitAccess(byte[] addr) {
        this.ensureAclsUptodate();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (!((AclEntry)this.aclEntries.get(i)).matches(addr)) continue;
            AclEntry hit = (AclEntry)this.aclEntries.get(i);
            this.println("Addr '" + ServerAcl.dottedNotation(addr) + "' matched rule #" + (i + 1) + ":  " + hit);
            return hit.allow;
        }
        throw new RuntimeException("No rule matches address '" + ServerAcl.dottedNotation(addr) + "'");
    }

    private void println(String s) {
        if (this.pw == null) {
            return;
        }
        this.pw.println(s);
        this.pw.flush();
    }

    public ServerAcl(File aclFile) throws IOException, AclFormatException {
        this.aclFile = aclFile;
        this.aclEntries = this.load();
    }

    protected synchronized void ensureAclsUptodate() {
        if (this.lastLoadTime > this.aclFile.lastModified()) {
            return;
        }
        try {
            this.aclEntries = this.load();
            this.println("ACLs reloaded from file");
            return;
        }
        catch (Exception e) {
            this.println("Failed to reload ACL file.  Retaining old ACLs.  " + e);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected List load() throws IOException, AclFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] sa) throws AclFormatException, IOException {
        String s;
        if (sa.length > 1) {
            throw new RuntimeException("Try: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " --help");
        }
        if (sa.length > 0 && sa[0].equals("--help")) {
            System.err.println("SYNTAX: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " [filepath.txt]");
            System.err.println("ACL file path defaults to 'acl.txt' in the current directory.");
            System.exit(0);
        }
        ServerAcl serverAcl = new ServerAcl(new File(sa.length == 0 ? "acl.txt" : sa[0]));
        serverAcl.setPrintWriter(new PrintWriter(System.out));
        System.out.println(serverAcl.toString());
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter hostnames or IP addresses to be tested (one per line).");
        while ((s = br.readLine()) != null) {
            if ((s = s.trim()).length() < 1) continue;
            System.out.println(Boolean.toString(serverAcl.permitAccess(s)));
        }
    }

    static {
        try {
            PROHIBIT_ALL_IPV4 = new AclEntry(InetAddress.getByName("0.0.0.0").getAddress(), 0, false);
            PROHIBIT_ALL_IPV6 = new AclEntry(InetAddress.getByName("::").getAddress(), 0, false);
        }
        catch (UnknownHostException uke) {
            throw new RuntimeException("Unexpected problem in static initializer", uke);
        }
        catch (AclFormatException afe) {
            throw new RuntimeException("Unexpected problem in static initializer", afe);
        }
    }

    private static final class InternalException
    extends Exception {
        private InternalException() {
        }
    }

    private static final class AclEntry {
        private byte[] value;
        private byte[] mask;
        private int bitBlockSize;
        public boolean allow;

        public AclEntry(byte[] value, int bitBlockSize, boolean allow) throws AclFormatException {
            byte[] allOn = null;
            switch (value.length) {
                case 4: {
                    allOn = ALL_SET_4BYTES;
                    break;
                }
                case 16: {
                    allOn = ALL_SET_16BYTES;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only 4 and 16 bytes supported, not " + value.length);
                }
            }
            if (bitBlockSize > value.length * 8) {
                throw new IllegalArgumentException("Specified " + bitBlockSize + " significant bits, but value only has " + value.length * 8 + " bits");
            }
            this.bitBlockSize = bitBlockSize;
            this.value = value;
            this.mask = BitMap.leftShift(allOn, value.length * 8 - bitBlockSize);
            if (this.mask.length != value.length) {
                throw new RuntimeException("Basic program assertion failed.  Generated mask length " + this.mask.length + " (bytes) does not match given value length " + value.length + " (bytes).");
            }
            this.allow = allow;
            this.validateMask();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Addrs ");
            sb.append(this.value.length == 16 ? "[" + ServerAcl.colonNotation(this.value) + ']' : ServerAcl.dottedNotation(this.value));
            sb.append("/" + this.bitBlockSize + ' ' + (this.allow ? "ALLOW" : "DENY"));
            return sb.toString();
        }

        public boolean matches(byte[] candidate) {
            if (this.value.length != candidate.length) {
                return false;
            }
            return !BitMap.hasAnyBitSet(BitMap.xor(this.value, BitMap.and(candidate, this.mask)));
        }

        public void validateMask() throws AclFormatException {
            if (BitMap.hasAnyBitSet(BitMap.and(this.value, BitMap.not(this.mask)))) {
                throw new AclFormatException("The base address '" + ServerAcl.dottedNotation(this.value) + "' is too specific for block-size-spec /" + this.bitBlockSize);
            }
        }
    }

    public static final class AclFormatException
    extends Exception {
        public AclFormatException(String s) {
            super(s);
        }
    }
}

