/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    InputStream bufferedStream;
    GZIPInputStream gzipStream;
    RowInputTextLog rowIn;
    boolean isInsert;

    ScriptReaderText(Database db) {
        super(db);
    }

    public ScriptReaderText(Database db, String fileName, boolean compressed) throws IOException {
        super(db);
        InputStream tempStream;
        this.inputStream = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        this.bufferedStream = new BufferedInputStream(this.inputStream);
        if (compressed) {
            this.gzipStream = new GZIPInputStream(this.bufferedStream);
            tempStream = this.gzipStream;
        } else {
            tempStream = this.bufferedStream;
        }
        this.dataStreamIn = new LineReader(tempStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(db.databaseProperties.isVersion18());
    }

    @Override
    protected void readDDL(Session session) {
        while (this.readLoggedStatement(session)) {
            Statement cs = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                cs = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(cs, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e);
            }
            if (result.isError() && cs != null && (cs.getType() == 48 || cs.getType() == 14 && result.getMainString().indexOf("org.hsqldb.Library") > -1) || !result.isError()) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            if (cs != null && cs.getType() == 14) continue;
            HsqlException e = Error.error(result.getException(), 461, 25, new Object[]{Integer.toString(this.lineCount) + " " + this.database.getCanonicalPath(), result.getMainString()});
            this.handleException(e);
        }
    }

    @Override
    protected void readExistingData(Session session) {
        try {
            String tablename = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                    tablename = null;
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(tablename)) {
                        tablename = this.rowIn.getTableName();
                        String schema = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(session, tablename, schema);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    try {
                        this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                    }
                    catch (HsqlException ex) {
                        this.handleException(ex);
                    }
                } else {
                    throw Error.error(461, this.statement);
                }
                this.isInsert = false;
            }
            this.database.setReferentialIntegrity(true);
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("readExistingData failed " + this.lineCount, t);
            throw Error.error(t, 461, 25, new Object[]{new Integer(this.lineCount), t.toString()});
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw Error.error(e, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int endid = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
            this.statement = this.statement.substring(endid + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(this.statement);
        this.statementType = this.rowIn.getStatementType();
        if (this.statementType == 1) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 4) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 6) {
            this.rowData = null;
            this.currentTable = null;
            this.currentSchema = this.rowIn.getSchemaName();
            return;
        }
        String name = this.rowIn.getTableName();
        String schema = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(session, name, schema);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        this.rowData = this.rowIn.readData(colTypes);
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleException(HsqlException e) {
        if (this.database.recoveryMode == 0) {
            throw e;
        }
        if (this.scrwriter == null) {
            String name = this.database.getPath() + ".reject";
            this.scrwriter = new ScriptWriterText(this.database, name, true, true, true);
        }
        try {
            this.scrwriter.writeLogStatement(null, this.rawStatement);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

