/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner;
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean version18;
    boolean noSeparators;
    Calendar tempCalDefault = new GregorianCalendar();

    public RowInputTextLog() {
        super(new byte[0]);
        this.scanner = new Scanner();
    }

    public RowInputTextLog(boolean version18) {
        super(new byte[0]);
        this.scanner = new Scanner();
        this.version18 = version18;
    }

    public void setSource(String text) {
        this.scanner.reset(text);
        this.statementType = 1;
        this.scanner.scanNext();
        String s = this.scanner.getString();
        if (s.equals("INSERT")) {
            this.statementType = 3;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
            this.scanner.scanNext();
        } else if (s.equals("DELETE")) {
            this.statementType = 2;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
        } else if (s.equals("COMMIT")) {
            this.statementType = 4;
        } else if (s.equals("SET")) {
            this.scanner.scanNext();
            if ("SCHEMA".equals(this.scanner.getString())) {
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean minus;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl = minus = this.scanner.getTokenType() == 814;
        if (minus) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (minus) {
            try {
                this.value = ((NumberType)this.scanner.getDataType()).negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    @Override
    public String readString() {
        this.readField();
        return (String)this.value;
    }

    @Override
    public char readChar() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public byte readByte() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public short readShort() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readInt() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public long readLong() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readType() {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    @Override
    protected Long readBigint() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (Long)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double readReal() {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object divisor = this.scanner.getValue();
        double i = ((Number)divisor).doubleValue();
        if (i != 0.0) throw Error.error(5584);
        if (((Number)this.value).doubleValue() == 1.0) {
            i = Double.NEGATIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            i = Double.POSITIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5584);
            i = Double.NaN;
        }
        this.value = i;
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bd = (BigDecimal)type.convertToDefaultType(null, this.value);
        return bd;
    }

    @Override
    protected TimeData readTime(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Time dateTime = Time.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, dateTime.getTime());
            millis = HsqlDateTime.getNormalisedTime(millis);
            return new TimeData((int)millis / 1000, 0, 0);
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Date dateTime = Date.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, dateTime.getTime());
            millis = HsqlDateTime.getNormalisedDate(millis);
            return new TimestampData(millis / 1000L);
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Timestamp dateTime = Timestamp.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, dateTime.getTime());
            int nanos = dateTime.getNanos();
            DateTimeType cfr_ignored_0 = (DateTimeType)type;
            nanos = DateTimeType.normaliseFraction(nanos, type.scale);
            return new TimestampData(millis / 1000L, nanos, 0);
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (token.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 880) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    @Override
    protected BinaryData readBit() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 879) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 880) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new BlobDataID(id);
    }

    @Override
    protected Object[] readArray(Type type) {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!token.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        this.scanner.scanNext();
        token = this.scanner.getString();
        if (!token.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList list = new HsqlArrayList();
        this.noSeparators = true;
        int i = 0;
        while (!this.scanner.scanSpecialIdentifier("]")) {
            if (i > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object value = this.readData(type);
            list.add(value);
            ++i;
        }
        this.noSeparators = false;
        Object[] data = new Object[list.size()];
        list.toArray(data);
        return data;
    }
}

