/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.TextCache;

public class TextTableStorageManager {
    private HashMap textCacheList = new HashMap();

    TextTableStorageManager() {
    }

    public DataFileCache openTextFilePersistence(Table table, String source, boolean readOnlyData, boolean reversed) {
        this.closeTextCache(table);
        TextCache c = new TextCache(table, source);
        c.open(readOnlyData);
        this.textCacheList.put(table.getName(), c);
        return c;
    }

    public void closeTextCache(Table table) {
        TextCache c = (TextCache)this.textCacheList.remove(table.getName());
        if (c != null) {
            try {
                c.close();
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    public void closeAllTextCaches(boolean delete) {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            TextCache textCache = (TextCache)it.next();
            if (delete && !textCache.table.isDataReadOnly()) {
                textCache.purge();
                continue;
            }
            textCache.close();
        }
    }

    public boolean isAnyTextCacheModified() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (!((TextCache)it.next()).isModified()) continue;
            return true;
        }
        return false;
    }
}

