/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader {
    private RandomAccessInterface dataFile;
    private RowInputInterface rowIn;
    private TextFileSettings textFileSettings;
    private String header;
    private boolean isReadOnly;
    private HsqlByteArrayOutputStream buffer;

    TextFileReader(RandomAccessInterface dataFile, TextFileSettings textFileSettings, RowInputInterface rowIn, boolean isReadOnly) {
        this.dataFile = dataFile;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowIn;
        this.isReadOnly = isReadOnly;
        this.buffer = new HsqlByteArrayOutputStream(128);
    }

    public RowInputInterface readObject(long pos) {
        boolean hasQuote = false;
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        this.buffer.reset();
        pos = this.findNextUsedLinePos(pos);
        if (pos == -1L) {
            return null;
        }
        try {
            this.dataFile.seek(pos);
            while (!complete) {
                int c = this.dataFile.read();
                wasNormal = false;
                if (c == -1) {
                    if (this.buffer.size() == 0) {
                        return null;
                    }
                    complete = true;
                    if (wasCR || this.isReadOnly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    this.buffer.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
                switch (c) {
                    case 34: {
                        wasNormal = true;
                        complete = wasCR;
                        wasCR = false;
                        if (!this.textFileSettings.isQuoted) break;
                        hasQuote = !hasQuote;
                        break;
                    }
                    case 13: {
                        wasCR = !hasQuote;
                        break;
                    }
                    case 10: {
                        complete = !hasQuote;
                        break;
                    }
                    default: {
                        wasNormal = true;
                        complete = wasCR;
                        wasCR = false;
                    }
                }
                this.buffer.write(c);
            }
            if (complete) {
                String rowString;
                if (wasNormal) {
                    this.buffer.setPosition(this.buffer.size() - 1);
                }
                try {
                    rowString = this.buffer.toString(this.textFileSettings.stringEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    rowString = this.buffer.toString();
                }
                ((RowInputText)this.rowIn).setSource(rowString, pos, this.buffer.size());
                return this.rowIn;
            }
            return null;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    public int readHeaderLine() {
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        this.buffer.reset();
        try {
            this.dataFile.seek(0L);
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
        while (!complete) {
            int c;
            wasNormal = false;
            try {
                c = this.dataFile.read();
                if (c == -1) {
                    if (this.buffer.size() == 0) {
                        return 0;
                    }
                    complete = true;
                    if (this.isReadOnly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    this.buffer.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
            }
            catch (IOException e) {
                throw Error.error(483);
            }
            switch (c) {
                case 13: {
                    wasCR = true;
                    break;
                }
                case 10: {
                    complete = true;
                    break;
                }
                default: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                }
            }
            if (wasCR || complete) continue;
            this.buffer.write(c);
        }
        if (wasNormal) {
            this.buffer.setPosition(this.buffer.size() - 1);
        }
        try {
            this.header = this.buffer.toString(this.textFileSettings.stringEncoding);
        }
        catch (UnsupportedEncodingException e) {
            this.header = this.buffer.toString();
        }
        return this.buffer.size();
    }

    private long findNextUsedLinePos(long pos) {
        try {
            long firstPos = pos;
            long currentPos = pos;
            boolean wasCR = false;
            this.dataFile.seek(pos);
            block8: while (true) {
                int c = this.dataFile.read();
                ++currentPos;
                switch (c) {
                    case 13: {
                        wasCR = true;
                        continue block8;
                    }
                    case 10: {
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        firstPos = currentPos;
                        continue block8;
                    }
                    case 32: {
                        if (!wasCR) continue block8;
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1L;
                    }
                }
                break;
            }
            if (wasCR) {
                wasCR = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return firstPos;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    public String getHeaderLine() {
        return this.header;
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }
}

