/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;

public abstract class SimpleStore
implements PersistentStore {
    public DataFileCache cache;
    protected TableSpaceManager spaceManager;
    protected int defaultObjectSize;

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(long i) {
        return this.cache.get(i, (PersistentStore)this, false);
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return this.cache.get(object, (PersistentStore)this, keep);
    }

    @Override
    public CachedObject get(long i, boolean keep) {
        return this.cache.get(i, (PersistentStore)this, keep);
    }

    @Override
    public void remove(CachedObject object) {
        if (this.cache != null) {
            this.cache.remove(object);
            this.spaceManager.release(object.getPos(), object.getStorageSize());
        }
    }

    @Override
    public boolean canRead(Session session, long pos, int mode, int[] colMap) {
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject object, int mode, int[] colMap) {
        return true;
    }

    @Override
    public void commitPersistence(CachedObject object) {
    }

    @Override
    public int getDefaultObjectSize() {
        return this.defaultObjectSize;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        throw Error.runtimeError(201, "PersistentStore");
    }

    @Override
    public void removeAll() {
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public TableSpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    @Override
    public void setSpaceManager(TableSpaceManager manager) {
        this.spaceManager = manager;
    }

    @Override
    public boolean isMemory() {
        return this.cache == null;
    }

    @Override
    public void reindex(Session session, Index index) {
    }

    @Override
    public void setCache(DataFileCache cache) {
        this.cache = cache;
    }

    @Override
    public void release() {
    }

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        return null;
    }

    @Override
    public double searchCost(Session session, Index idx, int count, int opType) {
        return 1.0;
    }

    @Override
    public long elementCount() {
        return 0L;
    }

    @Override
    public long elementCount(Session session) {
        return 0L;
    }

    @Override
    public long elementCountUnique(Index index) {
        return 0L;
    }

    @Override
    public void setElementCount(Index key, long size, long uniqueSize) {
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
    }

    @Override
    public void setAccessor(Index key, long accessor) {
    }

    @Override
    public boolean hasNull(int pos) {
        return false;
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] keys) {
    }

    @Override
    public void setMemory(boolean mode) {
    }

    @Override
    public void delete(Session session, Row row) {
    }

    @Override
    public CachedObject get(CachedObject object, RowInputInterface in) {
        return object;
    }

    @Override
    public void indexRow(Session session, Row row) {
    }

    @Override
    public void indexRows(Session session) {
    }

    @Override
    public RowIterator rowIterator() {
        return null;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public Index[] getAccessorKeys() {
        return null;
    }

    @Override
    public void moveDataToSpace(Session session) {
    }

    @Override
    public void moveData(Session session, PersistentStore other, int colindex, int adjust) {
    }

    @Override
    public void setReadOnly(boolean readonly) {
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    @Override
    public TableBase getTable() {
        return null;
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    @Override
    public void setTimestamp(long timestamp) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
    }

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
    }
}

