/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    Session session;

    public RowStoreAVLHybridExtended(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        super(session, manager, table, diskBased);
        this.session = session;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        return super.getNewCachedObject(session, object, tx);
    }

    @Override
    public synchronized void add(Session session, CachedObject object, boolean tx) {
        super.add(session, object, tx);
        if (tx) {
            RowAction.addInsertAction(session, (Table)this.table, (Row)object);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (this.isCached ^ !row.isMemory() || count != this.indexList.length) {
            row = (Row)this.getNewCachedObject(session, row.getData(), true);
        }
        super.indexRow(session, row);
    }

    @Override
    public void delete(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (this.isCached ^ !row.isMemory() || count != this.indexList.length) {
            row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        }
        if (row != null) {
            super.delete(session, row);
        }
    }

    @Override
    public CachedObject getAccessor(Index key) {
        return super.getAccessor(key);
    }

    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached(keys);
            return;
        }
        super.resetAccessorKeys(session, keys);
    }

    private void resetAccessorKeysForCached(Index[] keys) {
        TableBase newTable = this.table.duplicate();
        newTable.persistenceId = this.table.persistenceId;
        newTable.setIndexes(keys);
        RowStoreAVLHybridExtended tempStore = new RowStoreAVLHybridExtended(this.session, this.manager, newTable, true);
        tempStore.changeToDiskTable(this.session);
        RowIterator iterator = this.rowIterator();
        while (iterator.hasNext()) {
            Row row = iterator.getNextRow();
            Row newRow = (Row)((RowStoreAVLHybrid)tempStore).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVLHybrid)tempStore).indexRow(this.session, newRow);
        }
        this.indexList = keys;
        this.accessorList = tempStore.accessorList;
    }
}

