/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    DataFileCache cache;
    private int maxMemoryRowCount;
    private boolean useDisk;
    boolean isCached;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        this.manager = manager;
        this.table = table;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.useDisk = diskBased;
        if (this.maxMemoryRowCount == 0) {
            this.useDisk = false;
        }
        if (table.getTableType() == 9) {
            this.setTimestamp(session.getActionTimestamp());
        }
        this.resetAccessorKeys(session, table.getIndexList());
        this.nullsList = new boolean[table.getColumnCount()];
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public void setMemory(boolean mode) {
        this.useDisk = !mode;
    }

    @Override
    public synchronized int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(long i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(long i, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, keep);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(object, (PersistentStore)this, keep);
            }
            return object;
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public void add(Session session, CachedObject object, boolean tx) {
        if (this.isCached) {
            int size = object.getRealSize(this.cache.rowOut);
            size += this.indexList.length * 16;
            size = this.cache.rowOut.getStorageSize(size);
            object.setStorageSize(size);
            long pos = this.tableSpace.getFilePosition(size, false);
            object.setPos(pos);
            this.cache.add(object, false);
        }
        Object[] data = ((Row)object).getData();
        for (int i = 0; i < this.nullsList.length; ++i) {
            if (data[i] != null) continue;
            this.nullsList[i] = true;
        }
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, in);
            }
        }
        catch (HsqlException e) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVL row;
        if (!this.isCached && this.useDisk && this.elementCount.get() >= (long)this.maxMemoryRowCount) {
            this.changeToDiskTable(session);
        }
        if (this.isCached) {
            row = new RowAVLDisk(this.table, (Object[])object, this);
        } else {
            int id = this.rowIdSequence++;
            row = new RowAVL(this.table, (Object[])object, id, this);
        }
        this.add(session, row, tx);
        return row;
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
        }
        catch (HsqlException e) {
            throw e;
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void removeAll() {
        if (!this.isCached) {
            this.destroy();
        }
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
        for (int i = 0; i < this.nullsList.length; ++i) {
            this.nullsList[i] = false;
        }
    }

    @Override
    public void remove(CachedObject object) {
        if (this.isCached) {
            this.cache.remove(object);
        }
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void postCommitAction(Session session, RowAction action) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.remove(row);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row);
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        if (!this.isCached) {
            this.destroy();
        }
        if (this.isCached) {
            this.cache.adjustStoreCount(-1);
            this.cache = null;
            this.isCached = false;
        }
        this.manager.removeStore(this.table);
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        NodeAVL node = (NodeAVL)this.accessorList[key.getPosition()];
        if (node == null) {
            return null;
        }
        RowAVL row = (RowAVL)this.get((CachedObject)node.getRow(this), false);
        node = row.getNode(key.getPosition());
        this.accessorList[key.getPosition()] = node;
        return node;
    }

    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(session, keys);
    }

    @Override
    public boolean hasNull(int pos) {
        return this.nullsList[pos];
    }

    public final void changeToDiskTable(Session session) {
        this.cache = ((PersistentStoreCollectionSession)this.manager).getSessionDataCache();
        this.maxMemoryRowCount = Integer.MAX_VALUE;
        if (this.cache == null) {
            return;
        }
        this.tableSpace = this.cache.spaceManager.getTableSpace(7);
        this.isCached = true;
        this.cache.adjustStoreCount(1);
        if (this.elementCount.get() == 0L) {
            return;
        }
        IndexAVL idx = (IndexAVL)this.indexList[0];
        NodeAVL root = (NodeAVL)this.accessorList[0];
        RowIterator iterator = this.table.rowIterator(this);
        ArrayUtil.fillArray(this.accessorList, null);
        ArrayUtil.fillArray(this.nullsList, false);
        this.elementCount.set(0L);
        while (iterator.hasNext()) {
            Row row = iterator.getNextRow();
            Row newRow = (Row)this.getNewCachedObject(session, row.getData(), false);
            this.indexRow(session, newRow);
        }
        idx.unlinkNodes(root);
    }
}

