/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLMemory;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.EventLogInterface;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLHybridExtended;
import org.hsqldb.persist.RowStoreAVLMemory;
import org.hsqldb.persist.RowStoreDataChange;
import org.hsqldb.persist.TextTableStorageManager;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Logger
implements EventLogInterface {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private Database database;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean syncFile = false;
    private boolean propIsFileDatabase;
    boolean propIncrementBackup;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks = 512;
    int propMinReuse = 0;
    private int propCacheMaxRows;
    private long propCacheMaxSize;
    int propCacheDefragLimit;
    private int propDataFileScale;
    String propTextSourceDefault = "";
    boolean propTextAllowFullPath;
    private int propWriteDelay;
    private int propLogSize;
    private boolean propLogData = true;
    private int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    boolean propCompressLobs;
    int propScriptFormat = 0;
    boolean propLargeData;
    int propFileSpaceValue;
    long propFileTimestamp;
    Log log;
    private LockFile lockFile;
    private Crypto crypto;
    boolean cryptLobs;
    public FileAccess fileAccess;
    public boolean isStoredFileAccess;
    public boolean isNewStoredFileAccess;
    String tempDirectoryPath;
    public TextTableStorageManager textTableManager = new TextTableStorageManager();
    public boolean isNewDatabase;
    public boolean isSingleFile;
    AtomicInteger backupState = new AtomicInteger();
    AtomicInteger checkpointState = new AtomicInteger();
    static final int largeDataFactor = 128;
    static final int stateNormal = 0;
    static final int stateBackup = 1;
    static final int stateCheckpoint = 2;
    static final int stateCheckpointNormal = 0;
    static final int stateCheckpointRequired = 1;
    static final int stateCheckpointDue = 2;
    public static final String oldFileExtension = ".old";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String logFileExtension = ".log";
    public static final String scriptFileExtension = ".script";
    public static final String propertiesFileExtension = ".properties";
    public static final String dataFileExtension = ".data";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String lockFileExtension = ".lck";
    SimpleDateFormat backupFileFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private Character runtimeFileDelim = new Character(System.getProperty("file.separator").charAt(0));
    DbBackup backup;

    public Logger(Database database) {
        this.database = database;
    }

    public void open() {
        int level;
        boolean version18;
        String fileaccess_class_name = this.database.getURLProperties().getProperty("fileaccess_class_name");
        String storage_class_name = this.database.getURLProperties().getProperty("storage_class_name");
        boolean hasFileProps = false;
        boolean hasScript = false;
        if (fileaccess_class_name != null) {
            String storagekey = this.database.getURLProperties().getProperty("storage_key");
            try {
                Class<?> fileAccessClass = null;
                Class<RandomAccessInterface> storageClass = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    fileAccessClass = classLoader.loadClass(fileaccess_class_name);
                    storageClass = classLoader.loadClass(storage_class_name);
                }
                catch (ClassNotFoundException e) {
                    fileAccessClass = Class.forName(fileaccess_class_name);
                    storageClass = Class.forName(storage_class_name);
                }
                if (storageClass.isAssignableFrom(RandomAccessInterface.class)) {
                    this.isNewStoredFileAccess = true;
                }
                Constructor<?> constructor = fileAccessClass.getConstructor(Object.class);
                this.fileAccess = (FileAccess)constructor.newInstance(storagekey);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException e) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException e) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception e) {
                System.out.println("Exception");
            }
        } else {
            this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        }
        this.propIsFileDatabase = DatabaseURL.isFileBasedDatabaseType(this.database.getType());
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        if (this.propIsFileDatabase) {
            boolean exists;
            hasFileProps = this.database.databaseProperties.load();
            hasScript = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension);
            if (this.database.databaseProperties.isVersion18()) {
                exists = hasFileProps;
                this.database.databaseProperties.setProperty("hsqldb.inc_backup", false);
            } else {
                exists = hasScript;
                if (!exists && (exists = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension + newFileExtension))) {
                    this.database.databaseProperties.setDBModified(2);
                }
            }
            this.isNewDatabase = !exists;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            String name = this.newUniqueName();
            this.database.setUniqueName(name);
            boolean checkExists = this.database.isFilesInJar();
            if (checkExists |= this.database.urlProperties.isPropertyTrue("ifexists") || !this.database.urlProperties.isPropertyTrue("create", true)) {
                throw Error.error(465, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            if (!hasFileProps) {
                this.database.databaseProperties.setDBModified(1);
            }
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
            if (!this.database.urlProperties.isPropertyTrue("hsqldb.lock_file", true)) {
                this.database.databaseProperties.setProperty("hsqldb.lock_file", false);
            }
        }
        this.setVariables();
        String appLogPath = null;
        String sqlLogPath = null;
        if (this.propIsFileDatabase && !this.database.isFilesReadOnly()) {
            appLogPath = this.database.getPath() + appLogFileExtension;
            sqlLogPath = this.database.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(appLogPath, this.propEventLogLevel, false);
        this.sqlLog = new SimpleLog(sqlLogPath, this.propSqlLogLevel, true);
        this.database.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.checkpointState.set(0);
        this.logsStatements = false;
        boolean useLock = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (useLock && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        if (version18 = this.database.databaseProperties.isVersion18()) {
            this.database.setUniqueName(this.newUniqueName());
            this.database.schemaManager.createPublicSchema();
            HsqlNameManager.HsqlName name = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
            this.database.schemaManager.setDefaultSchemaHsqlName(name);
        }
        this.log = new Log(this.database);
        this.log.open();
        this.logsStatements = true;
        boolean bl = this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        if (version18) {
            this.checkpoint(false);
        }
        if (this.database.getUniqueName() == null) {
            this.database.setUniqueName(this.newUniqueName());
        }
        if ((level = this.database.urlProperties.getIntegerProperty("hsqldb.applog", -1)) >= 0) {
            this.setEventLogLevel(level, false);
        }
        if ((level = this.database.urlProperties.getIntegerProperty("hsqldb.sqllog", -1)) >= 0) {
            this.setEventLogLevel(level, true);
        }
    }

    private void setVariables() {
        String txMode;
        String tableType;
        String cryptKey = this.database.urlProperties.getProperty("crypt_key");
        if (cryptKey != null) {
            String cryptType = this.database.urlProperties.getProperty("crypt_type");
            String cryptProvider = this.database.urlProperties.getProperty("crypt_provider");
            this.crypto = new Crypto(cryptKey, cryptType, cryptProvider);
            this.cryptLobs = this.database.urlProperties.isPropertyTrue("crypt_lobs", true);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == "mem:" || this.isStoredFileAccess ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = this.database.databaseProperties.getIntegerProperty("hsqldb.script_format");
        boolean version18 = this.database.databaseProperties.isVersion18();
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count");
        this.propMaxFreeBlocks = ArrayUtil.getTwoPowerFloor(this.propMaxFreeBlocks);
        if (this.database.urlProperties.isPropertyTrue("hsqldb.large_data", false)) {
            this.propLargeData = true;
        }
        if (!this.database.databaseProperties.isPropertyTrue("sql.pad_space", true)) {
            this.database.collation.setPadding(false);
        }
        if (version18 && this.isStoredFileAccess) {
            this.database.collation.setPadding(false);
        }
        String temp = this.database.getProperties().getStringPropertyDefault("hsqldb.digest");
        this.database.granteeManager.setDigestAlgo(temp);
        if (!this.isNewDatabase && !version18) {
            return;
        }
        temp = this.database.databaseProperties.getStringProperty("hsqldb.digest");
        this.database.granteeManager.setDigestAlgo(temp);
        if (this.tempDirectoryPath != null) {
            int rows = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(rows);
        }
        if ("CACHED".equalsIgnoreCase(tableType = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(5);
        }
        if ("MVCC".equalsIgnoreCase(txMode = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        String txLevel = this.database.databaseProperties.getStringProperty("hsqldb.tx_level");
        this.database.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(txLevel) ? 8 : 2;
        this.database.txConflictRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_conflict_rollback");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        this.database.sqlRegularNames = this.database.databaseProperties.isPropertyTrue("sql.regular_names");
        this.database.sqlEnforceRefs = this.database.databaseProperties.isPropertyTrue("sql.enforce_refs");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceTypes = this.database.databaseProperties.isPropertyTrue("sql.enforce_types");
        this.database.sqlEnforceTDCD = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_delete");
        this.database.sqlEnforceTDCU = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_update");
        this.database.sqlTranslateTTI = this.database.databaseProperties.isPropertyTrue("jdbc.translate_tti_types");
        this.database.sqlConcatNulls = this.database.databaseProperties.isPropertyTrue("sql.concat_nulls");
        this.database.sqlNullsFirst = this.database.databaseProperties.isPropertyTrue("sql.nulls_first");
        this.database.sqlNullsOrder = this.database.databaseProperties.isPropertyTrue("sql.nulls_order");
        this.database.sqlUniqueNulls = this.database.databaseProperties.isPropertyTrue("sql.unique_nulls");
        this.database.sqlConvertTruncate = this.database.databaseProperties.isPropertyTrue("sql.convert_trunc");
        this.database.sqlAvgScale = this.database.databaseProperties.getIntegerProperty("sql.avg_scale");
        this.database.sqlDoubleNaN = this.database.databaseProperties.isPropertyTrue("sql.double_nan");
        this.database.sqlLongvarIsLob = this.database.databaseProperties.isPropertyTrue("sql.longvar_is_lob");
        this.database.sqlIgnoreCase = this.database.databaseProperties.isPropertyTrue("sql.ignore_case");
        this.database.sqlSyntaxDb2 = this.database.databaseProperties.isPropertyTrue("sql.syntax_db2");
        this.database.sqlSyntaxMss = this.database.databaseProperties.isPropertyTrue("sql.syntax_mss");
        this.database.sqlSyntaxMys = this.database.databaseProperties.isPropertyTrue("sql.syntax_mys");
        this.database.sqlSyntaxOra = this.database.databaseProperties.isPropertyTrue("sql.syntax_ora");
        this.database.sqlSyntaxPgs = this.database.databaseProperties.isPropertyTrue("sql.syntax_pgs");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propSqlLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.sqllog");
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        this.propIncrementBackup = this.database.databaseProperties.isPropertyTrue("hsqldb.inc_backup");
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propNioMaxSize = (long)(this.database.databaseProperties.getIntegerProperty("hsqldb.nio_max_size") * 1024) * 1024L;
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = (long)this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024L;
        this.setLobFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.lob_file_scale"));
        this.setDataFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale"));
        int fileSpace = this.database.databaseProperties.getIntegerProperty("hsqldb.files_space", 0);
        if (fileSpace != 0) {
            this.setDataFileSpaces(fileSpace);
        }
        this.propCacheDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propWriteDelay = this.database.databaseProperties.getIntegerProperty("hsqldb.write_delay_millis");
        if (!this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.propLogSize = this.database.databaseProperties.getIntegerProperty("hsqldb.log_size");
        this.propLogData = this.database.databaseProperties.isPropertyTrue("hsqldb.log_data");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = this.database.databaseProperties.isPropertyTrue("sql.ref_integrity");
        this.setCacheMinReuseSize(this.database.databaseProperties.getIntegerProperty("hsqldb.min_reuse"));
    }

    public boolean close(int closemode) {
        boolean result = true;
        if (this.log == null) {
            this.textTableManager.closeAllTextCaches(false);
            return true;
        }
        this.log.synchLog();
        this.database.lobManager.synch();
        try {
            switch (closemode) {
                case 1: {
                    this.log.shutdown();
                    break;
                }
                case 2: {
                    this.log.close(false);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.close(true);
                }
            }
            this.database.persistentStoreCollection.release();
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("error closing log", e);
            result = false;
        }
        this.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.sqlLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return result;
    }

    String newUniqueName() {
        String name = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        name = "HSQLDB" + name.substring(6).toUpperCase(Locale.ENGLISH);
        return name;
    }

    public boolean isLogged() {
        return this.propIsFileDatabase && !this.database.isFilesReadOnly();
    }

    public boolean isCurrentlyLogged() {
        return this.loggingEnabled;
    }

    public boolean isAllowedFullPath() {
        return this.propTextAllowFullPath;
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String name = this.database.getUniqueName();
        if (name == null) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "hsqldb.db." + this.database.getUniqueName());
    }

    public void setEventLogLevel(int level, boolean logSql) {
        if (level < 0 || level > 4) {
            throw Error.error(5556);
        }
        if (logSql) {
            this.propSqlLogLevel = level;
            this.sqlLog.setLevel(level);
        } else {
            if (level > 3) {
                level = 3;
            }
            this.propEventLogLevel = level;
            this.appLog.setLevel(level);
        }
    }

    @Override
    public void logSevereEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.severe(message, t);
        }
        if (this.appLog != null) {
            if (t == null) {
                this.appLog.logContext(1, message);
            } else {
                this.appLog.logContext(t, message, 1);
            }
        }
    }

    @Override
    public void logWarningEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.warning(message, t);
        }
        this.appLog.logContext(t, message, 1);
    }

    @Override
    public void logInfoEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.info(message);
        }
        this.appLog.logContext(2, message);
    }

    @Override
    public void logDetailEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.finest(message);
        }
        if (this.appLog != null) {
            this.appLog.logContext(3, message);
        }
    }

    public void logStatementEvent(Session session, Statement statement, Object[] paramValues, Result result, int level) {
        if (this.sqlLog != null && level <= this.propSqlLogLevel) {
            String sessionId = Long.toString(session.getId());
            String sql = statement.getSQL();
            String values = "";
            int paramLength = 0;
            if (this.propSqlLogLevel < 3) {
                if (sql.length() > 256) {
                    sql = sql.substring(0, 256);
                }
                paramLength = 32;
            }
            if (paramValues != null && paramValues.length > 0) {
                values = RowType.convertToSQLString(paramValues, statement.getParametersMetaData().getParameterTypes(), paramLength);
            }
            if (this.propSqlLogLevel == 4) {
                StringBuffer sb = new StringBuffer(values);
                sb.append(' ').append('[');
                if (result.isError()) {
                    sb.append(result.getErrorCode());
                } else if (result.isData()) {
                    sb.append(result.getNavigator().getSize());
                } else if (result.isUpdateCount()) {
                    sb.append(result.getUpdateCount());
                }
                sb.append(']');
                values = sb.toString();
            }
            this.sqlLog.logContext(level, sessionId, sql, values);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    public DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void writeOtherStatement(Session session, String statement) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Row row, Table table) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, row, table);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
        }
    }

    public synchronized void synchLog() {
        if (this.loggingEnabled) {
            this.log.synchLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkpoint(boolean mode) {
        if (!this.backupState.compareAndSet(0, 2)) {
            throw Error.error(457);
        }
        try {
            this.checkpointInternal(mode);
        }
        finally {
            this.backupState.set(0);
            this.checkpointState.set(0);
        }
    }

    void checkpointInternal(boolean mode) {
        if (this.logsStatements) {
            this.logInfoEvent("Checkpoint start");
            this.log.checkpoint(mode);
            this.logInfoEvent("Checkpoint end - txts: " + this.database.txManager.getGlobalChangeTimestamp());
        } else if (!this.isFileDatabase()) {
            this.database.lobManager.deleteUnusedLobs();
        }
    }

    public synchronized void setLogSize(int megas) {
        this.propLogSize = megas;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setLogData(boolean mode) {
        this.propLogData = mode;
        this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        this.loggingEnabled &= this.logsStatements;
    }

    public synchronized void setScriptType(int format) {
        if (format == this.propScriptFormat) {
            return;
        }
        this.propScriptFormat = format;
        this.checkpointState.compareAndSet(0, 1);
    }

    public synchronized void setWriteDelay(int delay) {
        this.propWriteDelay = delay;
        if (this.log != null) {
            this.syncFile = delay == 0;
            this.log.setWriteDelay(delay);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public synchronized void setIncrementBackup(boolean val) {
        if (val == this.propIncrementBackup) {
            return;
        }
        if (this.log != null) {
            this.log.setIncrementBackup(val);
            if (this.log.hasCache()) {
                this.checkpointState.compareAndSet(0, 1);
            }
        }
        this.propIncrementBackup = val;
    }

    public void setCacheMaxRows(int value) {
        this.propCacheMaxRows = value;
    }

    public int getCacheMaxRows() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int value) {
        this.propCacheMaxSize = (long)value * 1024L;
    }

    public long getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setCacheMinReuseSize(int value) {
        this.propMinReuse = ArrayUtil.getTwoPowerFloor(value);
    }

    public void setDataFileScale(int value) {
        if (this.propDataFileScale == value) {
            return;
        }
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        if (this.hasCache()) {
            throw Error.error(469);
        }
        this.propDataFileScale = value;
    }

    public void setDataFileScaleNoCheck(int value) {
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        this.propDataFileScale = value;
    }

    public int getDataFileScale() {
        return this.propDataFileScale;
    }

    public int getDataFileFactor() {
        return this.propLargeData ? 128 : 1;
    }

    public void setDataFileSpaces(boolean value) {
        if (value) {
            this.setDataFileSpaces(this.propDataFileScale / 16);
        } else {
            this.setDataFileSpaces(0);
        }
    }

    public void setDataFileSpaces(int value) {
        if (this.propFileSpaceValue == value) {
            return;
        }
        if (value != 0) {
            Logger.checkPower(value, 6);
        }
        if (value > this.propDataFileScale / 16) {
            value = this.propDataFileScale / 16;
        }
        this.propFileSpaceValue = value;
        if (this.hasCache()) {
            DataFileCache dataCache = this.getCache();
            boolean result = dataCache.setDataSpaceManager();
            if (!result) {
                return;
            }
            this.database.persistentStoreCollection.setNewTableSpaces();
        }
    }

    public int getDataFileSpaces() {
        return this.propFileSpaceValue;
    }

    public long getFilesTimestamp() {
        return this.propFileTimestamp;
    }

    public void setFilesTimestamp(long value) {
        this.propFileTimestamp = value;
    }

    public void setLobFileScale(int value) {
        if (this.propLobBlockSize == value * 1024) {
            return;
        }
        Logger.checkPower(value, 5);
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = value * 1024;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int value) {
        Logger.checkPower(value, 5);
        this.propLobBlockSize = value * 1024;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setLobFileCompressed(boolean value) {
        if (this.propCompressLobs == value) {
            return;
        }
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propCompressLobs = value;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileCompressedNoCheck(boolean value) {
        this.propCompressLobs = value;
    }

    public void setDefagLimit(int value) {
        this.propCacheDefragLimit = value;
    }

    public int getDefragLimit() {
        return this.propCacheDefragLimit;
    }

    public void setDefaultTextTableProperties(String source, HsqlProperties props) {
        props.setProperty("check_props", true);
        this.database.getProperties().setURLProperties(props);
        this.propTextSourceDefault = source;
    }

    public void setNioDataFile(boolean value) {
        this.propNioDataFile = value;
    }

    public void setNioMaxSize(int value) {
        if (value < 8) {
            throw Error.error(5556);
        }
        if (!(ArrayUtil.isTwoPower(value, 10) || value >= 1024 && value % 512 == 0)) {
            throw Error.error(5556);
        }
        this.propNioMaxSize = (long)value * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    public boolean isNewStoredFileAccess() {
        return this.isNewStoredFileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int max) {
        if (!ArrayUtil.isTwoPower(n, max)) {
            throw Error.error(5556);
        }
    }

    public void setCheckpointRequired() {
        this.checkpointState.compareAndSet(0, 1);
    }

    public boolean needsCheckpointReset() {
        return this.checkpointState.compareAndSet(1, 2);
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String path) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection collection, TableBase table) {
        switch (table.getTableType()) {
            case 5: {
                DataFileCache cache = this.getCache();
                if (cache == null) break;
                return new RowStoreAVLDisk(collection, cache, (Table)table);
            }
            case 4: 
            case 12: {
                return new RowStoreAVLMemory(collection, (Table)table);
            }
            case 7: {
                return new RowStoreAVLDiskData(collection, (Table)table);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, collection, table, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, collection, table, true);
            }
            case 13: {
                return new RowStoreDataChange(session, collection, table);
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, collection, table, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        switch (table.getTableType()) {
            case 1: 
            case 4: 
            case 12: {
                return new IndexAVLMemory(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return new IndexAVL(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(Table table, Index index, int[] columns) {
        boolean[] modeFlags = new boolean[columns.length];
        Object[] colTypes = new Type[columns.length];
        ArrayUtil.projectRow(table.getColumnTypes(), columns, colTypes);
        return this.newIndex(index.getName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false);
    }

    public String getValueStringForProperty(String name) {
        String value = "";
        if ("hsqldb.tx".equals(name)) {
            switch (this.database.txManager.getTransactionControl()) {
                case 2: {
                    value = "MVCC".toLowerCase();
                    break;
                }
                case 1: {
                    value = "MVLOCKS".toLowerCase();
                    break;
                }
                case 0: {
                    value = "LOCKS".toLowerCase();
                }
            }
            return value;
        }
        if ("hsqldb.tx_level".equals(name)) {
            switch (this.database.defaultIsolationLevel) {
                case 2: {
                    value = new StringBuffer("READ").append(' ').append("COMMITTED").toString().toLowerCase();
                    break;
                }
                case 8: {
                    value = "SERIALIZABLE".toLowerCase();
                }
            }
            return value;
        }
        if ("hsqldb.applog".equals(name)) {
            return String.valueOf(this.appLog.getLevel());
        }
        if ("hsqldb.sqllog".equals(name)) {
            return String.valueOf(this.sqlLog.getLevel());
        }
        if ("hsqldb.lob_file_scale".equals(name)) {
            return String.valueOf(this.propLobBlockSize / 1024);
        }
        if ("hsqldb.lob_compressed".equals(name)) {
            return String.valueOf(this.propCompressLobs);
        }
        if ("hsqldb.cache_file_scale".equals(name)) {
            return String.valueOf(this.propDataFileScale);
        }
        if ("hsqldb.cache_free_count".equals(name)) {
            return String.valueOf(this.propMaxFreeBlocks);
        }
        if ("hsqldb.cache_rows".equals(name)) {
            return String.valueOf(this.propCacheMaxRows);
        }
        if ("hsqldb.cache_size".equals(name)) {
            return String.valueOf(this.propCacheMaxSize / 1024L);
        }
        if ("hsqldb.default_table_type".equals(name)) {
            return this.database.schemaManager.getDefaultTableType() == 5 ? "cached" : "memory";
        }
        if ("hsqldb.defrag_limit".equals(name)) {
            return String.valueOf(this.propCacheDefragLimit);
        }
        if ("hsqldb.files_space".equals(name)) {
            return String.valueOf(this.propFileSpaceValue);
        }
        if ("files_readonly".equals(name)) {
            return this.database.databaseProperties.getPropertyString("files_readonly");
        }
        if ("hsqldb.inc_backup".equals(name)) {
            return String.valueOf(this.propIncrementBackup);
        }
        if ("hsqldb.large_data".equals(name)) {
            return String.valueOf(this.propLargeData);
        }
        if ("hsqldb.large_data".equals(name)) {
            return String.valueOf(this.propLargeData);
        }
        if ("hsqldb.lock_file".equals(name)) {
            return this.database.databaseProperties.getPropertyString("hsqldb.lock_file");
        }
        if ("hsqldb.log_data".equals(name)) {
            return String.valueOf(this.propLogData);
        }
        if ("hsqldb.log_size".equals(name)) {
            return String.valueOf(this.propLogSize);
        }
        if ("hsqldb.nio_data_file".equals(name)) {
            return String.valueOf(this.propNioDataFile);
        }
        if ("hsqldb.nio_max_size".equals(name)) {
            return String.valueOf(this.propNioMaxSize / 0x100000L);
        }
        if ("hsqldb.script_format".equals(name)) {
            return ScriptWriterBase.LIST_SCRIPT_FORMATS[this.propScriptFormat].toLowerCase();
        }
        if ("hsqldb.temp_directory".equals(name)) {
            return this.tempDirectoryPath;
        }
        if ("hsqldb.tx_conflict_rollback".equals(name)) {
            return String.valueOf(this.database.txConflictRollback);
        }
        if ("hsqldb.result_max_memory_rows".equals(name)) {
            return String.valueOf(this.database.getResultMaxMemoryRows());
        }
        if ("hsqldb.write_delay".equals(name)) {
            return String.valueOf(this.propWriteDelay != 0);
        }
        if ("hsqldb.write_delay_millis".equals(name)) {
            return String.valueOf(this.propWriteDelay);
        }
        if ("hsqldb.digest".equals(name)) {
            return this.database.granteeManager.getDigestAlgo();
        }
        if ("sql.avg_scale".equals(name)) {
            return String.valueOf(this.database.sqlAvgScale);
        }
        if ("sql.concat_nulls".equals(name)) {
            return String.valueOf(this.database.sqlConcatNulls);
        }
        if ("sql.convert_trunc".equals(name)) {
            return String.valueOf(this.database.sqlConvertTruncate);
        }
        if ("sql.double_nan".equals(name)) {
            return String.valueOf(this.database.sqlDoubleNaN);
        }
        if ("sql.enforce_names".equals(name)) {
            return String.valueOf(this.database.sqlEnforceNames);
        }
        if ("sql.enforce_refs".equals(name)) {
            return String.valueOf(this.database.sqlEnforceRefs);
        }
        if ("sql.enforce_size".equals(name)) {
            return String.valueOf(this.database.sqlEnforceSize);
        }
        if ("sql.enforce_tdc_delete".equals(name)) {
            return String.valueOf(this.database.sqlEnforceTDCD);
        }
        if ("sql.enforce_tdc_update".equals(name)) {
            return String.valueOf(this.database.sqlEnforceTDCU);
        }
        if ("sql.enforce_types".equals(name)) {
            return String.valueOf(this.database.sqlEnforceTypes);
        }
        if ("sql.ignore_case".equals(name)) {
            return String.valueOf(this.database.sqlIgnoreCase);
        }
        if ("sql.longvar_is_lob".equals(name)) {
            return String.valueOf(this.database.sqlLongvarIsLob);
        }
        if ("sql.nulls_first".equals(name)) {
            return String.valueOf(this.database.sqlNullsFirst);
        }
        if ("sql.nulls_order".equals(name)) {
            return String.valueOf(this.database.sqlNullsOrder);
        }
        if ("sql.syntax_db2".equals(name)) {
            return String.valueOf(this.database.sqlSyntaxDb2);
        }
        if ("sql.syntax_mss".equals(name)) {
            return String.valueOf(this.database.sqlSyntaxMss);
        }
        if ("sql.syntax_mys".equals(name)) {
            return String.valueOf(this.database.sqlSyntaxMys);
        }
        if ("sql.syntax_ora".equals(name)) {
            return String.valueOf(this.database.sqlSyntaxOra);
        }
        if ("sql.syntax_pgs".equals(name)) {
            return String.valueOf(this.database.sqlSyntaxPgs);
        }
        if ("sql.ref_integrity".equals(name)) {
            return String.valueOf(this.database.isReferentialIntegrity());
        }
        if ("sql.regular_names".equals(name)) {
            return String.valueOf(this.database.sqlRegularNames);
        }
        if ("sql.unique_nulls".equals(name)) {
            return String.valueOf(this.database.sqlUniqueNulls);
        }
        if ("jdbc.translate_tti_types".equals(name)) {
            return String.valueOf(this.database.sqlTranslateTTI);
        }
        if ("hsqldb.min_reuse".equals(name)) {
            return String.valueOf(this.propMinReuse);
        }
        return null;
    }

    public String[] getPropertiesSQL(boolean indexRoots) {
        int delay;
        boolean millis;
        HsqlArrayList list = new HsqlArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append("SET DATABASE ").append("UNIQUE").append(' ');
        sb.append("NAME").append(' ').append(this.database.getUniqueName());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("GC").append(' ');
        sb.append(this.propGC);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("RESULT").append(' ').append("MEMORY");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.database.getResultMaxMemoryRows());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("EVENT").append(' ');
        sb.append("LOG").append(' ').append("LEVEL");
        sb.append(' ').append(this.propEventLogLevel);
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propSqlLogLevel != 0) {
            sb.append("SET DATABASE ").append("EVENT").append(' ');
            sb.append("LOG").append(' ').append("SQL");
            sb.append(' ').append("LEVEL");
            sb.append(' ').append(this.propEventLogLevel);
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                sb.append("MVCC");
                break;
            }
            case 1: {
                sb.append("MVLOCKS");
                break;
            }
            case 0: {
                sb.append("LOCKS");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("ISOLATION").append(' ').append("LEVEL");
        sb.append(' ');
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                sb.append("READ").append(' ').append("COMMITTED");
                break;
            }
            case 8: {
                sb.append("SERIALIZABLE");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("ROLLBACK").append(' ');
        sb.append("ON").append(' ');
        sb.append("CONFLICT").append(' ');
        sb.append(this.database.txConflictRollback ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TEXT").append(' ');
        sb.append("TABLE").append(' ').append("DEFAULTS");
        sb.append(' ').append('\'');
        sb.append(this.propTextSourceDefault).append('\'');
        list.add(sb.toString());
        sb.setLength(0);
        String temp = this.database.getProperties().getStringPropertyDefault("hsqldb.digest");
        if (!temp.equals(this.database.granteeManager.getDigestAlgo())) {
            sb.append("SET DATABASE ").append(' ').append("PASSWORD");
            sb.append(' ').append("DIGEST").append(' ').append('\'');
            sb.append(this.database.granteeManager.getDigestAlgo()).append('\'');
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.schemaManager.getDefaultTableType() == 5) {
            list.add("SET DATABASE DEFAULT TABLE TYPE CACHED");
        }
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("NAMES").append(' ');
        sb.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (!this.database.sqlRegularNames) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("REGULAR").append(' ');
            sb.append("NAMES").append(' ');
            sb.append(this.database.sqlRegularNames ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("REFERENCES").append(' ');
        sb.append(this.database.sqlEnforceRefs ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("SIZE").append(' ');
        sb.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TYPES").append(' ');
        sb.append(this.database.sqlEnforceTypes ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("DELETE").append(' ');
        sb.append(this.database.sqlEnforceTDCD ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("UPDATE").append(' ');
        sb.append(this.database.sqlEnforceTDCU ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TRANSLATE").append(' ').append("TTI");
        sb.append(' ').append("TYPES").append(' ');
        sb.append(this.database.sqlTranslateTTI ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONCAT").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlConcatNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        if (!this.database.sqlNullsFirst) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("NULLS").append(' ');
            sb.append("FIRST").append(' ');
            sb.append(this.database.sqlNullsFirst ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        if (!this.database.sqlNullsOrder) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("NULLS").append(' ');
            sb.append("ORDER").append(' ');
            sb.append(this.database.sqlNullsOrder ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("UNIQUE").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlUniqueNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONVERT").append(' ');
        sb.append("TRUNCATE").append(' ');
        sb.append(this.database.sqlConvertTruncate ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("AVG").append(' ');
        sb.append("SCALE").append(' ');
        sb.append(this.database.sqlAvgScale);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("DOUBLE").append(' ');
        sb.append("NAN").append(' ');
        sb.append(this.database.sqlDoubleNaN ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.sqlLongvarIsLob) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("LONGVAR").append(' ');
            sb.append("IS").append(' ');
            sb.append("LOB").append(' ');
            sb.append(this.database.sqlLongvarIsLob ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlIgnoreCase) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("IGNORECASE").append(' ');
            sb.append(this.database.sqlIgnoreCase ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxDb2) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("DB2").append(' ');
            sb.append(this.database.sqlSyntaxDb2 ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxMss) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MSS").append(' ');
            sb.append(this.database.sqlSyntaxMss ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxMys) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MYS").append(' ');
            sb.append(this.database.sqlSyntaxMys ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxOra) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("ORA").append(' ');
            sb.append(this.database.sqlSyntaxOra ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxPgs) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("PGS").append(' ');
            sb.append(this.database.sqlSyntaxPgs ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        boolean bl = millis = (delay = this.propWriteDelay) > 0 && delay < 1000;
        if (millis) {
            if (delay < 20) {
                delay = 20;
            }
        } else {
            delay /= 1000;
        }
        sb.append("SET FILES ").append("WRITE").append(' ');
        sb.append("DELAY").append(' ').append(delay);
        if (millis) {
            sb.append(' ').append("MILLIS");
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("BACKUP");
        sb.append(' ').append("INCREMENT").append(' ');
        sb.append(this.propIncrementBackup ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("SIZE").append(' ');
        sb.append(this.propCacheMaxSize / 1024L);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.propCacheMaxRows);
        list.add(sb.toString());
        int fileScale = this.propDataFileScale;
        if (!indexRoots && fileScale < 32) {
            fileScale = 32;
        }
        sb.setLength(0);
        sb.append("SET FILES ").append("SCALE");
        sb.append(' ').append(fileScale);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOB").append(' ').append("SCALE");
        sb.append(' ').append(this.getLobFileScale());
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propCompressLobs) {
            sb.append("SET FILES ").append("LOB").append(' ').append("COMPRESSED");
            sb.append(' ').append(this.propCompressLobs ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET FILES ").append("DEFRAG");
        sb.append(' ').append(this.propCacheDefragLimit);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO");
        sb.append(' ').append(this.propNioDataFile ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO").append(' ').append("SIZE");
        sb.append(' ').append(this.propNioMaxSize / 0x100000L);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append(this.propLogData ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append("SIZE").append(' ').append(this.propLogSize);
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propFileTimestamp != 0L) {
            sb.append("SET FILES ").append("CHECK").append(' ');
            sb.append(this.propFileTimestamp);
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.propFileSpaceValue != 0) {
            sb.append("SET FILES ").append("SPACE").append(' ');
            sb.append(this.propFileSpaceValue);
            list.add(sb.toString());
            sb.setLength(0);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String destPath, boolean script, boolean blocking, boolean compressed, boolean files) {
        if (!this.backupState.compareAndSet(0, 1)) {
            throw Error.error(470, "backup in progress");
        }
        try {
            this.backupInternal(destPath, script, blocking, compressed, files);
        }
        finally {
            this.backupState.set(0);
        }
    }

    void backupInternal(String destPath, boolean script, boolean blocking, boolean compressed, boolean asFiles) {
        block30: {
            File archiveFile;
            boolean generateName;
            String scriptName = null;
            String dbPath = this.database.getPath();
            String instanceName = new File(dbPath).getName();
            char lastChar = destPath.charAt(destPath.length() - 1);
            boolean bl = generateName = lastChar == '/' || lastChar == this.runtimeFileDelim.charValue();
            if (asFiles) {
                if (!generateName) {
                    throw Error.error(null, 462, 0, new String[]{"", "/"});
                }
                if ((destPath = this.getSecurePath(destPath, true, false)) == null) {
                    throw Error.error(470, "access to directory denied");
                }
                archiveFile = new File(destPath);
                archiveFile.mkdirs();
                File[] files = FileUtil.getDatabaseMainFileList(destPath + instanceName);
                if (files == null || files.length != 0) {
                    throw Error.error(470, "files exist in directory");
                }
            } else {
                boolean nameImpliesCompress;
                String defaultSuffix = compressed ? ".tar.gz" : ".tar";
                archiveFile = generateName ? new File(destPath.substring(0, destPath.length() - 1), instanceName + '-' + this.backupFileFormat.format(new Date()) + defaultSuffix) : new File(destPath);
                boolean bl2 = nameImpliesCompress = archiveFile.getName().endsWith(".tar.gz") || archiveFile.getName().endsWith(".tgz");
                if (!nameImpliesCompress && !archiveFile.getName().endsWith(".tar")) {
                    throw Error.error(null, 462, 0, new String[]{archiveFile.getName(), ".tar, .tar.gz, .tgz"});
                }
                if (compressed != nameImpliesCompress) {
                    throw Error.error(null, 463, 0, new Object[]{compressed, archiveFile.getName()});
                }
                if (archiveFile.exists()) {
                    throw Error.error(null, 470, 0, new Object[]{"file exists", archiveFile.getName()});
                }
            }
            if (blocking) {
                this.log.checkpointClose();
            }
            try {
                this.logInfoEvent("Initiating backup of instance '" + instanceName + "'");
                if (script) {
                    String path = this.getTempDirectoryPath();
                    if (path == null) {
                        return;
                    }
                    path = path + "/" + new File(this.database.getPath()).getName();
                    scriptName = path + scriptFileExtension;
                    ScriptWriterText dsw = new ScriptWriterText(this.database, scriptName, true, true, true);
                    dsw.writeAll();
                    dsw.close();
                    this.backup = new DbBackup(archiveFile, path, true);
                    this.backup.write();
                } else {
                    this.backup = new DbBackup(archiveFile, dbPath);
                    this.backup.setAbortUponModify(false);
                    if (!blocking) {
                        long fileLength;
                        InputStreamWrapper isw;
                        File file = null;
                        if (this.hasCache()) {
                            DataFileCache dataFileCache = this.getCache();
                            RAShadowFile shadowFile = dataFileCache.getShadowFile();
                            if (shadowFile == null) {
                                this.backup.setFileIgnore(dataFileExtension);
                            } else {
                                file = new File(dataFileCache.dataFileName);
                                isw = new InputStreamWrapper(new FileInputStream(file));
                                isw.setSizeLimit(dataFileCache.fileStartFreePosition);
                                this.backup.setStream(dataFileExtension, isw);
                                InputStreamInterface isi = shadowFile.getInputStream();
                                this.backup.setStream(backupFileExtension, isi);
                            }
                        }
                        if ((fileLength = (file = new File(this.log.getLogFileName())).length()) == 0L) {
                            this.backup.setFileIgnore(logFileExtension);
                        } else {
                            isw = new InputStreamWrapper(new FileInputStream(file));
                            isw.setSizeLimit(fileLength);
                            this.backup.setStream(logFileExtension, isw);
                        }
                    }
                    if (asFiles) {
                        this.backup.writeAsFiles();
                    } else {
                        this.backup.write();
                    }
                }
                this.logInfoEvent("Successfully backed up instance '" + instanceName + "' to '" + destPath + "'");
                if (scriptName == null) break block30;
                FileUtil.getFileUtil().delete(scriptName);
            }
            catch (IOException ioe) {
                throw Error.error(452, ioe.toString());
            }
            catch (TarMalformatException tme) {
                throw Error.error(452, tme.toString());
            }
            finally {
                if (scriptName != null) {
                    FileUtil.getFileUtil().delete(scriptName);
                }
                if (blocking) {
                    this.log.checkpointReopen();
                }
            }
        }
        if (blocking) {
            this.log.checkpointReopen();
        }
    }

    public String getSecurePath(String path, boolean allowFull, boolean includeRes) {
        if (this.database.getType() == "res:") {
            if (includeRes) {
                return path;
            }
            return null;
        }
        if (this.database.getType() == "mem:") {
            if (this.propTextAllowFullPath) {
                return path;
            }
            return null;
        }
        if (path.startsWith("/") || path.startsWith("\\") || path.indexOf(":") > -1) {
            if (allowFull || this.propTextAllowFullPath) {
                return path;
            }
            return null;
        }
        if (path.indexOf("..") > -1 && !allowFull && !this.propTextAllowFullPath) {
            return null;
        }
        String fullPath = new File(new File(this.database.getPath() + propertiesFileExtension).getAbsolutePath()).getParent();
        if (fullPath != null) {
            path = fullPath + File.separator + path;
        }
        return path;
    }

    public boolean isNewDatabase() {
        return this.isNewDatabase;
    }
}

