/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.Iterator;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DataSpaceManagerBlocks;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int INT_SPACE_PROPS_POS = 20;
    static final int INT_SPACE_LIST_POS = 24;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    public DataSpaceManager spaceManager;
    static final int initIOBufferSize = 4096;
    private static final int diskBlockSize = 4096;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected long initialFreePos;
    protected long lostSpaceSize;
    protected long spaceManagerPosition;
    protected long fileStartFreePosition;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database db, String baseFileName) {
        this.initParams(db, baseFileName, false);
        this.cache = new Cache(this);
    }

    public DataFileCache(Database db, String baseFileName, boolean defrag) {
        this.initParams(db, baseFileName, true);
        this.cache = new Cache(this);
        try {
            this.dataFile = this.database.logger.isStoredFileAccess() ? RAFile.newScaledRAFile(this.database, this.dataFileName, false, 3) : new RAFileSimple(this.database.logger, this.dataFileName, "rw");
        }
        catch (Throwable t) {
            throw Error.error(452, t);
        }
        this.initNewFile();
        this.initBuffers();
        this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this);
    }

    protected void initParams(Database database, String baseFileName, boolean defrag) {
        this.dataFileName = baseFileName + ".data";
        this.backupFileName = baseFileName + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.dataFileScale = database.logger.getDataFileScale();
        this.cachedRowPadding = 8;
        if (this.dataFileScale > 8) {
            this.cachedRowPadding = this.dataFileScale;
        }
        this.initialFreePos = 32L;
        if (this.initialFreePos < (long)this.dataFileScale) {
            this.initialFreePos = this.dataFileScale;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        this.maxCacheRows = database.logger.getCacheMaxRows();
        this.maxCacheBytes = database.logger.getCacheSize();
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)database.logger.getDataFileFactor();
        if (defrag) {
            this.dataFileName = this.dataFileName + ".new";
            this.backupFileName = this.backupFileName + ".new";
            this.maxCacheRows = 1024;
            this.maxCacheBytes = 0x400000L;
        }
    }

    public void open(boolean readonly) {
        if (this.database.logger.isStoredFileAccess()) {
            this.openStoredFileAccess(readonly);
            return;
        }
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean isNio = this.database.logger.propNioDataFile;
            int fileType = this.database.isFilesInJar() ? 2 : (isNio ? 1 : 0);
            if (readonly || this.database.isFilesInJar()) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                int flags = this.getFlags();
                boolean bl = this.is180 = !BitMap.isSet(flags, 4);
                if (BitMap.isSet(flags, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.initBuffers();
                this.spaceManager = new DataSpaceManagerSimple(this);
                return;
            }
            boolean preexists = this.fa.isStreamElement(this.dataFileName);
            boolean isIncremental = this.database.logger.propIncrementBackup;
            boolean isSaved = false;
            if (preexists) {
                boolean existsBackup;
                this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "r");
                long length = this.dataFile.length();
                boolean wrongVersion = false;
                if (length >= this.initialFreePos) {
                    int flags = this.getFlags();
                    isSaved = BitMap.isSet(flags, 2);
                    isIncremental = BitMap.isSet(flags, 1);
                    boolean bl = this.is180 = !BitMap.isSet(flags, 4);
                    if (BitMap.isSet(flags, 5)) {
                        wrongVersion = true;
                    }
                }
                this.dataFile.close();
                if (wrongVersion) {
                    throw Error.error(453);
                }
                if (!this.database.logger.propLargeData && length > this.maxDataFileSize / 8L * 7L) {
                    this.database.logger.propLargeData = true;
                    this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)this.database.logger.getDataFileFactor();
                }
                if (length > this.maxDataFileSize) {
                    throw Error.error(468, String.valueOf(this.maxDataFileSize));
                }
                if (isSaved && isIncremental && (existsBackup = this.fa.isStreamElement(this.backupFileName))) {
                    this.logInfoEvent("data file was not modified but inc backup exists");
                }
            }
            if (isSaved) {
                if (isIncremental) {
                    this.deleteBackup();
                } else {
                    boolean existsBackup = this.fa.isStreamElement(this.backupFileName);
                    if (!existsBackup) {
                        this.backupDataFile(false);
                    }
                }
            } else if (isIncremental) {
                if (preexists && !(preexists = this.restoreBackupIncremental())) {
                    this.database.logger.logSevereEvent("DataFileCache data file modified but no backup exists", null);
                    throw Error.error(454);
                }
            } else {
                preexists = this.restoreBackup();
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
            if (preexists) {
                int flags = this.getFlags();
                this.is180 = !BitMap.isSet(flags, 4);
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.open", t);
            this.release();
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDataSpaceManager() {
        this.writeLock.lock();
        int fileSpaceSize = this.database.logger.propFileSpaceValue;
        try {
            if (fileSpaceSize > 0 && this.spaceManagerPosition == 0L) {
                this.spaceManager.reset();
                this.spaceManager = new DataSpaceManagerBlocks(this);
                boolean bl = true;
                return bl;
            }
            if (fileSpaceSize == 0 && this.spaceManagerPosition != 0L) {
                this.spaceManager.reset();
                this.spaceManager = new DataSpaceManagerSimple(this);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void openStoredFileAccess(boolean readonly) {
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean restore;
            int fileType = 3;
            if (readonly) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(flags, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long freesize = 0L;
            boolean preexists = this.fa.isStreamElement(this.dataFileName);
            boolean isIncremental = this.database.logger.propIncrementBackup;
            boolean bl = restore = this.database.getProperties().getDBModified() == 1;
            if (preexists && restore) {
                preexists = isIncremental ? this.restoreBackupIncremental() : this.restoreBackup();
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
            if (preexists) {
                this.dataFile.seek(4L);
                freesize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(flags, 4);
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = new DataSpaceManagerSimple(this);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable t) {
            this.logSevereEvent("dataFileCache open failed", t);
            this.release();
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    void initNewFile() {
        try {
            this.fileFreePosition = this.initialFreePos;
            this.fileStartFreePosition = this.initialFreePos;
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int spaceProps = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(spaceProps |= this.database.logger.getDataFileSpaces() << 16);
            int flags = 0;
            if (this.database.logger.propIncrementBackup) {
                flags = BitMap.set(flags, 1);
            }
            flags = BitMap.set(flags, 2);
            flags = BitMap.set(flags, 4);
            this.setFlags(flags);
            this.is180 = false;
        }
        catch (Throwable t) {
            throw Error.error(452, t);
        }
    }

    private void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean value) {
        this.writeLock.lock();
        try {
            int flags = this.getFlags();
            flags = value ? BitMap.set(flags, 1) : BitMap.unset(flags, 1);
            this.setFlags(flags);
            this.fileModified = true;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.setIncrementalBackup", t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            DataFileCache.deleteFile(this.database, this.dataFileName);
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackup", t);
            throw Error.error(t, 452, 26, new Object[]{t.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                DataFileCache.deleteFile(this.database, this.backupFileName);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackupIncremental", e);
            throw Error.error(452, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file closed");
            this.dataFile = null;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.release", t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() {
        this.writeLock.lock();
        try {
            boolean empty;
            if (this.dataFile == null) {
                return;
            }
            this.reset();
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close end");
            this.dataFile = null;
            boolean bl = empty = this.fileFreePosition == this.initialFreePos;
            if (empty) {
                this.deleteFile();
                this.deleteBackup();
            }
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.close", t);
            throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int adjust) {
        this.writeLock.lock();
        try {
            this.storeCount += adjust;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen() {
        this.writeLock.lock();
        try {
            this.openShadowFile();
            this.spaceManager.initialiseSpaces();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reset() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.spaceManager.reset();
            this.cache.saveAll();
            long lostSize = this.spaceManager.getLostBlocksSize();
            this.dataFile.seek(4L);
            this.dataFile.writeLong(lostSize);
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int spaceProps = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(spaceProps |= this.database.logger.getDataFileSpaces() << 16);
            int pos = (int)(this.spaceManagerPosition / 4096L);
            this.dataFile.seek(24L);
            this.dataFile.writeInt(pos);
            int flags = this.getFlags();
            flags = BitMap.set(flags, 2);
            this.setFlags(flags);
            this.logDetailEvent("file sync end");
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.logInfoEvent("dataFileCache commit end");
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.reset commit", t);
            throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = this.is180 ? new RowOutputBinary180(4096, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[4096]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.database, this);
            dfd.process();
            this.close();
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupNewDataFile(true);
            }
            this.database.schemaManager.setTempIndexRoots(dfd.getIndexRoots());
            try {
                this.database.logger.log.writeScript(false);
            }
            finally {
                this.database.schemaManager.setTempIndexRoots(null);
            }
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            DataFileDefrag dataFileDefrag = dfd;
            return dataFileDefrag;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(CachedObject object) {
        this.release(object.getPos());
    }

    public void removePersistence(CachedObject object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject object, boolean keep) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.put(object);
            if (keep) {
                object.keepInMemory(true);
            }
            if (object.getStorageSize() > 4096) {
                this.rowOut.reset(object.getStorageSize());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        long pos;
        this.readLock.lock();
        try {
            if (object.isInMemory()) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            pos = object.getPos();
            if (pos < 0L) {
                CachedObject cachedObject = null;
                return cachedObject;
            }
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long pos, int size, PersistentStore store, boolean keep) {
        if (pos < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, size, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long pos, PersistentStore store, boolean keep) {
        if (pos < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    private CachedObject getFromFile(long pos, PersistentStore store, boolean keep) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            for (int j = 0; j < 2; ++j) {
                try {
                    this.readObject(pos);
                    object = store.get(this.rowIn);
                    if (object == null) {
                        throw Error.error(467, "position " + pos);
                    }
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError) {
                        this.cache.clearUnchanged();
                        System.gc();
                        if (j <= 0) continue;
                        this.logInfoEvent(this.dataFileName + " getFromFile out of mem " + pos);
                        HsqlException ex = Error.error(460, t);
                        ex.info = this.rowIn;
                        throw ex;
                    }
                    if (t instanceof HsqlException) {
                        ((HsqlException)t).info = this.rowIn;
                        throw (HsqlException)t;
                    }
                    HsqlException ex = Error.error(467, t);
                    ex.info = this.rowIn;
                    throw ex;
                }
            }
            this.cache.put(object);
            if (keep) {
                object.keepInMemory(true);
            }
            store.set(object);
            CachedObject j = object;
            return j;
        }
        catch (HsqlException e) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + pos, e);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CachedObject getFromFile(long pos, int size, PersistentStore store, boolean keep) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            for (int j = 0; j < 2; ++j) {
                try {
                    this.readObject(pos, size);
                    object = store.get(this.rowIn);
                    break;
                }
                catch (OutOfMemoryError err) {
                    this.cache.clearUnchanged();
                    System.gc();
                    if (j <= 0) continue;
                    this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + pos, err);
                    throw err;
                }
            }
            this.cache.putUsingReserve(object);
            if (keep) {
                object.keepInMemory(true);
            }
            store.set(object);
            CachedObject j = object;
            return j;
        }
        catch (HsqlException e) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + pos, e);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(long pos) {
        this.writeLock.lock();
        try {
            this.readObject(pos);
            RowInputInterface rowInputInterface = this.rowIn;
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void readObject(long pos) {
        try {
            this.dataFile.seek(pos * (long)this.dataFileScale);
            int size = this.dataFile.readInt();
            this.rowIn.resetRow(pos, size);
            this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.readObject", t, pos);
            HsqlException ex = Error.error(466, t);
            if (this.rowIn.getPos() != pos) {
                this.rowIn.resetRow(pos, 0);
            }
            ex.info = this.rowIn;
            throw ex;
        }
    }

    protected void readObject(long pos, int size) {
        try {
            this.rowIn.resetBlock(pos, size);
            this.dataFile.seek(pos * (long)this.dataFileScale);
            this.dataFile.read(this.rowIn.getBuffer(), 0, size);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.readObject", t, pos);
            HsqlException ex = Error.error(466, t);
            ex.info = this.rowIn;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(long startPos, long limitPos) {
        this.writeLock.lock();
        try {
            Iterator it = this.cache.getIterator();
            while (it.hasNext()) {
                CachedObject o = (CachedObject)it.next();
                long pos = o.getPos();
                if (pos < startPos || pos >= limitPos) continue;
                o.setInMemory(false);
                it.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(IntIndex list, int fileBlockItemCount) {
        this.writeLock.lock();
        try {
            this.cache.releaseRange(list, fileBlockItemCount);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(long pos) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(pos);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        if (count == 0) {
            return;
        }
        int pageCount = this.copyShadow(rows, offset, count);
        long startTime = this.cache.saveAllTimer.elapsedTime();
        this.cache.saveAllTimer.start();
        if (pageCount > 0) {
            this.setFileModified();
        }
        for (int i = offset; i < offset + count; ++i) {
            CachedObject r = rows[i];
            this.saveRowNoLock(r);
            rows[i] = null;
        }
        this.cache.saveAllTimer.stop();
        this.cache.logSaveRowsEvent(count, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.copyShadow(row);
            this.setFileModified();
            this.saveRowNoLock(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveRowOutput(long pos) {
        try {
            this.dataFile.seek(pos * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.saveRowOutput", t, pos);
            throw Error.error(466, t);
        }
    }

    protected void saveRowNoLock(CachedObject row) {
        try {
            this.rowOut.reset();
            row.write(this.rowOut);
            this.dataFile.seek(row.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            row.setChanged(false);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.saveRowNoLock", t, row.getPos());
            throw Error.error(466, t);
        }
    }

    protected int copyShadow(CachedObject[] rows, int offset, int count) {
        int pageCount = 0;
        if (this.shadowFile != null) {
            long time = this.cache.shadowTimer.elapsedTime();
            long seekpos = 0L;
            this.cache.shadowTimer.start();
            try {
                for (int i = offset; i < offset + count; ++i) {
                    CachedObject row = rows[i];
                    seekpos = row.getPos() * (long)this.dataFileScale;
                    pageCount += this.shadowFile.copy(seekpos, row.getStorageSize());
                }
                if (pageCount > 0) {
                    this.shadowFile.synch();
                }
            }
            catch (Throwable t) {
                this.logSevereEvent("DataFileCache.copyShadow", t, seekpos);
                throw Error.error(466, t);
            }
            this.cache.shadowTimer.stop();
            if (pageCount > 0) {
                time = this.cache.shadowTimer.elapsedTime() - time;
                this.logDetailEvent("copyShadow [size, time] " + this.shadowFile.getSavedLength() + " " + time);
            }
        }
        return pageCount;
    }

    protected int copyShadow(CachedObject row) {
        if (this.shadowFile != null) {
            long seekpos = row.getPos() * (long)this.dataFileScale;
            try {
                int pageCount = this.shadowFile.copy(seekpos, row.getStorageSize());
                this.shadowFile.synch();
                return pageCount;
            }
            catch (Throwable t) {
                this.logSevereEvent("DataFileCache.copyShadow", t, row.getPos());
                throw Error.error(466, t);
            }
        }
        return 0;
    }

    void backupDataFile(boolean newFile) {
        DataFileCache.backupFile(this.database, this.dataFileName, this.backupFileName, newFile);
    }

    void backupNewDataFile(boolean newFile) {
        DataFileCache.backupFile(this.database, this.dataFileName + ".new", this.backupFileName, newFile);
    }

    static void backupFile(Database database, String fileName, String backupFileName, boolean newFile) {
        try {
            FileAccess fa = database.logger.getFileAccess();
            if (database.logger.propIncrementBackup) {
                if (fa.isStreamElement(backupFileName)) {
                    DataFileCache.deleteFile(database, backupFileName);
                    if (fa.isStreamElement(backupFileName)) {
                        throw Error.error(466, "cannot delete old backup file");
                    }
                }
                return;
            }
            if (fa.isStreamElement(fileName)) {
                if (newFile) {
                    backupFileName = backupFileName + ".new";
                } else {
                    DataFileCache.deleteFile(database, backupFileName);
                    if (fa.isStreamElement(backupFileName)) {
                        throw Error.error(466, "cannot delete old backup file");
                    }
                }
                FileArchiver.archive(fileName, backupFileName, fa, 1);
            }
        }
        catch (Throwable t) {
            database.logger.logSevereEvent("DataFileCache.backupFile", t);
            throw Error.error(466, t);
        }
    }

    void renameBackupFile() {
        DataFileCache.renameBackupFile(this.database, this.backupFileName);
    }

    static void renameBackupFile(Database database, String backupFileName) {
        FileAccess fileAccess = database.logger.getFileAccess();
        if (database.logger.propIncrementBackup) {
            DataFileCache.deleteFile(database, backupFileName);
            return;
        }
        if (fileAccess.isStreamElement(backupFileName + ".new")) {
            DataFileCache.deleteFile(database, backupFileName);
            fileAccess.renameElement(backupFileName + ".new", backupFileName);
        }
    }

    void renameDataFile() {
        DataFileCache.renameDataFile(this.database, this.dataFileName);
    }

    static void renameDataFile(Database database, String dataFileName) {
        FileAccess fileAccess = database.logger.getFileAccess();
        if (fileAccess.isStreamElement(dataFileName + ".new")) {
            DataFileCache.deleteFile(database, dataFileName);
            fileAccess.renameElement(dataFileName + ".new", dataFileName);
        }
    }

    void deleteFile() {
        DataFileCache.deleteFile(this.database, this.dataFileName);
    }

    static void deleteFile(Database database, String fileName) {
        FileAccess fileAccess = database.logger.getFileAccess();
        fileAccess.removeElement(fileName);
        if (database.logger.isStoredFileAccess()) {
            return;
        }
        if (fileAccess.isStreamElement(fileName)) {
            database.logger.log.deleteOldDataFiles();
            fileAccess.removeElement(fileName);
            if (fileAccess.isStreamElement(fileName)) {
                String discardName = FileUtil.newDiscardFileName(fileName);
                fileAccess.renameElement(fileName, discardName);
            }
        }
    }

    void deleteBackup() {
        DataFileCache.deleteFile(this.database, this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long enlargeFileSpace(long delta) {
        this.writeLock.lock();
        try {
            long position = this.fileFreePosition;
            if (position + delta > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum allowed size: " + this.dataFileName + " " + this.maxDataFileSize, null);
                throw Error.error(468);
            }
            boolean result = this.dataFile.ensureLength(position + delta);
            if (!result) {
                this.logSevereEvent("data file cannot be enlarged - disk space: " + this.dataFileName + " " + (position + delta), null);
                throw Error.error(468);
            }
            this.fileFreePosition += delta;
            long l = position;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public long getLostBlockSize() {
        return this.spaceManager.getLostBlocksSize();
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public int getDataFileScale() {
        return this.dataFileScale;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    protected void setFileModified() {
        try {
            if (!this.fileModified) {
                int flags = this.getFlags();
                flags = BitMap.unset(flags, 2);
                this.setFlags(flags);
                this.logDetailEvent("setFileModified flag set ");
                this.fileModified = true;
            }
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.setFileModified", t);
            throw Error.error(466, t);
        }
    }

    public int getFlags() throws IOException {
        this.dataFile.seek(28L);
        int flags = this.dataFile.readInt();
        return flags;
    }

    private void setFlags(int flags) throws IOException {
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
        this.dataFile.synch();
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    private void logSevereEvent(String message, Throwable t, long position) {
        if (this.logEvents) {
            StringBuffer sb = new StringBuffer(message);
            sb.append(' ').append(position);
            message = sb.toString();
            this.database.logger.logSevereEvent(message, t);
        }
    }

    void logSevereEvent(String message, Throwable t) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(message, t);
        }
    }

    void logInfoEvent(String message) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(message);
        }
    }

    void logDetailEvent(String message) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(message);
        }
    }
}

