/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.lang.reflect.Constructor;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.SimpleStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;

public class BlockObjectStore
extends SimpleStore {
    Class objectClass;
    Constructor constructor;
    int storageSize;
    int blockSize;

    public BlockObjectStore(DataFileCache cache, TableSpaceManager tableSpaceManager, Class objectClass, int storageSize, int blockSize) {
        this.cache = cache;
        this.spaceManager = tableSpaceManager;
        this.objectClass = objectClass;
        this.blockSize = blockSize;
        this.storageSize = storageSize;
        try {
            this.constructor = objectClass.getConstructor(Integer.TYPE);
        }
        catch (Exception e) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
    }

    @Override
    public CachedObject get(long i) {
        return this.cache.get(i, this.storageSize, this, false);
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return this.cache.get(object, (PersistentStore)this, keep);
    }

    @Override
    public CachedObject get(long i, boolean keep) {
        return this.cache.get(i, this.storageSize, this, keep);
    }

    @Override
    public void add(Session session, CachedObject object, boolean tx) {
        throw Error.runtimeError(201, "BlockObjectStore");
    }

    @Override
    public void add(CachedObject object, boolean keep) {
        int size = object.getRealSize(this.cache.rowOut);
        if ((size = this.cache.rowOut.getStorageSize(size)) > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        object.setStorageSize(this.storageSize);
        long pos = this.spaceManager.getFilePosition(size, true);
        object.setPos(pos);
        this.cache.add(object, keep);
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        CachedObject object = this.getNewInstance();
        object.read(in);
        int size = object.getRealSize(this.cache.rowOut);
        size = this.cache.rowOut.getStorageSize(size);
        if (size > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        object.setStorageSize(this.storageSize);
        return object;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        throw Error.runtimeError(201, "BlockObjectStore");
    }

    private CachedObject getNewInstance() {
        try {
            CachedObject object = (CachedObject)this.constructor.newInstance(this.blockSize);
            return object;
        }
        catch (Exception e) {
            return null;
        }
    }
}

