/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public OrderedLongKeyHashMap() {
        this(8);
    }

    public OrderedLongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
        this.isList = true;
    }

    public OrderedLongKeyHashMap(int initialCapacity, boolean hasThirdValue) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
        this.objectKeyTable = new Object[this.objectValueTable.length];
        this.isTwoObjectValue = true;
        this.isList = true;
        if (hasThirdValue) {
            this.objectValueTable2 = new Object[this.objectValueTable.length];
        }
        this.minimizeOnEmpty = true;
    }

    public Object get(long key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object getValueByIndex(int index) {
        return this.objectValueTable[index];
    }

    public Object getSecondValueByIndex(int index) {
        return this.objectKeyTable[index];
    }

    public Object getThirdValueByIndex(int index) {
        return this.objectValueTable2[index];
    }

    public Object setSecondValueByIndex(int index, Object value) {
        Object oldValue = this.objectKeyTable[index];
        this.objectKeyTable[index] = value;
        return oldValue;
    }

    public Object setThirdValueByIndex(int index, Object value) {
        Object oldValue = this.objectValueTable2[index];
        this.objectValueTable2[index] = value;
        return oldValue;
    }

    public Object put(long key, Object value) {
        return super.addOrRemove(key, value, null, false);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object remove(long key) {
        return super.addOrRemove(key, null, null, false);
    }

    @Override
    public boolean containsKey(long key) {
        return super.containsKey(key);
    }

    public Object put(long key, Object valueOne, Object valueTwo) {
        return super.addOrRemove(key, valueOne, valueTwo, false);
    }

    @Override
    public int getLookup(long key) {
        return super.getLookup(key);
    }

    public Object getFirstByLookup(int lookup) {
        if (lookup == -1) {
            return null;
        }
        return this.objectValueTable[lookup];
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, false);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            OrderedLongKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, true);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            OrderedLongKeyHashMap.this.clear();
        }
    }
}

