/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongHashSet
extends BaseHashMap {
    public OrderedLongHashSet() {
        this(8);
    }

    public OrderedLongHashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 0, false);
        this.isList = true;
    }

    public boolean contains(long key) {
        return super.containsKey(key);
    }

    public boolean add(long key) {
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, false);
        return oldSize != this.size();
    }

    public boolean remove(long key) {
        boolean result;
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, true);
        boolean bl = result = oldSize != this.size();
        if (result) {
            long[] array = this.toArray();
            super.clear();
            for (int i = 0; i < array.length; ++i) {
                this.add(array[i]);
            }
        }
        return result;
    }

    public long get(int index) {
        this.checkRange(index);
        return this.longKeyTable[index];
    }

    public int getIndex(long value) {
        return this.getLookup(value);
    }

    public int getStartMatchCount(long[] array) {
        int i;
        for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
        }
        return i;
    }

    public int getOrderedStartMatchCount(long[] array) {
        int i;
        for (i = 0; i < array.length && i < this.size() && this.get(i) == array[i]; ++i) {
        }
        return i;
    }

    public boolean addAll(Collection col) {
        int oldSize = this.size();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.add(it.nextLong());
        }
        return oldSize != this.size();
    }

    public long[] toArray() {
        int lookup = -1;
        long[] array = new long[this.size()];
        for (int i = 0; i < array.length; ++i) {
            long value;
            lookup = super.nextLookup(lookup);
            array[i] = value = (long)this.intKeyTable[lookup];
        }
        return array;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

