/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public IntKeyHashMap() {
        this(8);
    }

    public IntKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 3, false);
    }

    public Object get(int key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object put(int key, Object value) {
        return super.addOrRemove(key, value, null, false);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object remove(int key) {
        return super.addOrRemove(key, null, null, true);
    }

    @Override
    public boolean containsKey(int key) {
        return super.containsKey(key);
    }

    public void putAll(IntKeyHashMap other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            int key = it.nextInt();
            this.put(key, other.get(key));
        }
    }

    public void valuesToArray(Object[] array) {
        Iterator it = this.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i] = it.next();
            ++i;
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            intKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            intKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntKeyHashMap.this.clear();
        }
    }
}

