/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, 0, false, false);
    private final long persistenceId;
    protected final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    protected TableBase table;
    int position;
    private Index.IndexUse[] asArray;
    Object[] nullData;

    public IndexAVL(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        this.persistenceId = id;
        this.name = name;
        this.colIndex = columns;
        this.colTypes = colTypes;
        this.colDesc = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast == null ? new boolean[columns.length] : nullsLast;
        this.isPK = pk;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.isForward = forward;
        this.table = table;
        this.colCheck = table.getNewColumnCheckList();
        this.asArray = new Index.IndexUse[]{new Index.IndexUse(this, this.colIndex.length)};
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean simpleOrder = this.colIndex.length > 0;
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i] && !this.nullsLast[i]) continue;
            simpleOrder = false;
        }
        this.isSimpleOrder = simpleOrder;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        if (this.isUnique()) {
            sb.append("UNIQUE").append(' ');
        }
        sb.append("INDEX").append(' ');
        sb.append(this.getName().statementName);
        sb.append(' ').append("ON").append(' ');
        sb.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        sb.append(((Table)this.table).getColumnListSQL(this.colIndex, this.colIndex.length));
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public Index.IndexUse[] asArray() {
        return this.asArray;
    }

    @Override
    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getColumnCount() {
        return this.colIndex.length;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.colIndex;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    @Override
    public void setTable(TableBase table) {
        this.table = table;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Session session, PersistentStore store) {
        store.readLock();
        try {
            long l = store.elementCount(session);
            return l;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeUnique(PersistentStore store) {
        store.readLock();
        try {
            long l = store.elementCountUnique(this);
            return l;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] searchCost(Session session, PersistentStore store) {
        boolean probeDeeper = false;
        int counter = 1;
        double[] changes = new double[this.colIndex.length];
        int depth = 0;
        int[] depths = new int[1];
        store.readLock();
        try {
            int i;
            NodeAVL node;
            NodeAVL temp = node = this.getAccessor(store);
            if (node == null) {
                double[] dArray = changes;
                return dArray;
            }
            while ((temp = (node = temp).getLeft(store)) != null) {
                if (depth == 4) {
                    probeDeeper = true;
                    break;
                }
                ++depth;
            }
            while (true) {
                temp = this.next(store, node, depth, 4, depths);
                depth = depths[0];
                if (temp == null) break;
                this.compareRowForChange(session, node.getData(store), temp.getData(store), changes);
                node = temp;
                ++counter;
            }
            if (probeDeeper) {
                double[] factors = new double[this.colIndex.length];
                int extras = this.probeFactor(session, store, factors, true) + this.probeFactor(session, store, factors, false);
                for (i = 0; i < this.colIndex.length; ++i) {
                    int n = i;
                    factors[n] = factors[n] / 2.0;
                    int j = 0;
                    while ((double)j < factors[i]) {
                        int n2 = i;
                        changes[n2] = changes[n2] * 2.0;
                        ++j;
                    }
                }
            }
            long rowCount = store.elementCount();
            for (i = 0; i < this.colIndex.length; ++i) {
                if (changes[i] == 0.0) {
                    changes[i] = 1.0;
                }
                changes[i] = (double)rowCount / changes[i];
                if (!(changes[i] < 2.0)) continue;
                changes[i] = 2.0;
            }
            double[] dArray = changes;
            return dArray;
        }
        finally {
            store.readUnlock();
        }
    }

    int probeFactor(Session session, PersistentStore store, double[] changes, boolean left) {
        NodeAVL x;
        int depth = 0;
        NodeAVL n = x = this.getAccessor(store);
        if (x == null) {
            return 0;
        }
        while (n != null) {
            x = n;
            NodeAVL nodeAVL = n = left ? x.getLeft(store) : x.getRight(store);
            if (++depth <= 4 || n == null) continue;
            this.compareRowForChange(session, x.getData(store), n.getData(store), changes);
        }
        return depth - 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeCount(Session session, PersistentStore store) {
        long count = 0L;
        store.writeLock();
        try {
            RowIterator it = this.firstRow(session, store, 0, null);
            while (it.hasNext()) {
                it.getNextRow();
                ++count;
            }
            long l = count;
            return l;
        }
        finally {
            store.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(PersistentStore store) {
        store.readLock();
        try {
            boolean bl = this.getAccessor(store) == null;
            return bl;
        }
        finally {
            store.readUnlock();
        }
    }

    public void unlinkNodes(NodeAVL primaryRoot) {
        NodeAVL x;
        NodeAVL l = x = primaryRoot;
        while (l != null) {
            x = l;
            l = x.getLeft(null);
        }
        while (x != null) {
            NodeAVL n;
            x = n = this.nextUnlink(x);
        }
    }

    private NodeAVL nextUnlink(NodeAVL x) {
        NodeAVL temp = x.getRight(null);
        if (temp != null) {
            x = temp;
            temp = x.getLeft(null);
            while (temp != null) {
                x = temp;
                temp = x.getLeft(null);
            }
            return x;
        }
        temp = x;
        for (x = x.getParent(null); x != null && x.isRight(temp); x = x.getParent(null)) {
            x.nRight = null;
            temp.getRow(null).destroy();
            temp.delete();
            temp = x;
        }
        if (x != null) {
            x.nLeft = null;
        }
        temp.getRow(null).destroy();
        temp.delete();
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndex(PersistentStore store) {
        store.readLock();
        try {
            NodeAVL p;
            NodeAVL f = null;
            for (p = this.getAccessor(store); p != null; p = p.getLeft(store)) {
                f = p;
                this.checkNodes(store, p);
            }
            p = f;
            while (f != null) {
                this.checkNodes(store, f);
                f = this.next(store, f);
            }
        }
        finally {
            store.readUnlock();
        }
    }

    void checkNodes(PersistentStore store, NodeAVL p) {
        NodeAVL l = p.getLeft(store);
        NodeAVL r = p.getRight(store);
        if (l != null && l.getBalance(store) == -2) {
            System.out.print("broken index - deleted");
        }
        if (r != null && r.getBalance(store) == -2) {
            System.out.print("broken index -deleted");
        }
        if (l != null && !p.equals(l.getParent(store))) {
            System.out.print("broken index - no parent");
        }
        if (r != null && !p.equals(r.getParent(store))) {
            System.out.print("broken index - no parent");
        }
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public void compareRowForChange(Session session, Object[] a, Object[] b, double[] changes) {
        for (int j = 0; j < this.colIndex.length; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            while (j < this.colIndex.length) {
                int n = j++;
                changes[n] = changes[n] + 1.0;
            }
        }
    }

    @Override
    public int compareRow(Session session, Object[] a, Object[] b) {
        for (int j = 0; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row newRow, Row existingRow, boolean useRowId, int start) {
        Object[] a = newRow.getData();
        Object[] b = existingRow.getData();
        for (int j = start; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        if (useRowId) {
            long diff = newRow.getPos() - existingRow.getPos();
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
        return 0;
    }

    int compareObject(Session session, Object[] a, Object[] b, int[] rowColMap, int position, int opType) {
        return this.colTypes[position].compare(session, a[this.colIndex[position]], b[rowColMap[position]], opType);
    }

    boolean hasNulls(Session session, Object[] rowData) {
        boolean uniqueNulls = session == null || session.database.sqlUniqueNulls;
        boolean compareId = false;
        for (int j = 0; j < this.colIndex.length; ++j) {
            if (rowData[this.colIndex[j]] == null) {
                compareId = true;
                if (!uniqueNulls) continue;
                break;
            }
            if (uniqueNulls) continue;
            compareId = false;
            break;
        }
        return compareId;
    }

    @Override
    public void insert(Session session, PersistentStore store, Row row) {
        boolean isleft = true;
        int compare = -1;
        boolean compareRowId = !this.isUnique || this.hasNulls(session, row.getData());
        store.writeLock();
        try {
            NodeAVL n;
            NodeAVL x = n = this.getAccessor(store);
            if (n == null) {
                store.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                return;
            }
            do {
                RowAVL currentRow;
                if ((compare = this.compareRowForInsertOrDelete(session, row, currentRow = n.getRow(store), compareRowId, 0)) == 0 && session != null && !compareRowId && session.database.txManager.isMVRows() && !this.isEqualReadable(session, store, n)) {
                    compareRowId = true;
                    compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, this.colIndex.length);
                }
                if (compare != 0) continue;
                Constraint c = null;
                if (this.isConstraint) {
                    c = ((Table)this.table).getUniqueConstraintForIndex(this);
                }
                if (c == null) {
                    throw Error.error(104, this.name.statementName);
                }
                throw c.getException(row.getData());
            } while ((n = (x = n).child(store, isleft = compare < 0)) != null);
            x = x.set(store, isleft, ((RowAVL)row).getNode(this.position));
            this.balance(store, x, isleft);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            store.writeUnlock();
        }
    }

    @Override
    public void delete(Session session, PersistentStore store, Row row) {
        store.writeLock();
        row = (Row)store.get((CachedObject)row, false);
        NodeAVL x = ((RowAVL)row).getNode(this.position);
        if (x == null) {
            return;
        }
        try {
            NodeAVL n;
            if (x.getLeft(store) == null) {
                n = x.getRight(store);
            } else if (x.getRight(store) == null) {
                n = x.getLeft(store);
            } else {
                NodeAVL dl;
                NodeAVL temp;
                NodeAVL d = x;
                x = x.getLeft(store);
                while ((temp = x.getRight(store)) != null) {
                    x = temp;
                }
                n = x.getLeft(store);
                int b = x.getBalance(store);
                x = x.setBalance(store, d.getBalance(store));
                d = d.setBalance(store, b);
                NodeAVL xp = x.getParent(store);
                NodeAVL dp = d.getParent(store);
                if (d.isRoot(store)) {
                    store.setAccessor((Index)this, x);
                }
                x = x.setParent(store, dp);
                if (dp != null) {
                    dp = dp.isRight(d) ? dp.setRight(store, x) : dp.setLeft(store, x);
                }
                if (d.equals(xp)) {
                    if ((d = d.setParent(store, x)).isLeft(x)) {
                        x = x.setLeft(store, d);
                        NodeAVL dr = d.getRight(store);
                        x = x.setRight(store, dr);
                    } else {
                        x = x.setRight(store, d);
                        dl = d.getLeft(store);
                        x = x.setLeft(store, dl);
                    }
                } else {
                    d = d.setParent(store, xp);
                    xp = xp.setRight(store, d);
                    dl = d.getLeft(store);
                    NodeAVL dr = d.getRight(store);
                    x = x.setLeft(store, dl);
                    x = x.setRight(store, dr);
                }
                x.getRight(store).setParent(store, x);
                x.getLeft(store).setParent(store, x);
                d = d.setLeft(store, n);
                if (n != null) {
                    n = n.setParent(store, d);
                }
                x = d = d.setRight(store, null);
            }
            boolean isleft = x.isFromLeft(store);
            x.replace(store, this, n);
            n = x.getParent(store);
            x.delete();
            while (n != null) {
                x = n;
                int sign = isleft ? 1 : -1;
                switch (x.getBalance(store) * sign) {
                    case -1: {
                        x = x.setBalance(store, 0);
                        break;
                    }
                    case 0: {
                        x = x.setBalance(store, sign);
                        return;
                    }
                    case 1: {
                        NodeAVL r = x.child(store, !isleft);
                        int b = r.getBalance(store);
                        if (b * sign >= 0) {
                            x.replace(store, this, r);
                            NodeAVL child = r.child(store, isleft);
                            x = x.set(store, !isleft, child);
                            r = r.set(store, isleft, x);
                            if (b == 0) {
                                x = x.setBalance(store, sign);
                                r = r.setBalance(store, -sign);
                                return;
                            }
                            x = x.setBalance(store, 0);
                            x = r = r.setBalance(store, 0);
                            break;
                        }
                        NodeAVL l = r.child(store, isleft);
                        x.replace(store, this, l);
                        b = l.getBalance(store);
                        r = r.set(store, isleft, l.child(store, !isleft));
                        l = l.set(store, !isleft, r);
                        x = x.set(store, !isleft, l.child(store, isleft));
                        l = l.set(store, isleft, x);
                        x = x.setBalance(store, b == sign ? -sign : 0);
                        r = r.setBalance(store, b == -sign ? sign : 0);
                        x = l = l.setBalance(store, 0);
                    }
                }
                isleft = x.isFromLeft(store);
                n = x.getParent(store);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            store.writeUnlock();
        }
    }

    @Override
    public boolean existsParent(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 40, 2, false);
        return node != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int matchCount, int distinctCount, int compareType, boolean reversed, boolean[] map) {
        NodeAVL node = this.findNode(session, store, rowdata, this.defaultColMap, matchCount, compareType, 0, reversed);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, distinctCount, false, reversed);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        NodeAVL node = this.findNode(session, store, rowdata, this.colIndex, this.colIndex.length, 40, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 40, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        NodeAVL node = this.findNode(session, store, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(Session session, PersistentStore store, int distinctCount, boolean[] map) {
        store.readLock();
        try {
            IndexRowIterator indexRowIterator;
            RowAVL row;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getLeft(store);
            }
            while (session != null && x != null && !session.database.txManager.canRead(session, store, row = x.getRow(store), 0, null)) {
                x = this.next(store, x);
            }
            if (x == null) {
                indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            indexRowIterator = new IndexRowIterator(session, store, this, x, distinctCount, false, false);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(PersistentStore store) {
        store.readLock();
        try {
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getLeft(store);
            }
            if (x == null) {
                IndexRowIterator indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            IndexRowIterator indexRowIterator = new IndexRowIterator(null, store, this, x, 0, false, false);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator lastRow(Session session, PersistentStore store, int distinctCount, boolean[] map) {
        store.readLock();
        try {
            IndexRowIterator indexRowIterator;
            RowAVL row;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getRight(store);
            }
            while (session != null && x != null && !session.database.txManager.canRead(session, store, row = x.getRow(store), 0, null)) {
                x = this.last(store, x);
            }
            if (x == null) {
                indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            indexRowIterator = new IndexRowIterator(session, store, this, x, distinctCount, false, true);
            return indexRowIterator;
        }
        finally {
            store.readUnlock();
        }
    }

    NodeAVL next(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        RowAVL row;
        if (x == null) {
            return null;
        }
        if (distinctCount != 0) {
            return this.findDistinctNode(session, store, x, distinctCount, false);
        }
        do {
            if ((x = this.next(store, x)) == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.database.txManager.canRead(session, store, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL last(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        RowAVL row;
        if (x == null) {
            return null;
        }
        if (distinctCount != 0) {
            return this.findDistinctNode(session, store, x, distinctCount, true);
        }
        do {
            if ((x = this.last(store, x)) == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.database.txManager.canRead(session, store, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL next(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        RowAVL row = x.getRow(store);
        NodeAVL temp = (x = row.getNode(this.position)).getRight(store);
        if (temp != null) {
            x = temp;
            temp = x.getLeft(store);
            while (temp != null) {
                x = temp;
                temp = x.getLeft(store);
            }
            return x;
        }
        temp = x;
        for (x = x.getParent(store); x != null && x.isRight(temp); x = x.getParent(store)) {
            temp = x;
        }
        return x;
    }

    NodeAVL next(PersistentStore store, NodeAVL x, int depth, int maxDepth, int[] depths) {
        NodeAVL temp;
        NodeAVL nodeAVL = temp = depth == maxDepth ? null : x.getRight(store);
        if (temp != null) {
            x = temp;
            NodeAVL nodeAVL2 = temp = ++depth == maxDepth ? null : x.getLeft(store);
            while (temp != null) {
                x = temp;
                if (++depth == maxDepth) {
                    temp = null;
                    continue;
                }
                temp = x.getLeft(store);
            }
            depths[0] = depth;
            return x;
        }
        temp = x;
        x = x.getParent(store);
        --depth;
        while (x != null && x.isRight(temp)) {
            temp = x;
            x = x.getParent(store);
            --depth;
        }
        depths[0] = depth;
        return x;
    }

    NodeAVL last(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        RowAVL row = x.getRow(store);
        NodeAVL temp = (x = row.getNode(this.position)).getLeft(store);
        if (temp != null) {
            x = temp;
            temp = x.getRight(store);
            while (temp != null) {
                x = temp;
                temp = x.getRight(store);
            }
            return x;
        }
        temp = x;
        for (x = x.getParent(store); x != null && x.isLeft(temp); x = x.getParent(store)) {
            temp = x;
        }
        return x;
    }

    boolean isEqualReadable(Session session, PersistentStore store, NodeAVL node) {
        Object[] nodeData;
        NodeAVL c = node;
        RowAVL row = node.getRow(store);
        session.database.txManager.setTransactionInfo(store, row);
        if (session.database.txManager.canRead(session, store, row, 1, null)) {
            return true;
        }
        Object[] data = node.getData(store);
        while ((c = this.last(store, c)) != null && this.compareRow(session, data, nodeData = c.getData(store)) == 0) {
            row = c.getRow(store);
            session.database.txManager.setTransactionInfo(store, row);
            if (!session.database.txManager.canRead(session, store, row, 1, null)) continue;
            return true;
        }
        while ((c = this.next(session, store, node, 0)) != null && this.compareRow(session, data, nodeData = c.getData(store)) == 0) {
            row = c.getRow(store);
            session.database.txManager.setTransactionInfo(store, row);
            if (!session.database.txManager.canRead(session, store, row, 1, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, int fieldCount, int compareType, int readMode, boolean reversed) {
        store.readLock();
        try {
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            NodeAVL result = null;
            RowAVL currentRow = null;
            if (compareType != 40 && compareType != 47) {
                --fieldCount;
                if (compareType == 44 || compareType == 45 || compareType == 74) {
                    reversed = true;
                }
            }
            while (x != null) {
                currentRow = x.getRow(store);
                int i = 0;
                if (fieldCount > 0) {
                    i = this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                }
                if (i == 0) {
                    switch (compareType) {
                        case 40: 
                        case 47: 
                        case 74: {
                            result = x;
                            if (reversed) {
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        case 43: 
                        case 48: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount, compareType);
                            if (i <= 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 41: 
                        case 42: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount, compareType);
                            if (i < 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 44: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount, compareType);
                            if (i < 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        case 45: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount, compareType);
                            if (i <= 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (i < 0) {
                    n = x.getRight(store);
                } else if (i > 0) {
                    n = x.getLeft(store);
                }
                if (n == null) break;
                x = n;
            }
            if (session == null) {
                NodeAVL nodeAVL = result;
                return nodeAVL;
            }
            while (result != null && !session.database.txManager.canRead(session, store, currentRow = result.getRow(store), readMode, this.colIndex)) {
                NodeAVL nodeAVL = result = reversed ? this.last(store, result) : this.next(store, result);
                if (result == null) break;
                currentRow = result.getRow(store);
                if (fieldCount <= 0 || this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount) == 0) continue;
                result = null;
                break;
            }
            NodeAVL nodeAVL = result;
            return nodeAVL;
        }
        finally {
            store.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findDistinctNode(Session session, PersistentStore store, NodeAVL node, int fieldCount, boolean reversed) {
        store.readLock();
        try {
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            NodeAVL result = null;
            RowAVL currentRow = null;
            Object[] rowData = node.getData(store);
            while (x != null) {
                currentRow = x.getRow(store);
                int i = 0;
                i = this.compareRowNonUnique(session, currentRow.getData(), rowData, this.colIndex, fieldCount);
                if (reversed) {
                    if (i < 0) {
                        result = x;
                        n = x.getRight(store);
                    } else {
                        n = x.getLeft(store);
                    }
                } else if (i <= 0) {
                    n = x.getRight(store);
                } else {
                    result = x;
                    n = x.getLeft(store);
                }
                if (n == null) break;
                x = n;
            }
            if (session == null) {
                NodeAVL nodeAVL = result;
                return nodeAVL;
            }
            while (result != null && !session.database.txManager.canRead(session, store, currentRow = result.getRow(store), 0, this.colIndex)) {
                result = reversed ? this.last(store, result) : this.next(store, result);
            }
            NodeAVL nodeAVL = result;
            return nodeAVL;
        }
        finally {
            store.readUnlock();
        }
    }

    void balance(PersistentStore store, NodeAVL x, boolean isleft) {
        while (true) {
            int sign = isleft ? 1 : -1;
            switch (x.getBalance(store) * sign) {
                case 1: {
                    x = x.setBalance(store, 0);
                    return;
                }
                case 0: {
                    x = x.setBalance(store, -sign);
                    break;
                }
                case -1: {
                    NodeAVL l = x.child(store, isleft);
                    if (l.getBalance(store) == -sign) {
                        x.replace(store, this, l);
                        x = x.set(store, isleft, l.child(store, !isleft));
                        l = l.set(store, !isleft, x);
                        x = x.setBalance(store, 0);
                        l = l.setBalance(store, 0);
                    } else {
                        NodeAVL r = l.child(store, !isleft);
                        x.replace(store, this, r);
                        l = l.set(store, !isleft, r.child(store, isleft));
                        r = r.set(store, isleft, l);
                        x = x.set(store, isleft, r.child(store, !isleft));
                        r = r.set(store, !isleft, x);
                        int rb = r.getBalance(store);
                        x = x.setBalance(store, rb == -sign ? sign : 0);
                        l = l.setBalance(store, rb == sign ? -sign : 0);
                        r = r.setBalance(store, 0);
                    }
                    return;
                }
            }
            if (x.isRoot(store)) {
                return;
            }
            isleft = x.isFromLeft(store);
            x = x.getParent(store);
        }
    }

    NodeAVL getAccessor(PersistentStore store) {
        NodeAVL node = (NodeAVL)store.getAccessor(this);
        return node;
    }

    IndexRowIterator getIterator(Session session, PersistentStore store, NodeAVL x, boolean single, boolean reversed) {
        if (x == null) {
            return emptyIterator;
        }
        IndexRowIterator it = new IndexRowIterator(session, store, this, x, 0, single, reversed);
        return it;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore store, IndexAVL index, NodeAVL node, int distinctCount, boolean single, boolean reversed) {
            this.session = session;
            this.store = store;
            this.index = index;
            this.distinctCount = distinctCount;
            this.single = single;
            this.reversed = reversed;
            if (index == null) {
                return;
            }
            this.nextnode = node;
        }

        @Override
        public boolean hasNext() {
            return this.nextnode != null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Row getNextRow() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 5[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        @Override
        public void removeCurrent() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow);
        }

        @Override
        public void release() {
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public long getRowId() {
            return this.nextnode.getPos();
        }
    }
}

