/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trigger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public class TriggerDef
implements Runnable,
SchemaObject {
    static final int OLD_ROW = 0;
    static final int NEW_ROW = 1;
    static final int RANGE_COUNT = 2;
    static final int OLD_TABLE = 2;
    static final int NEW_TABLE = 3;
    static final int BEFORE = 4;
    static final int AFTER = 5;
    static final int INSTEAD = 6;
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 9;
    static final TriggerDef[] emptyArray = new TriggerDef[0];
    Table[] transitions;
    RangeVariable[] rangeVars;
    Expression condition;
    boolean hasTransitionTables;
    boolean hasTransitionRanges;
    String conditionSQL;
    Routine routine;
    int[] updateColumns;
    private HsqlNameManager.HsqlName name;
    long changeTimestamp;
    int actionTiming;
    int operationType;
    boolean isSystem;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    Table table;
    Trigger trigger;
    String triggerClassName;
    int triggerType;
    Thread thread;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid = true;
    protected volatile boolean keepGoing = true;

    TriggerDef() {
    }

    public TriggerDef(HsqlNameManager.HsqlName name, int when, int operation, boolean forEach, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, String triggerClassName, boolean noWait, int queueSize) {
        this(name, when, operation, forEach, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        this.triggerClassName = triggerClassName;
        this.nowait = noWait;
        this.maxRowsQueued = queueSize;
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        Class<?> cl = null;
        try {
            cl = Class.forName(triggerClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t1) {
            try {
                cl = Class.forName(triggerClassName);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (cl == null) {
            this.valid = false;
            this.trigger = new DefaultTrigger();
        } else {
            try {
                this.trigger = (Trigger)cl.newInstance();
            }
            catch (Throwable t1) {
                this.valid = false;
                this.trigger = new DefaultTrigger();
            }
        }
    }

    public TriggerDef(HsqlNameManager.HsqlName name, int when, int operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns) {
        this.name = name;
        this.actionTiming = when;
        this.operationType = operation;
        this.forEachRow = forEachRow;
        this.table = table;
        this.transitions = transitions;
        this.rangeVars = rangeVars;
        this.condition = condition == null ? Expression.EXPR_TRUE : condition;
        this.updateColumns = updateColumns;
        this.conditionSQL = conditionSQL;
        this.hasTransitionRanges = rangeVars[0] != null || rangeVars[1] != null;
        this.hasTransitionTables = transitions[2] != null || transitions[3] != null;
        this.setUpIndexesAndTypes();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = this.getSQLMain();
        if (this.maxRowsQueued != 0) {
            sb.append("QUEUE").append(' ');
            sb.append(this.maxRowsQueued).append(' ');
            if (this.nowait) {
                sb.append("NOWAIT").append(' ');
            }
        }
        sb.append("CALL").append(' ');
        sb.append(StringConverter.toQuotedString(this.triggerClassName, '\"', false));
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public StringBuffer getSQLMain() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append(this.getActionTimingString()).append(' ');
        sb.append(this.getEventTypeString()).append(' ');
        if (this.updateColumns != null) {
            sb.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                HsqlNameManager.HsqlName name = this.table.getColumn(this.updateColumns[i]).getName();
                sb.append(name.statementName);
            }
            sb.append(' ');
        }
        sb.append("ON").append(' ');
        sb.append(this.table.getName().getSchemaQualifiedStatementName());
        sb.append(' ');
        if (this.hasTransitionRanges || this.hasTransitionTables) {
            sb.append("REFERENCING").append(' ');
            if (this.rangeVars[0] != null) {
                sb.append("OLD").append(' ').append("ROW");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[0].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.rangeVars[1] != null) {
                sb.append("NEW").append(' ').append("ROW");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[1].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.transitions[2] != null) {
                sb.append("OLD").append(' ').append("TABLE");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[2].getName().statementName);
                sb.append(' ');
            }
            if (this.transitions[3] != null) {
                sb.append("OLD").append(' ').append("TABLE");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[3].getName().statementName);
                sb.append(' ');
            }
        }
        if (this.forEachRow) {
            sb.append("FOR").append(' ');
            sb.append("EACH").append(' ');
            sb.append("ROW").append(' ');
        }
        if (this.condition != Expression.EXPR_TRUE) {
            sb.append("WHEN").append(' ');
            sb.append("(").append(this.conditionSQL);
            sb.append(")").append(' ');
        }
        return sb;
    }

    public String getClassName() {
        return this.trigger.getClass().getName();
    }

    public String getActionTimingString() {
        switch (this.actionTiming) {
            case 4: {
                return "BEFORE";
            }
            case 5: {
                return "AFTER";
            }
            case 6: {
                return "INSTEAD OF";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public String getEventTypeString() {
        switch (this.operationType) {
            case 50: {
                return "INSERT";
            }
            case 19: {
                return "DELETE";
            }
            case 82: {
                return "UPDATE";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public String getConditionSQL() {
        return this.conditionSQL;
    }

    public String getProcedureSQL() {
        return this.routine == null ? null : this.routine.getSQLBodyDefinition();
    }

    public int[] getUpdateColumnIndexes() {
        return this.updateColumns;
    }

    public boolean hasOldTable() {
        return false;
    }

    public boolean hasNewTable() {
        return false;
    }

    public boolean hasOldRow() {
        return this.rangeVars[0] != null;
    }

    public boolean hasNewRow() {
        return this.rangeVars[1] != null;
    }

    public String getOldTransitionRowName() {
        return this.rangeVars[0] == null ? null : this.rangeVars[0].getTableAlias().name;
    }

    public String getNewTransitionRowName() {
        return this.rangeVars[1] == null ? null : this.rangeVars[1].getTableAlias().name;
    }

    public String getOldTransitionTableName() {
        return this.transitions[2] == null ? null : this.transitions[2].getName().name;
    }

    public String getNewTransitionTableName() {
        return this.transitions[3] == null ? null : this.transitions[3].getName().name;
    }

    void setUpIndexesAndTypes() {
        this.triggerType = 0;
        switch (this.operationType) {
            case 50: {
                this.triggerType = 0;
                break;
            }
            case 19: {
                this.triggerType = 1;
                break;
            }
            case 82: {
                this.triggerType = 2;
                break;
            }
            default: {
                throw Error.runtimeError(201, "TriggerDef");
            }
        }
        if (this.forEachRow) {
            this.triggerType += 3;
        }
        if (this.actionTiming == 4 || this.actionTiming == 6) {
            this.triggerType += 3;
        }
    }

    static int getOperationType(int token) {
        switch (token) {
            case 135: {
                return 50;
            }
            case 79: {
                return 19;
            }
            case 303: {
                return 82;
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    static int getTiming(int token) {
        switch (token) {
            case 343: {
                return 4;
            }
            case 336: {
                return 5;
            }
            case 422: {
                return 6;
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public int getStatementType() {
        return this.operationType;
    }

    @Override
    public void run() {
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, triggerData.oldRow, triggerData.newRow);
        }
        try {
            this.thread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pushPair(Session session, Object[] row1, Object[] row2) {
        if (this.maxRowsQueued == 0) {
            session.getInternalConnection();
            try {
                this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, row1, row2);
            }
            finally {
                session.releaseInternalConnection();
            }
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, row1, row2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public Table getTable() {
        return this.table;
    }

    public String getActionOrientationString() {
        return this.forEachRow ? "ROW" : "STATEMENT";
    }

    static class DefaultTrigger
    implements Trigger {
        DefaultTrigger() {
        }

        @Override
        public void fire(int i, String name, String table, Object[] row1, Object[] row2) {
        }
    }

    static class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] oldRow, Object[] newRow) {
            this.oldRow = oldRow;
            this.newRow = newRow;
            this.username = session.getUsername();
        }
    }
}

