/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;

class TransactionManagerCommon {
    Database database;
    Session lobSession;
    int txModel;
    HsqlNameManager.HsqlName[] catalogNameList;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong(1L);
    int transactionCount = 0;
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();
    public LongKeyHashMap rowActionMap;

    TransactionManagerCommon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransactionControl(Session session, int mode) {
        TransactionManagerCommon manager = null;
        if (mode == this.txModel) {
            return;
        }
        this.writeLock.lock();
        try {
            switch (this.txModel) {
                case 1: 
                case 2: {
                    if (this.liveTransactionTimestamps.size() == 1) break;
                    throw Error.error(3701);
                }
            }
            switch (mode) {
                case 2: {
                    manager = new TransactionManagerMVCC(this.database);
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 1: {
                    manager = new TransactionManagerMV2PL(this.database);
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 0: {
                    manager = new TransactionManager2PL(this.database);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "TransactionManagerCommon");
                }
            }
            manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
            manager.transactionCount = this.transactionCount;
            this.database.txManager = manager;
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void adjustLobUsage(Session session) {
        int limit = session.rowActionList.size();
        long lastActionTimestamp = session.actionTimestamp;
        block4: for (int i = 0; i < limit; ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0 || !action.table.hasLobColumn) continue;
            int type = action.getCommitTypeOn(lastActionTimestamp);
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            switch (type) {
                case 1: {
                    session.sessionData.adjustLobUsageCount(action.table, row.getData(), 1);
                    continue block4;
                }
                case 2: {
                    session.sessionData.adjustLobUsageCount(action.table, row.getData(), -1);
                    continue block4;
                }
            }
        }
        int newLimit = session.rowActionList.size();
        if (newLimit > limit) {
            for (int i = limit; i < newLimit; ++i) {
                RowAction lobAction = (RowAction)session.rowActionList.get(i);
                lobAction.commit(session);
            }
        }
    }

    void persistCommit(Session session) {
        int limit = session.rowActionList.size();
        boolean writeCommit = false;
        for (int i = 0; i < limit; ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0) continue;
            int type = action.getCommitTypeOn(session.actionTimestamp);
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (action.table.tableType != 3) {
                writeCommit = true;
            }
            try {
                action.store.commitRow(session, row, type, this.txModel);
                if (this.txModel != 0 && action.table.tableType != 3) continue;
                action.setAsNoOp();
                row.rowAction = null;
                continue;
            }
            catch (HsqlException e) {
                this.database.logger.logWarningEvent("data commit failed", e);
            }
        }
        try {
            session.logSequences();
            if (limit > 0 && writeCommit) {
                this.database.logger.writeCommitStatement(session);
            }
        }
        catch (HsqlException e) {
            this.database.logger.logWarningEvent("data commit logging failed", e);
        }
    }

    void finaliseRows(Session session, Object[] list, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            action.store.postCommitAction(session, action);
        }
    }

    void mergeTransaction(Object[] list, int start, int limit, long timestamp) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            rowact.mergeToTimestamp(timestamp);
        }
    }

    public long getNextGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    boolean checkDeadlock(Session session, OrderedHashSet newWaits) {
        int size = session.waitingSessions.size();
        for (int i = 0; i < size; ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            if (newWaits.contains(current)) {
                return false;
            }
            if (this.checkDeadlock(current, newWaits)) continue;
            return false;
        }
        return true;
    }

    boolean checkDeadlock(Session session, Session other) {
        int size = session.waitingSessions.size();
        for (int i = 0; i < size; ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            if (current == other) {
                return false;
            }
            if (this.checkDeadlock(current, other)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endActionTPL(Session session) {
        if (session.isolationLevel == 4 || session.isolationLevel == 8) {
            return;
        }
        if (session.sessionContext.currentStatement == null) {
            return;
        }
        if (session.sessionContext.depth > 0) {
            return;
        }
        Object[] readLocks = session.sessionContext.currentStatement.getTableNamesForRead();
        if (readLocks.length == 0) {
            return;
        }
        this.writeLock.lock();
        try {
            int i;
            this.unlockReadTablesTPL(session, (HsqlNameManager.HsqlName[])readLocks);
            int waitingCount = session.waitingSessions.size();
            if (waitingCount == 0) {
                return;
            }
            boolean canUnlock = false;
            for (i = 0; i < readLocks.length; ++i) {
                if (this.tableWriteLocks.get(readLocks[i]) == session) continue;
                canUnlock = true;
                break;
            }
            if (!canUnlock) {
                return;
            }
            canUnlock = false;
            for (i = 0; i < waitingCount; ++i) {
                Session current = (Session)session.waitingSessions.get(i);
                if (current.abortTransaction) {
                    canUnlock = true;
                    break;
                }
                Statement currentStatement = current.sessionContext.currentStatement;
                if (currentStatement == null) {
                    canUnlock = true;
                    break;
                }
                if (!ArrayUtil.containsAny(readLocks, currentStatement.getTableNamesForWrite())) continue;
                canUnlock = true;
                break;
            }
            if (!canUnlock) {
                return;
            }
            this.resetLocks(session);
            this.resetLatchesMidTransaction(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        this.unlockTablesTPL(session);
        int waitingCount = session.waitingSessions.size();
        if (waitingCount == 0) {
            return;
        }
        this.resetLocks(session);
        this.resetLatches(session);
    }

    void resetLocks(Session session) {
        Session current;
        int i;
        int waitingCount = session.waitingSessions.size();
        for (i = 0; i < waitingCount; ++i) {
            boolean canProceed;
            current = (Session)session.waitingSessions.get(i);
            current.tempUnlocked = false;
            long count = current.latch.getCount();
            if (count != 1L || !(canProceed = this.setWaitedSessionsTPL(current, current.sessionContext.currentStatement)) || !current.tempSet.isEmpty()) continue;
            this.lockTablesTPL(current, current.sessionContext.currentStatement);
            current.tempUnlocked = true;
        }
        for (i = 0; i < waitingCount; ++i) {
            current = (Session)session.waitingSessions.get(i);
            if (current.tempUnlocked || current.abortTransaction) continue;
            this.setWaitedSessionsTPL(current, current.sessionContext.currentStatement);
        }
    }

    void resetLatches(Session session) {
        int waitingCount = session.waitingSessions.size();
        for (int i = 0; i < waitingCount; ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            this.setWaitingSessionTPL(current);
        }
        session.waitingSessions.clear();
        session.latch.setCount(0);
    }

    void resetLatchesMidTransaction(Session session) {
        session.tempSet.clear();
        session.tempSet.addAll(session.waitingSessions);
        session.waitingSessions.clear();
        int waitingCount = session.tempSet.size();
        for (int i = 0; i < waitingCount; ++i) {
            Session current = (Session)session.tempSet.get(i);
            if (current.abortTransaction || current.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(current);
        }
        session.tempSet.clear();
    }

    boolean setWaitedSessionsTPL(Session session, Statement cs) {
        Session holder;
        HsqlNameManager.HsqlName name;
        int i;
        session.tempSet.clear();
        if (cs == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                session.tempSet.add(holder);
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                session.tempSet.add(holder);
            }
        }
        nameList = cs.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly()) {
            nameList = this.catalogNameList;
        }
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            session.tempSet.add(holder);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void setWaitingSessionTPL(Session session) {
        int count = session.tempSet.size();
        assert (session.latch.getCount() <= (long)(count + 1));
        for (int i = 0; i < count; ++i) {
            Session current = (Session)session.tempSet.get(i);
            current.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(count);
    }

    void lockTablesTPL(Session session, Statement cs) {
        HsqlNameManager.HsqlName name;
        int i;
        if (cs == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(name, session);
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(name, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session s;
        Iterator it = this.tableWriteLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
        it = this.tableReadLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
    }

    void unlockReadTablesTPL(Session session, HsqlNameManager.HsqlName[] locks) {
        for (int i = 0; i < locks.length; ++i) {
            this.tableReadLocks.remove(locks[i], session);
        }
    }

    boolean hasLocks(Session session, Statement cs) {
        Session holder;
        HsqlNameManager.HsqlName name;
        int i;
        if (cs == null) {
            return true;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                return false;
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                return false;
            }
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            return false;
        }
        return true;
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        this.writeLock.lock();
        try {
            sessions = this.database.sessionManager.getAllSessions();
            tIndex = new int[sessions.length];
            rowActionCount = 0;
            actioncount = 0;
            for (i = 0; i < sessions.length; ++i) {
                actioncount += sessions[i].getTransactionSize();
            }
            rowActions = new RowAction[actioncount];
            block4: while (true) {
                found = false;
                minChangeNo = 0x7FFFFFFFFFFFFFFFL;
                sessionIndex = 0;
                for (i = 0; i < sessions.length; ++i) {
                    tSize = sessions[i].getTransactionSize();
                    if (tIndex[i] >= tSize) continue;
                    current = (RowAction)sessions[i].rowActionList.get(tIndex[i]);
                    if (current.actionTimestamp < minChangeNo) {
                        minChangeNo = current.actionTimestamp;
                        sessionIndex = i;
                    }
                    found = true;
                }
                if (!found) break;
                currentList = sessions[sessionIndex].rowActionList;
                while (true) {
                    if (tIndex[sessionIndex] >= currentList.size()) continue block4;
                    current = (RowAction)currentList.get(tIndex[sessionIndex]);
                    if (current.actionTimestamp == minChangeNo + 1L) {
                        ++minChangeNo;
                    }
                    if (current.actionTimestamp == minChangeNo) ** break;
                    continue block4;
                    rowActions[rowActionCount++] = current;
                    v0 = sessionIndex;
                    tIndex[v0] = tIndex[v0] + 1;
                }
                break;
            }
            var5_5 = rowActions;
            return var5_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resetSession(Session session, Session targetSession, int mode) {
        if (session == targetSession) {
            return;
        }
        this.writeLock.lock();
        try {
            switch (mode) {
                case 1: {
                    if (targetSession.isInMidTransaction()) return;
                    targetSession.sessionData.closeAllNavigators();
                    return;
                }
                case 2: {
                    if (targetSession.isInMidTransaction()) return;
                    targetSession.sessionData.persistentStoreCollection.clearAllTables();
                    return;
                }
                case 3: {
                    if (targetSession.isInMidTransaction()) return;
                    targetSession.resetSession();
                    return;
                }
                case 4: {
                    if (!targetSession.isInMidTransaction()) return;
                    if (targetSession.latch.getCount() > 0L) {
                        targetSession.abortTransaction = true;
                        targetSession.latch.setCount(0);
                        return;
                    }
                    targetSession.abortTransaction = true;
                    return;
                }
                case 5: {
                    if (targetSession.isInMidTransaction()) return;
                    targetSession.rollbackNoCheck(true);
                    targetSession.close();
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

