/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.Type;

public class StatementSession
extends Statement {
    public static final StatementSession commitNoChainStatement = new StatementSession(11, new Object[]{Boolean.FALSE});
    public static final StatementSession rollbackNoChainStatement = new StatementSession(62, new Object[]{Boolean.FALSE});
    public static final StatementSession commitAndChainStatement = new StatementSession(11, new Object[]{Boolean.TRUE});
    public static final StatementSession rollbackAndChainStatement = new StatementSession(62, new Object[]{Boolean.TRUE});
    Expression[] expressions;
    Object[] parameters;

    StatementSession(int type, Expression[] args) {
        super(type);
        this.expressions = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (type) {
            case 66: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 136: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StateemntSession");
            }
        }
    }

    StatementSession(int type, Object[] args) {
        super(type);
        this.parameters = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (type) {
            case 74: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 1127: {
                this.group = 2011;
                this.isLogged = true;
                break;
            }
            case 1: {
                this.group = 2003;
                break;
            }
            case 2: 
            case 15: 
            case 16: {
                this.group = 2010;
                break;
            }
            case 38: {
                this.group = 2004;
                break;
            }
            case 37: 
            case 39: 
            case 40: {
                this.group = 2003;
                break;
            }
            case 45: 
            case 47: 
            case 53: 
            case 98: 
            case 99: {
                this.group = 2003;
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                this.group = 2010;
                break;
            }
            case 22: {
                this.group = 2006;
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 109: 
            case 118: 
            case 136: 
            case 1114: 
            case 1115: 
            case 1116: 
            case 1117: {
                this.group = 2011;
                break;
            }
            case 1048: {
                this.isLogged = true;
                this.group = 2011;
                break;
            }
            case 11: 
            case 57: 
            case 62: 
            case 63: 
            case 75: 
            case 111: 
            case 1118: {
                this.group = 2005;
                break;
            }
            case 32: 
            case 1119: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    StatementSession(int type, HsqlNameManager.HsqlName[] readNames, HsqlNameManager.HsqlName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.isLogged = false;
        this.readTableNames = readNames;
        this.writeTableNames = writeNames;
        switch (type) {
            case 1111: 
            case 1112: 
            case 1113: {
                this.group = 2016;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    Result getResult(Session session) {
        startTransaction = false;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Result.updateZeroResult;
            }
            case 11: {
                try {
                    chain = (Boolean)this.parameters[0];
                    session.commit(chain);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 15: 
            case 16: {
                return Result.updateZeroResult;
            }
            case 22: {
                session.close();
                return Result.updateZeroResult;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 98: 
            case 99: {
                return Result.updateZeroResult;
            }
            case 1111: 
            case 1112: 
            case 1113: {
                return Result.updateZeroResult;
            }
            case 57: {
                savepoint = (String)this.parameters[0];
                try {
                    session.releaseSavepoint(savepoint);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 62: {
                chain = (Boolean)this.parameters[0];
                session.rollback(chain);
                return Result.updateZeroResult;
            }
            case 1118: {
                savepoint = (String)this.parameters[0];
                try {
                    session.rollbackToSavepoint(savepoint);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 63: {
                savepoint = (String)this.parameters[0];
                session.savepoint(savepoint);
                return Result.updateZeroResult;
            }
            case 66: {
                try {
                    name = (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                    if (session.database.getCatalogName().name.equals(name)) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(Error.error(4840), this.sql);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 67: 
            case 68: 
            case 70: {
                return Result.updateZeroResult;
            }
            case 71: {
                value = null;
                if (this.expressions[0].getType() == 1 && this.expressions[0].getConstantValueNoCheck(session) == null) {
                    session.setZoneSeconds(session.sessionTimeZoneSeconds);
                    return Result.updateZeroResult;
                }
                try {
                    value = this.expressions[0].getValue(session);
                }
                catch (HsqlException e) {
                    // empty catch block
                }
                if (!(value instanceof Result)) ** GOTO lbl78
                result = (Result)value;
                if (!result.isData()) ** GOTO lbl77
                data = result.getNavigator().getNext();
                v0 = single = result.getNavigator().next() == false;
                if (single && data != null && data[0] != null) {
                    value = data[0];
                    result.getNavigator().release();
                } else {
                    result.getNavigator().release();
                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl77:
                    // 1 sources

                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl78:
                    // 1 sources

                    if (value == null) {
                        return Result.newErrorResult(Error.error(3409), this.sql);
                    }
                }
                if (-50400L <= (seconds = ((IntervalSecondData)value).getSeconds()) && seconds <= 50400L) {
                    session.setZoneSeconds((int)seconds);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(3409), this.sql);
            }
            case 72: {
                return Result.updateZeroResult;
            }
            case 69: {
                return Result.updateZeroResult;
            }
            case 73: {
                role = null;
                try {
                    name = (String)this.expressions[0].getValue(session);
                    if (name != null) {
                        name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                        role = session.database.granteeManager.getRole(name);
                    }
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(Error.error(2200), this.sql);
                }
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                if (role == null) {
                    session.setRole(null);
                }
                if (session.getGrantee().hasRole(role)) {
                    session.setRole(role);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(2200), this.sql);
            }
            case 74: {
                try {
                    name = this.expressions == null ? ((HsqlNameManager.HsqlName)this.parameters[0]).name : (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                    schema = session.database.schemaManager.getSchemaHsqlName(name);
                    session.setCurrentSchemaHsqlName(schema);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 76: {
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                try {
                    password = null;
                    user = (String)this.expressions[0].getValue(session);
                    user = (String)Type.SQL_VARCHAR.trim(session, user, ' ', true, true);
                    if (this.expressions[1] != null) {
                        password = (String)this.expressions[1].getValue(session);
                    }
                    if ((userObject = password == null ? session.database.userManager.get(user) : session.database.getUserManager().getUser(user, password)) == null) {
                        throw Error.error(4001);
                    }
                    this.sql = userObject.getConnectUserSQL();
                    if (userObject == session.getGrantee()) {
                        return Result.updateZeroResult;
                    }
                    if (password == null && !session.isProcessingLog() && userObject.isAdmin() && !session.getGrantee().isAdmin()) {
                        throw Error.error(4000);
                    }
                    if (session.getGrantee().canChangeAuthorisation()) {
                        session.setUser(userObject);
                        session.setRole(null);
                        session.resetSchema();
                        return Result.updateZeroResult;
                    }
                    throw Error.error(4000);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 109: {
                try {
                    if (this.parameters[0] != null) {
                        readonly = (Boolean)this.parameters[0];
                        session.setReadOnlyDefault(readonly);
                    }
                    if (this.parameters[1] != null) {
                        level = (Integer)this.parameters[1];
                        session.setIsolationDefault(level);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 136: {
                return Result.updateZeroResult;
            }
            case 118: {
                return Result.updateZeroResult;
            }
            case 111: {
                startTransaction = true;
            }
            case 75: {
                try {
                    if (this.parameters[0] != null) {
                        readonly = (Boolean)this.parameters[0];
                        session.setReadOnly(readonly);
                    }
                    if (this.parameters[1] != null) {
                        level = (Integer)this.parameters[1];
                        session.setIsolation(level);
                    }
                    if (startTransaction) {
                        session.startTransaction();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1114: {
                mode = (Boolean)this.parameters[0];
                try {
                    session.setAutoCommit(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1127: {
                variables = (ColumnSchema[])this.parameters[0];
                try {
                    for (i = 0; i < variables.length; ++i) {
                        session.sessionContext.addSessionVariable(variables[i]);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1115: {
                feature = (String)this.parameters[0];
                value = (Boolean)this.parameters[1];
                session.setFeature(feature, value);
                return Result.updateZeroResult;
            }
            case 1116: {
                size = (Integer)this.parameters[0];
                session.setSQLMaxRows(size);
                return Result.updateZeroResult;
            }
            case 1117: {
                size = (Integer)this.parameters[0];
                session.setResultMemoryRowCount(size);
                return Result.updateZeroResult;
            }
            case 1048: {
                try {
                    mode = (Boolean)this.parameters[0];
                    session.setIgnoreCase(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1119: {
                table = (Table)this.parameters[0];
                tempConstraints = (HsqlArrayList)this.parameters[1];
                statement = (StatementDMQL)this.parameters[3];
                try {
                    if (tempConstraints.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, null, false);
                    }
                    table.compile(session, null);
                    session.sessionContext.addSessionTable(table);
                    if (table.hasLobColumn) {
                        throw Error.error(5534);
                    }
                    if (statement != null) {
                        result = statement.execute(session);
                        table.insertIntoTable(session, result);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 32: {
                name = (HsqlNameManager.HsqlName)this.parameters[0];
                ifExists = (Boolean)this.parameters[1];
                table = session.sessionContext.findSessionTable(name.name);
                if (table == null) {
                    if (ifExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    throw Error.error(5501, name.name);
                }
                session.sessionContext.dropSessionTable(name.name);
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatementSession");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return false;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    static {
        StatementSession.commitNoChainStatement.sql = "COMMIT";
        StatementSession.commitAndChainStatement.sql = "COMMIT CHAIN";
        StatementSession.rollbackNoChainStatement.sql = "ROLLBACK";
        StatementSession.rollbackAndChainStatement.sql = "ROLLBACK CHAIN";
        StatementSession.commitNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.commitAndChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackAndChainStatement.compileTimestamp = Long.MAX_VALUE;
    }
}

