/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyLongValueHashMap;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.LobData;

public class SessionData {
    private final Database database;
    private final Session session;
    public PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    Object currentValue;
    HashMap sequenceMap;
    HashMap sequenceUpdateMap;
    boolean hasLobOps;
    long firstNewLobID;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getSubqueryRowStore(TableBase table) {
        PersistentStore store = this.persistentStoreCollection.getStore(table);
        store.removeAll();
        return store;
    }

    public PersistentStore getNewResultRowStore(TableBase table, boolean isCached) {
        try {
            PersistentStore store = this.persistentStoreCollection.getStore(table);
            if (!isCached) {
                store.setMemory(true);
            }
            return store;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result command, Result result) {
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            if (ResultProperties.isReadOnly(required)) {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
            } else if (ResultProperties.isUpdatable(returned)) {
                if (ResultProperties.isHoldable(required)) {
                    this.session.addWarning(Error.error(4713));
                }
            } else {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(required)) {
                this.session.addWarning(Error.error(4711));
            }
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
    }

    Result getDataResultHead(Result command, Result result, boolean isNetwork) {
        int fetchSize = command.getFetchSize();
        result.setResultId(this.session.actionTimestamp);
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            returned = ResultProperties.isReadOnly(required) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (ResultProperties.isReadOnly(returned) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : ResultProperties.addHoldable(returned, false)));
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
        boolean hold = false;
        boolean copy = false;
        if (ResultProperties.isUpdatable(result.rsProperties)) {
            hold = true;
        }
        if (isNetwork) {
            if (fetchSize != 0 && result.getNavigator().getSize() > fetchSize) {
                copy = true;
                hold = true;
            }
        } else if (!result.getNavigator().isMemory()) {
            hold = true;
        }
        if (hold) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result.getResultId(), result);
            result.rsProperties = ResultProperties.addIsHeld(result.rsProperties, true);
        }
        if (copy) {
            result = Result.newDataHeadResult(this.session, result, 0, fetchSize);
        }
        return result;
    }

    Result getDataResultSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return Result.newDataRowsResult(result, offset, count);
    }

    Result getDataResult(long id) {
        Result result = (Result)this.resultMap.get(id);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return new RowSetNavigatorClient(source, offset, count);
    }

    public void closeNavigator(long id) {
        Result result = (Result)this.resultMap.remove(id);
        if (result != null) {
            result.getNavigator().release();
        }
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.getNavigator().release();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().release();
            it.remove();
        }
    }

    public void registerNewLob(long lobID) {
        if (this.firstNewLobID == 0L) {
            this.firstNewLobID = lobID;
        }
        this.hasLobOps = true;
    }

    public void clearLobOps() {
        this.firstNewLobID = 0L;
        this.hasLobOps = false;
    }

    public long getFirstLobID() {
        return this.firstNewLobID;
    }

    public void adjustLobUsageCount(Object value, int adjust) {
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        if (value == null) {
            return;
        }
        this.database.lobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
        this.hasLobOps = true;
    }

    public void adjustLobUsageCount(TableBase table, Object[] data, int adjust) {
        if (!table.hasLobColumn) {
            return;
        }
        if (table.isTemp) {
            return;
        }
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        for (int j = 0; j < table.columnCount; ++j) {
            Object value;
            if (!table.colTypes[j].isLobType() || (value = data[j]) == null) continue;
            this.database.lobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
            this.hasLobOps = true;
        }
    }

    public void allocateLobForResult(ResultLob result, InputStream inputStream) {
        try {
            switch (result.getSubType()) {
                case 7: {
                    long blobId;
                    long blobLength = result.getBlockLength();
                    if (blobLength < 0L) {
                        this.allocateBlobSegments(result, result.getInputStream());
                        break;
                    }
                    if (inputStream == null) {
                        blobId = result.getLobID();
                        inputStream = result.getInputStream();
                    } else {
                        BlobDataID blob = this.session.createBlob(blobLength);
                        blobId = blob.getId();
                        this.resultLobs.put(result.getLobID(), blobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(blobLength);
                    this.database.lobManager.setBytesForNewBlob(blobId, countStream, result.getBlockLength());
                    break;
                }
                case 8: {
                    long clobId;
                    long clobLength = result.getBlockLength();
                    if (clobLength < 0L) {
                        this.allocateClobSegments(result, result.getReader());
                        break;
                    }
                    if (inputStream == null) {
                        clobId = result.getLobID();
                        inputStream = result.getReader() != null ? new ReaderInputStream(result.getReader()) : result.getInputStream();
                    } else {
                        ClobDataID clob = this.session.createClob(clobLength);
                        clobId = clob.getId();
                        this.resultLobs.put(result.getLobID(), clobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(clobLength * 2L);
                    this.database.lobManager.setCharsForNewClob(clobId, countStream, result.getBlockLength());
                    break;
                }
                case 2: {
                    long blobId = this.resultLobs.get(result.getLobID());
                    long dataLength = result.getBlockLength();
                    byte[] byteArray = result.getByteArray();
                    Result actionResult = this.database.lobManager.setBytes(blobId, result.getOffset(), byteArray, (int)dataLength);
                    break;
                }
                case 4: {
                    long clobId = this.resultLobs.get(result.getLobID());
                    long dataLength = result.getBlockLength();
                    char[] charArray = result.getCharArray();
                    Result actionResult = this.database.lobManager.setChars(clobId, result.getOffset(), charArray, (int)dataLength);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.resultLobs.clear();
            throw Error.error(458, e);
        }
    }

    private void allocateBlobSegments(ResultLob result, InputStream stream) throws IOException {
        long currentOffset = result.getOffset();
        int bufferLength = this.session.getStreamBlockSize();
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        do {
            byteArrayOS.reset();
            byteArrayOS.write(stream, bufferLength);
            if (byteArrayOS.size() == 0) {
                return;
            }
            byte[] byteArray = byteArrayOS.getBuffer();
            Result actionResult = this.database.lobManager.setBytes(result.getLobID(), currentOffset, byteArray, byteArrayOS.size());
            currentOffset += (long)byteArrayOS.size();
        } while (byteArrayOS.size() >= bufferLength);
    }

    private void allocateClobSegments(ResultLob result, Reader reader) throws IOException {
        this.allocateClobSegments(result.getLobID(), result.getOffset(), reader);
    }

    private void allocateClobSegments(long lobID, long offset, Reader reader) throws IOException {
        int bufferLength = this.session.getStreamBlockSize();
        CharArrayWriter charWriter = new CharArrayWriter(bufferLength);
        long currentOffset = offset;
        do {
            charWriter.reset();
            charWriter.write(reader, bufferLength);
            char[] charArray = charWriter.getBuffer();
            if (charWriter.size() == 0) {
                return;
            }
            Result actionResult = this.database.lobManager.setChars(lobID, currentOffset, charArray, charWriter.size());
            currentOffset += (long)charWriter.size();
        } while (charWriter.size() >= bufferLength);
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator navigator = result.getNavigator();
        if (navigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (navigator.next()) {
                Object[] data = navigator.getCurrent();
                this.registerLobsForRow(data);
            }
            navigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] data) {
        for (int i = 0; i < data.length; ++i) {
            long id;
            if (data[i] instanceof BlobDataID) {
                BlobDataID blob = (BlobDataID)data[i];
                id = blob.getId();
                if (id < 0L) {
                    id = this.resultLobs.get(id);
                }
                data[i] = this.database.lobManager.getBlob(id);
                continue;
            }
            if (!(data[i] instanceof ClobDataID)) continue;
            ClobDataID clob = (ClobDataID)data[i];
            id = clob.getId();
            if (id < 0L) {
                id = this.resultLobs.get(id);
            }
            data[i] = this.database.lobManager.getClob(id);
        }
    }

    ClobData createClobFromFile(String filename, String encoding) {
        File file = this.getFile(filename);
        long fileLength = file.length();
        InputStream is = null;
        try {
            ClobDataID clob = this.session.createClob(fileLength);
            is = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(is, encoding);
            this.allocateClobSegments(clob.getId(), 0L, reader);
            ClobDataID clobDataID = clob;
            return clobDataID;
        }
        catch (IOException e) {
            throw Error.error(452, e.toString());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    BlobData createBlobFromFile(String filename) {
        File file = this.getFile(filename);
        long fileLength = file.length();
        InputStream is = null;
        try {
            BlobDataID blob = this.session.createBlob(fileLength);
            is = new FileInputStream(file);
            this.database.lobManager.setBytesForNewBlob(blob.getId(), is, fileLength);
            BlobDataID blobDataID = blob;
            return blobDataID;
        }
        catch (IOException e) {
            throw Error.error(452);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    private File getFile(String name) {
        this.session.checkAdmin();
        String fileName = this.database.logger.getSecurePath(name, false, false);
        if (fileName == null) {
            throw Error.error(457, name);
        }
        File file = new File(fileName);
        boolean exists = file.exists();
        if (!exists) {
            throw Error.error(452);
        }
        return file;
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence sequence) {
        HsqlNameManager.HsqlName key;
        Object value;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateMap = new HashMap();
        }
        if ((value = this.sequenceMap.get(key = sequence.getName())) == null) {
            value = sequence.getValueObject();
            this.sequenceMap.put(key, value);
            this.sequenceUpdateMap.put(sequence, value);
        }
        return value;
    }

    public Object getSequenceCurrent(NumberSequence sequence) {
        return this.sequenceUpdateMap == null ? null : this.sequenceUpdateMap.get(sequence);
    }
}

