/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionArrayAggregate
extends Expression {
    boolean isDistinctAggregate;
    SortAndSlice sort;
    String separator = ",";
    ArrayType arrayDataType;
    Type exprType;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionArrayAggregate(int type, boolean distinct, Expression e, SortAndSlice sort, String separator) {
        super(type);
        this.isDistinctAggregate = distinct;
        this.sort = sort;
        if (separator != null) {
            this.separator = separator;
        }
        if (type == 85) {
            this.nodes = new Expression[]{e};
            return;
        }
        if (sort == null) {
            this.nodes = new Expression[]{e};
        } else {
            HsqlArrayList list = sort.getExpressionList();
            this.nodes = new Expression[list.size() + 1];
            list.toArray(this.nodes);
            this.nodes[list.size()] = e;
            sort.prepare(1);
        }
    }

    @Override
    boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionArrayAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 82: {
                sb.append(' ').append("ARRAY_AGG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 83: {
                sb.append(' ').append("GROUP_CONCAT").append('(');
                sb.append(left).append(')');
                break;
            }
            case 85: {
                sb.append(' ').append("MEDIAN").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 82: {
                sb.append("ARRAY_AGG").append(' ');
                break;
            }
            case 83: {
                sb.append("GROUP_CONCAT").append(' ');
                break;
            }
            case 85: {
                sb.append("MEDIAN").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroups;
            this.rangeGroup = rangeGroup;
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.nodeDataTypes = new Type[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
            if (this.nodes[i].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            if (this.nodes[i].dataType == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[i] = this.nodes[i].dataType;
        }
        this.exprType = this.nodes[this.nodes.length - 1].dataType;
        if (this.exprType.isLobType()) {
            throw Error.error(5534);
        }
        if (this.exprType.isArrayType()) {
            throw Error.error(5534);
        }
        RowType rowDataType = new RowType(this.nodeDataTypes);
        switch (this.opType) {
            case 82: {
                this.arrayDataType = new ArrayType(rowDataType, 1024);
                this.dataType = new ArrayType(this.exprType, 1024);
                break;
            }
            case 83: {
                this.arrayDataType = new ArrayType(rowDataType, 1024);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 85: {
                this.arrayDataType = new ArrayType(this.nodeDataTypes[0], 1024);
                this.dataType = SetFunction.getType(session, 85, this.exprType);
                if (this.exprType.isNumberType()) break;
                throw Error.error(5563);
            }
        }
        this.condition.resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression other) {
        if (other instanceof ExpressionArrayAggregate) {
            ExpressionArrayAggregate o = (ExpressionArrayAggregate)other;
            if (this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == o.isDistinctAggregate && this.separator.equals(o.separator) && this.condition.equals(o.condition)) {
                return super.equals(other);
            }
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        Object[] currentVal = null;
        switch (this.opType) {
            case 82: 
            case 83: {
                Object[] row = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    row[i] = this.nodes[i].getValue(session);
                }
                if (this.opType == 83 && row[row.length - 1] == null) {
                    return currValue;
                }
                currentVal = row;
                break;
            }
            case 85: {
                currentVal = this.nodes[0].getValue(session);
                if (currentVal != null) break;
                return currValue;
            }
        }
        HsqlArrayList list = (HsqlArrayList)currValue;
        if (list == null) {
            list = new HsqlArrayList();
        }
        list.add(currentVal);
        return list;
    }

    @Override
    public Object getAggregatedValue(Session session, Object currValue) {
        SortAndSlice exprSort;
        if (currValue == null) {
            return null;
        }
        HsqlArrayList list = (HsqlArrayList)currValue;
        Object[] array = list.toArray();
        if (this.isDistinctAggregate) {
            exprSort = new SortAndSlice();
            exprSort.prepareSingleColumn(this.nodes.length - 1);
            this.arrayDataType.sort(session, array, exprSort);
            int size = this.arrayDataType.deDuplicate(session, array, exprSort);
            array = (Object[])ArrayUtil.resizeArrayIfDifferent(array, size);
        }
        if (this.sort != null) {
            this.arrayDataType.sort(session, array, this.sort);
        }
        switch (this.opType) {
            case 82: {
                int i;
                Object[] resultArray = new Object[array.length];
                for (i = 0; i < list.size(); ++i) {
                    Object[] row = (Object[])array[i];
                    resultArray[i] = row[row.length - 1];
                }
                return resultArray;
            }
            case 83: {
                int i;
                StringBuffer sb = new StringBuffer(16 * list.size());
                for (i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        sb.append(this.separator);
                    }
                    Object[] row = (Object[])array[i];
                    Object value = row[row.length - 1];
                    String string = (String)Type.SQL_VARCHAR.convertToType(session, value, this.exprType);
                    sb.append(string);
                }
                return sb.toString();
            }
            case 85: {
                boolean even;
                exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                this.arrayDataType.sort(session, array, exprSort);
                boolean bl = even = array.length % 2 == 0;
                if (even) {
                    Object val1 = array[array.length / 2 - 1];
                    Object val2 = array[array.length / 2];
                    Object val3 = ((NumberType)this.dataType).add(session, val1, val2, this.dataType);
                    return ((NumberType)this.dataType).divide(session, val3, 2);
                }
                return this.dataType.convertToType(session, array[array.length / 2], this.exprType);
            }
        }
        return null;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && !this.condition.isTrue();
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }

    @Override
    public Expression duplicate() {
        ExpressionArrayAggregate e = (ExpressionArrayAggregate)super.duplicate();
        if (this.condition != null) {
            e.condition = this.condition.duplicate();
        }
        return e;
    }
}

