/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.NullType;
import org.hsqldb.types.Type;

public class Expression
implements Cloneable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    static final Expression[] emptyArray = new Expression[0];
    static final Expression EXPR_TRUE = new ExpressionLogical(true);
    static final Expression EXPR_FALSE = new ExpressionLogical(false);
    static final OrderedIntHashSet aggregateFunctionSet = new OrderedIntHashSet();
    static final OrderedIntHashSet columnExpressionSet;
    static final OrderedIntHashSet subqueryExpressionSet;
    static final OrderedIntHashSet subqueryAggregateExpressionSet;
    static final OrderedIntHashSet functionExpressionSet;
    static final OrderedIntHashSet sequenceExpressionSet;
    static final OrderedIntHashSet emptyExpressionSet;
    protected int opType;
    protected int exprSubType;
    HsqlNameManager.SimpleName alias;
    private boolean isAggregate;
    protected Object valueData;
    protected Expression[] nodes;
    Type[] nodeDataTypes;
    TableDerived table;
    boolean isCorrelated;
    int columnIndex = -1;
    protected Type dataType;
    int queryTableColumnIndex = -1;
    int parameterIndex = -1;
    int rangePosition = -1;
    boolean isColumnCondition;
    boolean isColumnEqual;
    boolean isSingleColumnCondition;
    boolean isSingleColumnEqual;
    boolean isSingleColumnNull;
    boolean isSingleColumnNotNull;
    byte nullability = (byte)2;
    Collation collation;
    RangeGroup[] rangeGroups;
    RangeGroup rangeGroup;

    Expression(int type) {
        this.opType = type;
        this.nodes = emptyArray;
    }

    Expression(int type, TableDerived table) {
        switch (type) {
            case 19: {
                this.opType = 19;
                break;
            }
            case 100: {
                this.opType = 100;
                break;
            }
            case 23: {
                this.opType = 23;
                break;
            }
            case 21: 
            case 22: {
                this.opType = 22;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        this.nodes = emptyArray;
        this.table = table;
    }

    Expression(int type, Expression[] list) {
        this(type);
        this.nodes = list;
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String ddl = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 93: 
            case 96: {
                return ddl;
            }
        }
        StringBuffer sb = new StringBuffer();
        ddl = sb.append('(').append(ddl).append(')').toString();
        return ddl;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                sb.append('(');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 26: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                return sb.toString();
            }
        }
        switch (this.opType) {
            case 19: {
                sb.append("ARRAY").append('[');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.nodes[i].getSQL());
                }
                sb.append(']');
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                sb.append('(');
                sb.append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 19: {
                sb.append("ARRAY ");
                return sb.toString();
            }
            case 100: {
                sb.append("ARRAY SUBQUERY");
                return sb.toString();
            }
            case 22: 
            case 23: {
                sb.append("QUERY ");
                sb.append(this.table.queryExpression.describe(session, blanks));
                return sb.toString();
            }
            case 25: {
                sb.append("ROW = ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
            case 26: {
                sb.append("VALUELIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
        }
        return sb.toString();
    }

    void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType || this.exprSubType != other.exprSubType || !Expression.equals(this.dataType, other.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 1: {
                return Expression.equals(this.valueData, other.valueData);
            }
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                return this.table.queryExpression.isEquivalent(other.table.queryExpression);
            }
        }
        return Expression.equals(this.nodes, other.nodes);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Expression) {
            return this.equals((Expression)other);
        }
        return false;
    }

    public int hashCode() {
        int val = this.opType + this.exprSubType;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            val += this.nodes[i].hashCode();
        }
        return val;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 == null ? false : o1.equals(o2);
    }

    static boolean equals(Expression[] row1, Expression[] row2) {
        if (row1 == row2) {
            return true;
        }
        if (row1.length != row2.length) {
            return false;
        }
        int len = row1.length;
        for (int i = 0; i < len; ++i) {
            boolean equals;
            Expression e1 = row1[i];
            Expression e2 = row2[i];
            boolean bl = e1 == null ? e2 == null : (equals = e1.equals(e2));
            if (equals) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] exprList, int start, int end, OrderedIntHashSet excludeSet) {
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (int i = start; i < end; ++i) {
            if (!this.equals(exprList[i])) continue;
            return true;
        }
        switch (this.opType) {
            case 19: 
            case 23: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 100: {
                return false;
            }
            case 22: {
                if (this.table == null) break;
                if (!(this.table.getQueryExpression() instanceof QuerySpecification)) {
                    return false;
                }
                QuerySpecification qs = (QuerySpecification)this.table.getQueryExpression();
                OrderedHashSet set = new OrderedHashSet();
                for (int i = start; i < end; ++i) {
                    if (exprList[i].opType != 2) continue;
                    set.add(exprList[i]);
                }
                return qs.collectOuterColumnExpressions(null, set) == null;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            result &= this.nodes[i] == null || this.nodes[i].isComposedOf(exprList, start, end, excludeSet);
        }
        return result;
    }

    boolean isComposedOf(OrderedHashSet expressions, RangeGroup[] rangeGroups, OrderedIntHashSet excludeSet) {
        int i;
        if (this.opType == 1 || this.opType == 8 || this.opType == 7 || this.opType == 6) {
            return true;
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (i = 0; i < expressions.size(); ++i) {
            if (!this.equals(expressions.get(i))) continue;
            return true;
        }
        if (this.opType == 2) {
            for (i = 0; i < rangeGroups.length; ++i) {
                RangeVariable[] ranges = rangeGroups[i].getRangeVariables();
                for (int j = 0; j < ranges.length; ++j) {
                    if (ranges[j] != this.getRangeVariable()) continue;
                    return true;
                }
            }
        }
        switch (this.opType) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return false;
            }
            case 27: 
            case 28: {
                if (this.nodes.length != 0) break;
                return true;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            result &= this.nodes[i2] == null || this.nodes[i2].isComposedOf(expressions, rangeGroups, excludeSet);
        }
        return result;
    }

    Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceColumnReferences(range, list);
        }
        return this;
    }

    void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].replaceRangeVariables(ranges, newRanges);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceRangeVariables(ranges, newRanges);
        }
    }

    void resetColumnReferences() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resetColumnReferences();
        }
    }

    void convertToSimpleColumn(OrderedHashSet expressions, OrderedHashSet replacements) {
        if (this.opType == 1) {
            return;
        }
        if (this.opType == 5) {
            return;
        }
        int index = expressions.getIndex(this);
        if (index != -1) {
            Expression e = (Expression)replacements.get(index);
            this.nodes = emptyArray;
            this.opType = 5;
            this.columnIndex = e.columnIndex;
            this.rangePosition = e.rangePosition;
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].convertToSimpleColumn(expressions, replacements);
        }
        if (this.table != null && this.table.queryExpression != null) {
            OrderedHashSet set = new OrderedHashSet();
            this.table.queryExpression.collectAllExpressions(set, columnExpressionSet, emptyExpressionSet);
            for (int i = 0; i < set.size(); ++i) {
                Expression e = (Expression)set.get(i);
                e.convertToSimpleColumn(expressions, replacements);
            }
        }
    }

    boolean isAggregate() {
        return this.isAggregate;
    }

    void setAggregate() {
        this.isAggregate = true;
    }

    boolean isSelfAggregate() {
        return false;
    }

    void setAlias(HsqlNameManager.SimpleName name) {
        this.alias = name;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    HsqlNameManager.SimpleName getSimpleName() {
        return this.alias;
    }

    public int getType() {
        return this.opType;
    }

    Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    void setLeftNode(Expression e) {
        this.nodes[0] = e;
    }

    void setRightNode(Expression e) {
        this.nodes[1] = e;
    }

    void setSubType(int subType) {
        this.exprSubType = subType;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Session session, Expression[] columns, int length) {
        if (this.isSelfAggregate()) {
            return this;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(session, columns, length);
        }
        return this;
    }

    OrderedHashSet collectRangeVariables(OrderedHashSet set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectRangeVariables(set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            set = this.table.queryExpression.collectRangeVariables(set);
        }
        return set;
    }

    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariables, OrderedHashSet set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            set = this.table.queryExpression.collectRangeVariables(rangeVariables, set);
        }
        return set;
    }

    void collectObjectNames(Set set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectObjectNames(set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.collectObjectNames(set);
        }
    }

    boolean hasReference(RangeVariable range) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return this.table != null && this.table.queryExpression != null && this.table.queryExpression.hasReference(range);
    }

    boolean hasReference(RangeVariable[] ranges, int exclude) {
        OrderedHashSet set = this.collectRangeVariables(ranges, null);
        if (set == null) {
            return false;
        }
        for (int j = 0; j < set.size(); ++j) {
            if (set.get(j) == ranges[exclude]) continue;
            return true;
        }
        return false;
    }

    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroups, HsqlList unresolvedSet) {
        return this.resolveColumnReferences(session, rangeGroup, rangeGroup.getRangeVariables().length, rangeGroups, unresolvedSet, true);
    }

    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 26: 
            case 30: {
                if (this.table != null) {
                    if (rangeGroup.getRangeVariables().length > rangeCount) {
                        RangeVariable[] rangeVars = (RangeVariable[])ArrayUtil.resizeArray(rangeGroup.getRangeVariables(), rangeCount);
                        rangeGroup = new RangeGroup.RangeGroupSimple(rangeVars, rangeGroup);
                    }
                    rangeGroups = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroups, rangeGroup, rangeGroups.length, 1);
                    rangeGroup = new RangeGroup.RangeGroupSimple(this.table);
                    rangeCount = 0;
                }
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
                }
                return unresolvedSet;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
        }
        switch (this.opType) {
            case 19: {
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                Expression dataExpression;
                RangeVariable[] rangeVars = rangeGroup.getRangeVariables();
                if (rangeVars.length > rangeCount) {
                    rangeVars = (RangeVariable[])ArrayUtil.resizeArray(rangeVars, rangeCount);
                    rangeGroup = new RangeGroup.RangeGroupSimple(rangeVars, rangeGroup);
                }
                rangeGroups = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroups, rangeGroup, rangeGroups.length, 1);
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveReferences(session, rangeGroups);
                    if (!queryExpression.areColumnsResolved()) {
                        if (unresolvedSet == null) {
                            unresolvedSet = new ArrayListIdentity();
                        }
                        unresolvedSet.addAll(queryExpression.getUnresolvedExpressions());
                    }
                }
                if ((dataExpression = this.table.dataExpression) == null) break;
                unresolvedSet = dataExpression.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
                break;
            }
        }
        return unresolvedSet;
    }

    public void setCorrelatedReferences(RangeGroup resolvedRangeGroup) {
        if (this.rangeGroups == null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].setCorrelatedReferences(resolvedRangeGroup);
            }
        } else if (ArrayUtil.find(this.rangeGroups, resolvedRangeGroup) > -1) {
            for (int idx = this.rangeGroups.length - 1; idx >= 0 && this.rangeGroups[idx] != resolvedRangeGroup; --idx) {
                this.rangeGroups[idx].setCorrelated();
            }
            this.rangeGroup.setCorrelated();
        }
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                if (this.table == null) break;
                if (unresolvedSet == null) {
                    unresolvedSet = new OrderedHashSet();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodeDataTypes[i] = this.nodes[i].dataType;
                }
                break;
            }
            case 19: {
                int i2;
                Type nodeDataType = null;
                for (i2 = 0; i2 < this.nodes.length; ++i2) {
                    nodeDataType = Type.getAggregateType(nodeDataType, this.nodes[i2].dataType);
                }
                for (i2 = 0; i2 < this.nodes.length; ++i2) {
                    this.nodes[i2].dataType = nodeDataType;
                }
                if (nodeDataType != null) {
                    for (i2 = 0; i2 < this.nodes.length; ++i2) {
                        if (this.nodes[i2].valueData == null) continue;
                        this.nodes[i2].valueData = nodeDataType.convertToDefaultType(session, this.nodes[i2].valueData);
                    }
                }
                this.dataType = new ArrayType(nodeDataType, this.nodes.length);
                return;
            }
            case 100: {
                QueryExpression queryExpression = this.table.queryExpression;
                queryExpression.resolveTypes(session);
                this.table.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                if (this.nodeDataTypes.length > 1) {
                    throw Error.error(5564);
                }
                this.dataType = new ArrayType(this.dataType, Integer.MAX_VALUE);
                break;
            }
            case 22: 
            case 23: {
                Expression dataExpression;
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveTypes(session);
                }
                if ((dataExpression = this.table.dataExpression) != null) {
                    dataExpression.resolveTypes(session, null);
                }
                this.table.prepareTable(session);
                this.nodeDataTypes = this.table.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session, Expression parent) {
        this.valueData = this.getValue(session);
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void setAsConstantValue(Object value, Expression parent) {
        this.valueData = value;
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void prepareTable(Session session, Expression row, int degree) {
        if (this.nodeDataTypes != null) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            if (e.opType == 25) {
                if (degree == e.nodes.length) continue;
                throw Error.error(5564);
            }
            if (degree == 1) {
                this.nodes[i] = new Expression(25);
                this.nodes[i].nodes = new Expression[]{e};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[degree];
        for (int j = 0; j < degree; ++j) {
            Type type = row == null ? null : row.nodes[j].dataType;
            boolean hasUresolvedParameter = row == null ? false : row.nodes[j].isUnresolvedParam();
            for (int i = 0; i < this.nodes.length; ++i) {
                type = Type.getAggregateType(this.nodes[i].nodes[j].dataType, type);
                hasUresolvedParameter |= this.nodes[i].nodes[j].isUnresolvedParam();
            }
            if (type == null) {
                type = Type.SQL_VARCHAR_DEFAULT;
            }
            int typeCode = type.typeCode;
            if (hasUresolvedParameter && type.isCharacterType() && (typeCode == 1 || type.precision < Type.SQL_VARCHAR_DEFAULT.precision)) {
                if (typeCode == 1) {
                    typeCode = 12;
                }
                long precision = Math.max(Type.SQL_VARCHAR_DEFAULT.precision, type.precision);
                type = CharacterType.getCharacterType(typeCode, precision, type.getCollation());
            }
            this.nodeDataTypes[j] = type;
            if (row != null && row.nodes[j].isUnresolvedParam()) {
                row.nodes[j].dataType = type;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].nodes[j].isUnresolvedParam()) {
                    this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
                    continue;
                }
                if (this.nodes[i].nodes[j].opType != 1 || this.nodes[i].nodes[j].valueData != null) continue;
                this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
            }
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Object[] values = this.nodes[i].getRowValue(session);
            Object[] data = store.getTable().getEmptyRowData();
            for (int j = 0; j < this.nodeDataTypes.length; ++j) {
                data[j] = this.nodeDataTypes[j].convertToType(session, values[j], this.nodes[i].nodes[j].dataType);
            }
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    String getColumnName() {
        return this.getAlias();
    }

    public ColumnSchema getColumn() {
        return null;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    Type getDataType() {
        return this.dataType;
    }

    byte getNullability() {
        return this.nullability;
    }

    Type getNodeDataType(int i) {
        if (this.nodeDataTypes == null) {
            if (i > 0) {
                throw Error.runtimeError(201, "Expression");
            }
            return this.dataType;
        }
        return this.nodeDataTypes[i];
    }

    Type[] getNodeDataTypes() {
        if (this.nodeDataTypes == null) {
            return new Type[]{this.dataType};
        }
        return this.nodeDataTypes;
    }

    int getDegree() {
        switch (this.opType) {
            case 25: {
                return this.nodes.length;
            }
            case 22: 
            case 23: 
            case 30: {
                if (this.table == null) {
                    return this.nodeDataTypes.length;
                }
                return this.table.queryExpression.getColumnCount();
            }
        }
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void materialise(Session session) {
        if (this.table == null) {
            return;
        }
        if (this.table.isCorrelated()) {
            this.table.materialiseCorrelated(session);
        } else {
            this.table.materialise(session);
        }
    }

    Object getValue(Session session, Type type) {
        Object o = this.getValue(session);
        if (o == null || this.dataType == type) {
            return o;
        }
        return type.convertToType(session, o, this.dataType);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (HsqlException e) {
            return null;
        }
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] data = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    data[i] = this.nodes[i].getValue(session);
                }
                return data;
            }
            case 22: 
            case 23: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] row = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    row[i] = this.nodes[i].getValue(session);
                }
                return row;
            }
            case 19: {
                Object[] array = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    array[i] = this.nodes[i].getValue(session);
                }
                return array;
            }
            case 100: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData nav = this.table.getNavigator(session);
                int size = nav.getSize();
                Object[] array = new Object[size];
                nav.beforeFirst();
                int i = 0;
                while (nav.hasNext()) {
                    Object[] data = nav.getNextRowData();
                    array[i] = data[0];
                    ++i;
                }
                return array;
            }
            case 22: 
            case 23: {
                this.table.materialiseCorrelated(session);
                Object[] value = this.table.getValues(session);
                if (value.length == 1) {
                    return value[0];
                }
                return value;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 19: {
                RowSetNavigatorData navigator = this.table.getNavigator(session);
                Object[] array = new Object[navigator.getSize()];
                navigator.beforeFirst();
                int i = 0;
                while (navigator.hasNext()) {
                    Object[] data = navigator.getNext();
                    array[i] = data[0];
                    ++i;
                }
                return Result.newPSMResult(array);
            }
            case 23: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData navigator = this.table.getNavigator(session);
                Result result = Result.newResult(navigator);
                result.metaData = this.table.queryExpression.getMetaData();
                return result;
            }
        }
        Object value = this.getValue(session);
        return Result.newPSMResult(value);
    }

    public boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] a) {
        int nulls = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) continue;
            ++nulls;
        }
        return nulls;
    }

    public boolean isTrue() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData != false;
    }

    public boolean isFalse() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData == false;
    }

    public boolean isIndexable(RangeVariable range) {
        return false;
    }

    static void convertToType(Session session, Object[] data, Type[] dataType, Type[] newType) {
        for (int i = 0; i < data.length; ++i) {
            if (dataType[i].canConvertFrom(newType[i])) continue;
            data[i] = newType[i].convertToType(session, data[i], dataType[i]);
        }
    }

    static QuerySpecification getCheckSelect(Session session, Table t, Expression e) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session);
        compileContext.setNextRangeVarIndex(0);
        QuerySpecification s = new QuerySpecification(compileContext);
        RangeVariable range = new RangeVariable(t, null, null, null, compileContext);
        RangeVariable[] ranges = new RangeVariable[]{range};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(ranges, false);
        e.resolveCheckOrGenExpression(session, rangeGroup, true);
        if (Type.SQL_BOOLEAN != e.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical condition = new ExpressionLogical(48, e);
        s.addSelectColumnExpression(EXPR_TRUE);
        s.addRangeVariable(session, range);
        s.addQueryCondition(condition);
        s.resolve(session);
        return s;
    }

    public void resolveCheckOrGenExpression(Session session, RangeGroup rangeGroup, boolean isCheck) {
        boolean nonDeterministic = false;
        OrderedHashSet set = new OrderedHashSet();
        HsqlList unresolved = this.resolveColumnReferences(session, rangeGroup, RangeGroup.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        this.resolveTypes(session, null);
        this.collectAllExpressions(set, subqueryAggregateExpressionSet, emptyExpressionSet);
        if (!set.isEmpty()) {
            throw Error.error(5512);
        }
        this.collectAllExpressions(set, functionExpressionSet, emptyExpressionSet);
        for (int i = 0; i < set.size(); ++i) {
            Expression current = (Expression)set.get(i);
            if (current.opType == 27 && !((FunctionSQLInvoked)current).isDeterministic()) {
                throw Error.error(5512);
            }
            if (current.opType != 28 || ((FunctionSQL)current).isDeterministic()) continue;
            if (isCheck) {
                nonDeterministic = true;
                continue;
            }
            throw Error.error(5512);
        }
        if (isCheck && nonDeterministic) {
            HsqlArrayList list = new HsqlArrayList();
            RangeVariableResolver.decomposeAndConditions(session, this, list);
            block9: for (int i = 0; i < list.size(); ++i) {
                boolean b;
                nonDeterministic = true;
                Expression e = (Expression)list.get(i);
                if (!(e instanceof ExpressionLogical) || !(b = ((ExpressionLogical)e).convertToSmaller())) break;
                Expression e1 = e.getRightNode();
                e = e.getLeftNode();
                if (!e.dataType.isDateTimeType()) {
                    nonDeterministic = true;
                    break;
                }
                if (e.hasNonDeterministicFunction()) {
                    nonDeterministic = true;
                    break;
                }
                if (e1 instanceof ExpressionArithmetic) {
                    if (this.opType == 32) {
                        if (e1.getRightNode().hasNonDeterministicFunction()) {
                            e1.swapLeftAndRightNodes();
                        }
                    } else if (this.opType != 33) break;
                    if (e1.getRightNode().hasNonDeterministicFunction()) break;
                    e1 = e1.getLeftNode();
                }
                if (e1.opType != 28) break;
                FunctionSQL function = (FunctionSQL)e1;
                switch (function.funcType) {
                    case 43: 
                    case 50: 
                    case 52: {
                        nonDeterministic = false;
                        continue block9;
                    }
                }
            }
            if (nonDeterministic) {
                throw Error.error(5512);
            }
        }
        set.clear();
        this.collectObjectNames(set);
        RangeVariable[] ranges = rangeGroup.getRangeVariables();
        block10: for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            switch (name.type) {
                case 9: {
                    int colIndex;
                    ColumnSchema column;
                    if (isCheck || !(column = ranges[0].rangeTable.getColumn(colIndex = ranges[0].rangeTable.findColumn(name.name))).isGenerated()) continue block10;
                    throw Error.error(5512);
                }
                case 7: {
                    throw Error.error(5512);
                }
                case 24: {
                    Routine routine = (Routine)session.database.schemaManager.getSchemaObject(name);
                    if (!routine.isDeterministic()) {
                        throw Error.error(5512);
                    }
                    int impact = routine.getDataImpact();
                    if (impact != 3 && impact != 4) continue block10;
                    throw Error.error(5512);
                }
            }
        }
        set.clear();
    }

    boolean isUnresolvedParam() {
        return false;
    }

    boolean isDynamicParam() {
        return false;
    }

    boolean hasNonDeterministicFunction() {
        OrderedHashSet list = null;
        if ((list = this.collectAllExpressions(list, functionExpressionSet, emptyExpressionSet)) == null) {
            return false;
        }
        for (int j = 0; j < list.size(); ++j) {
            Expression current = (Expression)list.get(j);
            if (!(current.opType == 27 ? !((FunctionSQLInvoked)current).isDeterministic() : current.opType == 28 && !((FunctionSQL)current).isDeterministic())) continue;
            return true;
        }
        return false;
    }

    void swapLeftAndRightNodes() {
        Expression temp = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = temp;
    }

    void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        throw Error.runtimeError(201, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        if (stopAtTypeSet.contains(this.opType)) {
            return set;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        boolean added = false;
        if (typeSet.contains(this.opType)) {
            if (set == null) {
                set = new OrderedHashSet();
            }
            set.add(this);
            added = true;
        }
        if (!added && this.table != null && this.table.queryExpression != null) {
            set = this.table.queryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    public OrderedHashSet getSubqueries() {
        return this.collectAllSubqueries(null);
    }

    OrderedHashSet collectAllSubqueries(OrderedHashSet set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            set = this.nodes[i].collectAllSubqueries(set);
        }
        if (this.table != null) {
            OrderedHashSet tempSet = null;
            if (this.table.queryExpression != null) {
                tempSet = this.table.queryExpression.getSubqueries();
                set = OrderedHashSet.addAll(set, tempSet);
            }
            if (set == null) {
                set = new OrderedHashSet();
            }
            set.add(this.table);
        }
        return set;
    }

    public boolean isCorrelated() {
        if (this.table == null) {
            return false;
        }
        return this.table.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        OrderedHashSet set = null;
        if ((set = this.collectAllExpressions(set, subqueryAggregateExpressionSet, emptyExpressionSet)) != null && !set.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    static HsqlList resolveColumnSet(Session session, RangeVariable[] rangeVars, RangeGroup[] rangeGroups, HsqlList sourceSet) {
        return Expression.resolveColumnSet(session, rangeVars, rangeVars.length, rangeGroups, sourceSet, null);
    }

    static HsqlList resolveColumnSet(Session session, RangeVariable[] rangeVars, int rangeCount, RangeGroup[] rangeGroups, HsqlList sourceSet, HsqlList targetSet) {
        if (sourceSet == null) {
            return targetSet;
        }
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVars, false);
        for (int i = 0; i < sourceSet.size(); ++i) {
            Expression e = (Expression)sourceSet.get(i);
            targetSet = e.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, targetSet, false);
        }
        return targetSet;
    }

    boolean isConditionRangeVariable(RangeVariable range) {
        return false;
    }

    void getJoinRangeVariables(RangeVariable[] ranges, HsqlList list) {
    }

    double costFactor(Session session, RangeVariable range, int operation) {
        return 16.0;
    }

    Expression getIndexableExpression(RangeVariable rangeVar) {
        return null;
    }

    public Expression duplicate() {
        Expression e = null;
        try {
            e = (Expression)super.clone();
            e.nodes = (Expression[])this.nodes.clone();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                e.nodes[i] = this.nodes[i].duplicate();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "Expression");
        }
        return e;
    }

    void replaceNode(Expression existing, Expression replacement) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != existing) continue;
            replacement.alias = this.nodes[i].alias;
            this.nodes[i] = replacement;
            return;
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object updateAggregatingValue(Session session, Object currValue) {
        throw Error.runtimeError(201, "Expression");
    }

    public Object getAggregatedValue(Session session, Object currValue) {
        throw Error.runtimeError(201, "Expression");
    }

    public Expression getCondition() {
        return null;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setCondition(Expression e) {
        throw Error.runtimeError(201, "Expression");
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }

    static {
        aggregateFunctionSet.add(71);
        aggregateFunctionSet.add(72);
        aggregateFunctionSet.add(73);
        aggregateFunctionSet.add(74);
        aggregateFunctionSet.add(75);
        aggregateFunctionSet.add(76);
        aggregateFunctionSet.add(77);
        aggregateFunctionSet.add(78);
        aggregateFunctionSet.add(79);
        aggregateFunctionSet.add(80);
        aggregateFunctionSet.add(81);
        aggregateFunctionSet.add(83);
        aggregateFunctionSet.add(82);
        aggregateFunctionSet.add(85);
        aggregateFunctionSet.add(98);
        columnExpressionSet = new OrderedIntHashSet();
        columnExpressionSet.add(2);
        subqueryExpressionSet = new OrderedIntHashSet();
        subqueryExpressionSet.add(22);
        subqueryExpressionSet.add(23);
        subqueryAggregateExpressionSet = new OrderedIntHashSet();
        subqueryAggregateExpressionSet.add(71);
        subqueryAggregateExpressionSet.add(72);
        subqueryAggregateExpressionSet.add(73);
        subqueryAggregateExpressionSet.add(74);
        subqueryAggregateExpressionSet.add(75);
        subqueryAggregateExpressionSet.add(76);
        subqueryAggregateExpressionSet.add(77);
        subqueryAggregateExpressionSet.add(78);
        subqueryAggregateExpressionSet.add(79);
        subqueryAggregateExpressionSet.add(80);
        subqueryAggregateExpressionSet.add(81);
        subqueryAggregateExpressionSet.add(83);
        subqueryAggregateExpressionSet.add(82);
        subqueryAggregateExpressionSet.add(85);
        subqueryAggregateExpressionSet.add(98);
        subqueryAggregateExpressionSet.add(23);
        subqueryAggregateExpressionSet.add(22);
        functionExpressionSet = new OrderedIntHashSet();
        functionExpressionSet.add(28);
        functionExpressionSet.add(27);
        sequenceExpressionSet = new OrderedIntHashSet();
        sequenceExpressionSet.add(14);
        sequenceExpressionSet.add(12);
        emptyExpressionSet = new OrderedIntHashSet();
    }
}

