/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDDL;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class StatementSchema
extends Statement {
    int order;
    Object[] arguments = ValuePool.emptyObjectArray;
    boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema() {
        super(64, 2001);
        this.isTransactionStatement = true;
    }

    StatementSchema(String sql, int type, Object[] args) {
        this(sql, type, args, null, null);
    }

    StatementSchema(String sql, int type, Object[] args, HsqlNameManager.HsqlName[] readName, HsqlNameManager.HsqlName[] writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.sql = sql;
        if (args != null) {
            this.arguments = args;
        }
        if (readName != null) {
            this.readTableNames = readName;
        }
        if (writeName != null) {
            this.writeTableNames = writeName;
        }
        switch (type) {
            case 1192: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 17: 
            case 60: 
            case 127: 
            case 134: 
            case 1069: 
            case 1070: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1076: 
            case 1077: 
            case 1078: 
            case 1079: {
                this.group = 2002;
                break;
            }
            case 48: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 49: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 59: 
            case 129: {
                this.group = 2002;
                break;
            }
            case 64: {
                this.group = 2001;
                break;
            }
            case 61: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 14: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 133: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 77: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 117: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 79: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 80: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 52: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 83: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 114: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 84: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 1074: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 6: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 8: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 10: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1072: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1073: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1071: {
                this.group = 2002;
                this.order = 11;
                break;
            }
            case 1204: {
                this.group = 2002;
                this.statementTokens = (Token[])args[0];
                break;
            }
            case 1199: {
                this.group = 2002;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatemntSchema");
            }
        }
    }

    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.database.schemaManager.setSchemaChangeTimestamp();
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    Result getResult(Session session) {
        SchemaManager schemaManager = session.database.schemaManager;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        block28 : switch (this.type) {
            case 1192: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName newName = (HsqlNameManager.HsqlName)this.arguments[1];
                if (name.type == 1) {
                    try {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        name.rename(newName);
                        break;
                    }
                    catch (HsqlException e) {
                        return Result.newErrorResult(e, this.sql);
                    }
                }
                if (name.type == 2) {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                    schemaManager.checkSchemaNameCanChange(name);
                    schemaManager.renameSchema(name, newName);
                    break;
                }
                try {
                    SchemaObject object;
                    name.setSchemaIfNull(session.getCurrentSchemaHsqlName());
                    if (name.type == 9) {
                        Table table = schemaManager.getUserTable(session, name.parent);
                        int index = table.getColumnIndex(name.name);
                        object = table.getColumn(index);
                    } else {
                        object = schemaManager.getSchemaObject(name);
                        if (object == null) {
                            throw Error.error(5501, name.name);
                        }
                        name = object.getName();
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                    newName.setSchemaIfNull(name.schema);
                    if (name.schema != newName.schema) {
                        HsqlException e = Error.error(5505);
                        return Result.newErrorResult(e, this.sql);
                    }
                    newName.parent = name.parent;
                    switch (object.getType()) {
                        case 9: {
                            HsqlNameManager.HsqlName parent = object.getName().parent;
                            schemaManager.checkColumnIsReferenced(parent, object.getName());
                            Table table = schemaManager.getUserTable(session, parent);
                            table.renameColumn((ColumnSchema)object, newName);
                            break block28;
                        }
                    }
                    schemaManager.renameSchemaObject(name, newName);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1069: {
                Table table = (Table)this.arguments[0];
                int[] indexColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                try {
                    Index index = (Index)session.database.schemaManager.getSchemaObject(name);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.alterIndex(index, indexColumns);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 134: {
                try {
                    NumberSequence sequence = (NumberSequence)this.arguments[0];
                    NumberSequence settings = (NumberSequence)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, sequence.getSchemaName());
                    sequence.reset(settings);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3: {
                try {
                    int subType = (Integer)this.arguments[0];
                    Type domain = (Type)this.arguments[1];
                    switch (subType) {
                        case 1082: {
                            Constraint c = (Constraint)this.arguments[2];
                            session.database.schemaManager.checkSchemaObjectNotExists(c.getName());
                            domain.userTypeModifier.addConstraint(c);
                            session.database.schemaManager.addSchemaObject(c);
                            break;
                        }
                        case 1083: {
                            Expression e = (Expression)this.arguments[2];
                            domain.userTypeModifier.setDefaultClause(e);
                            break;
                        }
                        case 1078: {
                            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                            session.database.schemaManager.removeSchemaObject(name);
                            break;
                        }
                        case 1080: {
                            domain.userTypeModifier.removeDefaultClause();
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 4: {
                try {
                    int subType = (Integer)this.arguments[0];
                    Table table = (Table)this.arguments[1];
                    switch (subType) {
                        case 1082: {
                            Constraint c = (Constraint)this.arguments[2];
                            switch (c.getConstraintType()) {
                                case 4: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addPrimaryKey(c);
                                    break block28;
                                }
                                case 2: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addUniqueConstraint(c);
                                    break block28;
                                }
                                case 0: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addForeignKey(c);
                                    break block28;
                                }
                                case 3: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addCheckConstraint(c);
                                    break block28;
                                }
                            }
                            break block28;
                        }
                        case 1081: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int colIndex = (Integer)this.arguments[3];
                            HsqlArrayList list = (HsqlArrayList)this.arguments[4];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.addColumn(column, colIndex, list);
                            break block28;
                        }
                        case 1084: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            ColumnSchema newCol = column.duplicate();
                            newCol.setType(type);
                            TableWorks tw = new TableWorks(session, table);
                            tw.retypeColumn(column, newCol);
                            break block28;
                        }
                        case 1090: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            NumberSequence sequence = (NumberSequence)this.arguments[4];
                            ColumnSchema newCol = column.duplicate();
                            newCol.setType(type);
                            newCol.setIdentity(sequence);
                            TableWorks tw = new TableWorks(session, table);
                            tw.retypeColumn(column, newCol);
                            break block28;
                        }
                        case 1085: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            NumberSequence sequence = (NumberSequence)this.arguments[4];
                            if (column.isIdentity()) {
                                column.getIdentitySequence().reset(sequence);
                                break block28;
                            }
                            column.setIdentity(sequence);
                            table.setColumnTypeVars(columnIndex);
                            break block28;
                        }
                        case 1086: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            boolean nullable = (Boolean)this.arguments[3];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColNullability(column, nullable);
                            break block28;
                        }
                        case 1087: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            Expression e = (Expression)this.arguments[4];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColDefaultExpression(columnIndex, e);
                            break block28;
                        }
                        case 1088: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColDefaultExpression(columnIndex, null);
                            table.setColumnTypeVars(columnIndex);
                            break block28;
                        }
                        case 1089: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            column.setIdentity(null);
                            table.setColumnTypeVars(columnIndex);
                            break block28;
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 17: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    routine.resolveReferences(session);
                    Routine oldRoutine = (Routine)schemaManager.getSchemaObject(routine.getSpecificName());
                    schemaManager.replaceReferences(oldRoutine, routine);
                    oldRoutine.setAsAlteredRoutine(routine);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 60: 
            case 127: {
                throw Error.runtimeError(201, "StatementSchema");
            }
            case 1070: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    View oldView = (View)schemaManager.getSchemaObject(view.getName());
                    if (oldView == null) {
                        throw Error.error(5501, view.getName().name);
                    }
                    view.setName(oldView.getName());
                    view.compile(session, null);
                    OrderedHashSet dependents = schemaManager.getReferencingObjectNames(oldView.getName());
                    if (dependents.getCommonElementCount(view.getReferences()) > 0) {
                        throw Error.error(5502);
                    }
                    int i = schemaManager.getTableIndex(oldView);
                    schemaManager.setTable(i, view);
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(view);
                    try {
                        schemaManager.recompileDependentObjects(set);
                    }
                    catch (HsqlException e) {
                        schemaManager.setTable(i, oldView);
                        schemaManager.recompileDependentObjects(set);
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1076: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    Table table = schemaManager.getUserTable(session, name.parent);
                    int colindex = table.getColumnIndex(name.name);
                    if (table.getColumnCount() == 1) {
                        throw Error.error(5591);
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.dropColumn(colindex, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1077: 
            case 1078: 
            case 1079: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    switch (this.type) {
                        case 29: 
                        case 1079: {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            break;
                        }
                        case 31: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                            if (schemaManager.schemaExists(name.name) || !ifExists) break;
                            return Result.updateZeroResult;
                        }
                        default: {
                            if (name.schema == null) {
                                name.schema = session.getCurrentSchemaHsqlName();
                            } else if (!schemaManager.schemaExists(name.schema.name) && ifExists) {
                                return Result.updateZeroResult;
                            }
                            name.schema = schemaManager.getUserSchemaHsqlName(name.schema.name);
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            SchemaObject object = schemaManager.getSchemaObject(name);
                            if (object == null) {
                                if (ifExists) {
                                    return Result.updateZeroResult;
                                }
                                throw Error.error(5501, name.name);
                            }
                            name = name.type == 24 ? ((Routine)object).getSpecificName() : object.getName();
                        }
                    }
                    if (!cascade) {
                        schemaManager.checkObjectIsReferenced(name);
                    }
                    switch (this.type) {
                        case 29: {
                            StatementSchema.dropRole(session, name, cascade);
                            break;
                        }
                        case 1079: {
                            StatementSchema.dropUser(session, name, cascade);
                            break;
                        }
                        case 31: {
                            this.dropSchema(session, name, cascade);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 34: 
                        case 135: {
                            this.dropObject(session, name, cascade);
                            break;
                        }
                        case 35: {
                            this.dropType(session, name, cascade);
                            break;
                        }
                        case 27: {
                            StatementSchema.dropDomain(session, name, cascade);
                            break;
                        }
                        case 30: {
                            this.dropRoutine(session, name, cascade);
                            break;
                        }
                        case 32: 
                        case 36: {
                            this.dropTable(session, name, cascade);
                            break;
                        }
                        case 33: 
                        case 78: 
                        case 115: 
                        case 116: {
                            break;
                        }
                        case 1077: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            schemaManager.dropIndex(session, name);
                            break;
                        }
                        case 1078: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            schemaManager.dropConstraint(session, name, cascade);
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 48: 
            case 59: {
                try {
                    boolean grant = this.type == 48;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[1];
                    this.setSchemaName(session, null, name);
                    name = schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
                    SchemaObject schemaObject = schemaManager.getSchemaObject(name);
                    Right right = (Right)this.arguments[2];
                    Grantee grantor = (Grantee)this.arguments[3];
                    boolean cascade = (Boolean)this.arguments[4];
                    boolean isGrantOption = (Boolean)this.arguments[5];
                    if (grantor == null) {
                        grantor = this.isSchemaDefinition ? this.schemaName.owner : session.getGrantee();
                    }
                    GranteeManager gm = session.database.granteeManager;
                    switch (schemaObject.getType()) {
                        case 14: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            Table t = (Table)schemaObject;
                            right.setColumns(t);
                            if (t.getTableType() != 3 || right.isFull()) break;
                            return Result.newErrorResult(Error.error(5595), this.sql);
                        }
                    }
                    if (grant) {
                        gm.grant(granteeList, schemaObject, right, grantor, isGrantOption);
                        break;
                    }
                    gm.revoke(granteeList, schemaObject, right, grantor, isGrantOption, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 49: 
            case 129: {
                try {
                    String grantee;
                    int i;
                    boolean grant = this.type == 49;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    OrderedHashSet roleList = (OrderedHashSet)this.arguments[1];
                    Grantee grantor = (Grantee)this.arguments[2];
                    boolean cascade = (Boolean)this.arguments[3];
                    GranteeManager gm = session.database.granteeManager;
                    gm.checkGranteeList(granteeList);
                    for (i = 0; i < granteeList.size(); ++i) {
                        grantee = (String)granteeList.get(i);
                        gm.checkRoleList(grantee, roleList, grantor, grant);
                    }
                    if (grant) {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                String roleName = (String)roleList.get(j);
                                gm.grant(grantee, roleName, grantor);
                            }
                        }
                    } else {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                gm.revoke(grantee, (String)roleList.get(j), grantor);
                            }
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 6: {
                return Result.updateZeroResult;
            }
            case 8: {
                Charset charset = (Charset)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, charset.getName(), true);
                    schemaManager.addSchemaObject(charset);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 10: {
                Collation collation = (Collation)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, collation.getName(), true);
                    schemaManager.addSchemaObject(collation);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 61: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    session.database.getGranteeManager().addRole(name);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1074: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                String password = (String)this.arguments[1];
                Grantee grantor = (Grantee)this.arguments[2];
                boolean admin = (Boolean)this.arguments[3];
                boolean isDigest = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.getUserManager().createUser(name, password, isDigest);
                    if (!admin) break;
                    session.database.getGranteeManager().grant(name.name, "DBA", grantor);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 64: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Grantee owner = (Grantee)this.arguments[1];
                try {
                    session.checkDDLWrite();
                    if (schemaManager.schemaExists(name.name)) {
                        if (session.isProcessingScript && "PUBLIC".equals(name.name)) break;
                        throw Error.error(5504, name.name);
                    }
                    schemaManager.createSchema(name, owner);
                    Schema schema = schemaManager.findSchema(name.name);
                    this.sql = schema.getSQL();
                    if (!session.isProcessingScript() || !session.database.getProperties().isVersion18()) break;
                    session.setCurrentSchemaHsqlName(schema.getName());
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 14: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    routine.resolve(session);
                    this.setOrCheckObjectName(session, null, routine.getName(), false);
                    schemaManager.addSchemaObject(routine);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1072: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Routine[] routines = (Routine[])this.arguments[1];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (name == null) break;
                    for (int i = 0; i < routines.length; ++i) {
                        routines[i].setName(name);
                        schemaManager.addSchemaObject(routines[i]);
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 133: {
                NumberSequence sequence = (NumberSequence)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, sequence.getName(), true);
                    schemaManager.addSchemaObject(sequence);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 23: {
                Type type = (Type)this.arguments[0];
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    for (int i = 0; i < constraints.length; ++i) {
                        Constraint c = constraints[i];
                        this.setOrCheckObjectName(session, type.getName(), c.getName(), true);
                        schemaManager.addSchemaObject(c);
                    }
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 77: {
                Table table = (Table)this.arguments[0];
                HsqlArrayList tempConstraints = (HsqlArrayList)this.arguments[1];
                StatementDMQL statement = (StatementDMQL)this.arguments[2];
                Boolean ifNotExists = (Boolean)this.arguments[3];
                HsqlArrayList foreignConstraints = null;
                try {
                    this.setOrCheckObjectName(session, null, table.getName(), true);
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
                try {
                    if (this.isSchemaDefinition) {
                        foreignConstraints = new HsqlArrayList();
                    }
                    if (tempConstraints.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, foreignConstraints, true);
                        this.arguments[1] = foreignConstraints;
                    }
                    table.compile(session, null);
                    schemaManager.addSchemaObject(table);
                    if (statement != null) {
                        Result result = statement.execute(session);
                        table.insertIntoTable(session, result);
                    }
                    if (table.hasLobColumn) {
                        RowIterator it = table.rowIterator(session);
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            Object[] data = row.getData();
                            session.sessionData.adjustLobUsageCount(table, data, 1);
                        }
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    schemaManager.removeExportedKeys(table);
                    schemaManager.removeDependentObjects(table.getName());
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 117: {
                return Result.updateZeroResult;
            }
            case 79: {
                return Result.updateZeroResult;
            }
            case 80: {
                TriggerDef trigger = (TriggerDef)this.arguments[0];
                HsqlNameManager.HsqlName otherName = (HsqlNameManager.HsqlName)this.arguments[1];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, trigger.getSchemaName());
                    schemaManager.checkSchemaObjectNotExists(trigger.getName());
                    if (otherName != null && schemaManager.getSchemaObject(otherName) == null) {
                        throw Error.error(5501, otherName.name);
                    }
                    trigger.table.addTrigger(trigger, otherName);
                    schemaManager.addSchemaObject(trigger);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 52: {
                return Result.updateZeroResult;
            }
            case 83: {
                Type type = (Type)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 114: {
                return Result.updateZeroResult;
            }
            case 84: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    schemaManager.checkSchemaObjectNotExists(view.getName());
                    view.compile(session, null);
                    schemaManager.addSchemaObject(view);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1073: {
                Table table = (Table)this.arguments[0];
                int[] indexColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                boolean unique = (Boolean)this.arguments[3];
                try {
                    this.setOrCheckObjectName(session, table.getName(), name, true);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.addIndex(indexColumns, name, unique);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1071: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                String comment = (String)this.arguments[1];
                switch (name.type) {
                    case 9: {
                        Table table = (Table)schemaManager.getSchemaObject(name.parent.name, name.parent.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        int index = table.getColumnIndex(name.name);
                        if (index < 0) {
                            throw Error.error(5501);
                        }
                        ColumnSchema column = table.getColumn(index);
                        column.getName().comment = comment;
                        break block28;
                    }
                    case 18: {
                        RoutineSchema routine = (RoutineSchema)schemaManager.getSchemaObject(name.name, name.schema.name, 18);
                        if (!session.getGrantee().isFullyAccessibleByRole(routine.getName())) {
                            throw Error.error(5501);
                        }
                        routine.getName().comment = comment;
                        break block28;
                    }
                    case 3: {
                        Table table = (Table)schemaManager.getSchemaObject(name.name, name.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        table.getName().comment = comment;
                        break block28;
                    }
                }
                break;
            }
            case 1199: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
        return Result.updateZeroResult;
    }

    private void dropType(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        Type distinct = (Type)session.database.schemaManager.getSchemaObject(name);
        session.database.schemaManager.removeSchemaObject(name, cascade);
        distinct.userTypeModifier = null;
    }

    private static void dropDomain(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Type domain = (Type)session.database.schemaManager.getSchemaObject(name);
        OrderedHashSet set = session.database.schemaManager.getReferencingObjectNames(domain.getName());
        if (!cascade && set.size() > 0) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        Constraint[] constraints = domain.userTypeModifier.getConstraints();
        set = new OrderedHashSet();
        for (int i = 0; i < constraints.length; ++i) {
            set.add(constraints[i].getName());
        }
        session.database.schemaManager.removeSchemaObjects(set);
        session.database.schemaManager.removeSchemaObject(domain.getName(), cascade);
        domain.userTypeModifier = null;
    }

    private static void dropRole(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Grantee role = session.database.getGranteeManager().getRole(name.name);
        if (!cascade && session.database.schemaManager.hasSchemas(role)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(role);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, role, cascade);
        session.database.getGranteeManager().dropRole(name.name);
    }

    private static void dropUser(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        User grantee = session.database.getUserManager().get(name.name);
        if (session.database.getSessionManager().isUserActive(name.name)) {
            throw Error.error(5539);
        }
        if (!cascade && session.database.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(grantee);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, grantee, cascade);
        session.database.getUserManager().dropUser(name.name);
    }

    private void dropSchema(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        HsqlNameManager.HsqlName schema = session.database.schemaManager.getUserSchemaHsqlName(name.name);
        StatementSchema.checkSchemaUpdateAuthorisation(session, schema);
        session.database.schemaManager.dropSchema(session, name.name, cascade);
    }

    private void dropRoutine(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropObject(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        name = session.database.schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropTable(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Table table = session.database.schemaManager.findUserTable(session, name.name, name.schema.name);
        session.database.schemaManager.dropTableOrView(session, table, cascade);
    }

    static void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name, boolean check) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
        name.parent = parent;
        if (!this.isSchemaDefinition) {
            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        }
        if (check) {
            session.database.schemaManager.checkSchemaObjectNotExists(name);
        }
    }

    void setSchemaName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
    }

    public boolean isAutoCommitStatement() {
        return true;
    }

    public String describe(Session session) {
        return this.sql;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

