/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

public class DefaultScreenNameGenerator
implements ScreenNameGenerator {
    private static final String[] _ADMIN_RESERVED_SCREEN_NAMES = StringUtil.splitLines(PropsUtil.get("admin.reserved.screen.names"));
    private static final String _NON_NUMERICAL_PREFIX = "user.";
    private static final boolean _USERS_SCREEN_NAME_ALLOW_NUMERIC = GetterUtil.getBoolean(PropsUtil.get("users.screen.name.allow.numeric"));

    @Override
    public String generate(long companyId, long userId, String emailAddress) throws Exception {
        String[] reservedScreenNames;
        int n;
        String screenName = null;
        if (Validator.isNotNull(emailAddress)) {
            screenName = StringUtil.extractFirst(emailAddress, '@').toLowerCase();
            char[] cArray = screenName.toCharArray();
            n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Validator.isChar(c) && !Validator.isDigit(c) && c != '-' && c != '.') {
                    screenName = StringUtil.replace(screenName, c, '.');
                }
                ++n2;
            }
            if (screenName.equals("cyrus") || screenName.equals("postfix")) {
                screenName = String.valueOf(screenName) + "." + userId;
            }
        } else {
            screenName = String.valueOf(userId);
        }
        if (!_USERS_SCREEN_NAME_ALLOW_NUMERIC && Validator.isNumber(screenName)) {
            screenName = _NON_NUMERICAL_PREFIX + screenName;
        }
        String[] stringArray = reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", _ADMIN_RESERVED_SCREEN_NAMES);
        int n3 = reservedScreenNames.length;
        n = 0;
        while (n < n3) {
            String reservedScreenName = stringArray[n];
            if (screenName.equalsIgnoreCase(reservedScreenName)) {
                return this.getUnusedScreenName(companyId, screenName);
            }
            ++n;
        }
        try {
            UserLocalServiceUtil.getUserByScreenName(companyId, screenName);
        }
        catch (NoSuchUserException noSuchUserException) {
            try {
                GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + screenName);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                return screenName;
            }
        }
        return this.getUnusedScreenName(companyId, screenName);
    }

    protected String getUnusedScreenName(long companyId, String screenName) throws PortalException, SystemException {
        int i = 1;
        while (true) {
            String tempScreenName = String.valueOf(screenName) + "." + i;
            try {
                UserLocalServiceUtil.getUserByScreenName(companyId, tempScreenName);
            }
            catch (NoSuchUserException noSuchUserException) {
                try {
                    GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + tempScreenName);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    screenName = tempScreenName;
                    break;
                }
            }
            ++i;
        }
        return screenName;
    }
}

