/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Randomizer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Log _log = LogFactoryUtil.getLog(StringUtil.class);
    private static String[] _emptyStringArray = new String[0];

    public static String add(String s, String add) {
        return StringUtil.add(s, add, ",");
    }

    public static String add(String s, String add, String delimiter) {
        return StringUtil.add(s, add, delimiter, false);
    }

    public static String add(String s, String add, String delimiter, boolean allowDuplicates) {
        if (add == null || delimiter == null) {
            return null;
        }
        if (s == null) {
            s = "";
        }
        if (allowDuplicates || !StringUtil.contains(s, add, delimiter)) {
            StringBundler sb = new StringBundler();
            sb.append(s);
            if (Validator.isNull(s) || s.endsWith(delimiter)) {
                sb.append(add);
                sb.append(delimiter);
            } else {
                sb.append(delimiter);
                sb.append(add);
                sb.append(delimiter);
            }
            s = sb.toString();
        }
        return s;
    }

    public static String appendParentheticalSuffix(String s, int suffix) {
        if (Pattern.matches(".* \\(" + String.valueOf(suffix - 1) + "\\)", s)) {
            int pos = s.lastIndexOf(" (");
            s = s.substring(0, pos);
        }
        return StringUtil.appendParentheticalSuffix(s, String.valueOf(suffix));
    }

    public static String appendParentheticalSuffix(String s, String suffix) {
        StringBundler sb = new StringBundler(5);
        sb.append(s);
        sb.append(" ");
        sb.append("(");
        sb.append(suffix);
        sb.append(")");
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBundler sb = new StringBundler(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hex = Integer.toHexString(256 + (b & 0xFF)).substring(1);
            if (hex.length() < 2) {
                sb.append("0");
            }
            sb.append(hex);
            ++n2;
        }
        return sb.toString();
    }

    public static boolean contains(String s, String text) {
        return StringUtil.contains(s, text, ",");
    }

    public static boolean contains(String s, String text, String delimiter) {
        String dtd;
        int pos;
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        if (!s.endsWith(delimiter)) {
            s = s.concat(delimiter);
        }
        if ((pos = s.indexOf(dtd = delimiter.concat(text).concat(delimiter))) == -1) {
            String td = text.concat(delimiter);
            return s.startsWith(td);
        }
        return true;
    }

    public static int count(String s, String text) {
        if (s == null || s.length() == 0 || text == null || text.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = s.indexOf(text);
        while (pos != -1) {
            pos = s.indexOf(text, pos + text.length());
            ++count;
        }
        return count;
    }

    public static boolean endsWith(String s, char end) {
        return StringUtil.endsWith(s, new Character(end).toString());
    }

    public static boolean endsWith(String s, String end) {
        if (s == null || end == null) {
            return false;
        }
        if (end.length() > s.length()) {
            return false;
        }
        String temp = s.substring(s.length() - end.length());
        return temp.equalsIgnoreCase(end);
    }

    public static String extract(String s, char[] chars) {
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c1 = cArray[n2];
            char[] cArray2 = chars;
            int n3 = chars.length;
            int n4 = 0;
            while (n4 < n3) {
                char c2 = cArray2[n4];
                if (c1 == c2) {
                    sb.append(c1);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String extractChars(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Validator.isChar(c)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String extractDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Validator.isDigit(c)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String extractFirst(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractFirst(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractLast(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + 1);
    }

    public static String extractLast(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + delimiter.length());
    }

    public static String extractLeadingDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Validator.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
            ++n2;
        }
        return sb.toString();
    }

    public static String highlight(String s, String keywords) {
        return StringUtil.highlight(s, keywords, "<span class=\"highlight\">", "</span>");
    }

    public static String highlight(String s, String keywords, String highlight1, String highlight2) {
        if (Validator.isNull(s) || Validator.isNull(keywords)) {
            return s;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(keywords), 2);
        return StringUtil._highlight(s, pattern, highlight1, highlight2);
    }

    public static String highlight(String s, String[] queryTerms) {
        return StringUtil.highlight(s, queryTerms, "<span class=\"highlight\">", "</span>");
    }

    public static String highlight(String s, String[] queryTerms, String highlight1, String highlight2) {
        if (Validator.isNull(s) || Validator.isNull(queryTerms)) {
            return s;
        }
        if (queryTerms.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * queryTerms.length - 1);
        int i = 0;
        while (i < queryTerms.length) {
            sb.append(Pattern.quote(queryTerms[i].trim()));
            if (i + 1 < queryTerms.length) {
                sb.append("|");
            }
            ++i;
        }
        int flags = 66;
        Pattern pattern = Pattern.compile(sb.toString(), flags);
        return StringUtil._highlight(s, pattern, highlight1, highlight2);
    }

    public static String insert(String s, String insert, int offset) {
        if (s == null) {
            return null;
        }
        if (insert == null) {
            return s;
        }
        if (offset > s.length()) {
            return s.concat(insert);
        }
        String prefix = s.substring(0, offset);
        String postfix = s.substring(offset);
        return prefix.concat(insert).concat(postfix);
    }

    public static String lowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase();
    }

    public static void lowerCase(String ... array) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                array[i] = array[i].toLowerCase();
                ++i;
            }
        }
    }

    public static boolean matches(String s, String pattern) {
        String[] array;
        String[] stringArray = array = pattern.split("\\*");
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            int pos = s.indexOf(element);
            if (pos == -1) {
                return false;
            }
            s = s.substring(pos + element.length());
            ++n2;
        }
        return true;
    }

    public static boolean matchesIgnoreCase(String s, String pattern) {
        return StringUtil.matches(StringUtil.lowerCase(s), StringUtil.lowerCase(pattern));
    }

    public static String merge(boolean[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(boolean[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(char[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(char[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(Collection<?> col) {
        return StringUtil.merge(col, ",");
    }

    public static String merge(Collection<?> col, String delimiter) {
        if (col == null) {
            return null;
        }
        return StringUtil.merge(col.toArray(new Object[col.size()]), delimiter);
    }

    public static String merge(double[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(double[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(float[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(float[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(int[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(long[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(long[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(Object[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String merge(short[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(short[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]).trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String quote(String s) {
        return StringUtil.quote(s, '\'');
    }

    public static String quote(String s, char quote) {
        if (s == null) {
            return null;
        }
        return StringUtil.quote(s, String.valueOf(quote));
    }

    public static String quote(String s, String quote) {
        if (s == null) {
            return null;
        }
        return quote.concat(s).concat(quote);
    }

    public static String randomize(String s) {
        return Randomizer.getInstance().randomize(s);
    }

    public static String read(ClassLoader classLoader, String name) throws IOException {
        return StringUtil.read(classLoader, name, false);
    }

    public static String read(ClassLoader classLoader, String name, boolean all) throws IOException {
        if (all) {
            StringBundler sb = new StringBundler();
            Enumeration<URL> enu = classLoader.getResources(name);
            while (enu.hasMoreElements()) {
                URL url = enu.nextElement();
                InputStream is = url.openStream();
                if (is == null) {
                    throw new IOException("Unable to open resource at " + url.toString());
                }
                String s = StringUtil.read(is);
                if (s != null) {
                    sb.append(s);
                    sb.append("\n");
                }
                is.close();
            }
            return sb.toString().trim();
        }
        InputStream is = classLoader.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Unable to open resource in class loader " + name);
        }
        String s = StringUtil.read(is);
        is.close();
        return s;
    }

    public static String read(InputStream is) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        unsyncBufferedReader.close();
        return sb.toString().trim();
    }

    public static void readLines(InputStream is, Collection<String> lines) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            lines.add(line);
        }
        unsyncBufferedReader.close();
    }

    public static String remove(String s, String remove) {
        return StringUtil.remove(s, remove, ",");
    }

    public static String remove(String s, String remove, String delimiter) {
        if (s == null || remove == null || delimiter == null) {
            return null;
        }
        if (Validator.isNotNull(s) && !s.endsWith(delimiter)) {
            s = String.valueOf(s) + delimiter;
        }
        String drd = delimiter.concat(remove).concat(delimiter);
        String rd = remove.concat(delimiter);
        while (StringUtil.contains(s, remove, delimiter)) {
            int y;
            int x;
            int pos = s.indexOf(drd);
            if (pos == -1) {
                if (!s.startsWith(rd)) continue;
                x = remove.length() + delimiter.length();
                y = s.length();
                s = s.substring(x, y);
                continue;
            }
            x = pos + remove.length() + delimiter.length();
            y = s.length();
            String temp = s.substring(0, pos);
            s = temp.concat(s.substring(x, y));
        }
        return s;
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String replace(String s, char oldSub, String newSub) {
        char[] chars;
        if (s == null || newSub == null) {
            return null;
        }
        StringBundler sb = new StringBundler(s.length() + 5 * newSub.length());
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == oldSub) {
                sb.append(newSub);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String replace(String s, String oldSub, String newSub) {
        return StringUtil.replace(s, oldSub, newSub, 0);
    }

    public static String replace(String s, String oldSub, String newSub, int fromIndex) {
        int y;
        if (s == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return s;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = s.indexOf(oldSub, fromIndex)) >= 0) {
            StringBundler sb = new StringBundler();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, String begin, String end, Map<String, String> values) {
        StringBundler sb = StringUtil.replaceToStringBundler(s, begin, end, values);
        return sb.toString();
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        int i = 0;
        while (i < oldSubs.length) {
            s = StringUtil.replace(s, oldSubs[i], newSubs[i]);
            ++i;
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs, boolean exactMatch) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        if (!exactMatch) {
            return StringUtil.replace(s, oldSubs, newSubs);
        }
        int i = 0;
        while (i < oldSubs.length) {
            s = s.replaceAll("\\b" + oldSubs[i] + "\\b", newSubs[i]);
            ++i;
        }
        return s;
    }

    public static String replaceFirst(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceFirst(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceFirst(String s, String oldSub, String newSub) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.indexOf(oldSub);
        if (y >= 0) {
            return s.substring(0, y).concat(newSub).concat(s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceFirst(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        int i = 0;
        while (i < oldSubs.length) {
            s = StringUtil.replaceFirst(s, oldSubs[i], newSubs[i]);
            ++i;
        }
        return s;
    }

    public static String replaceLast(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceLast(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceLast(String s, String oldSub, String newSub) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.lastIndexOf(oldSub);
        if (y >= 0) {
            return s.substring(0, y).concat(newSub).concat(s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceLast(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        int i = 0;
        while (i < oldSubs.length) {
            s = StringUtil.replaceLast(s, oldSubs[i], newSubs[i]);
            ++i;
        }
        return s;
    }

    public static StringBundler replaceToStringBundler(String s, String begin, String end, Map<String, String> values) {
        if (s == null || begin == null || end == null || values == null || values.size() == 0) {
            return new StringBundler(s);
        }
        StringBundler sb = new StringBundler(values.size() * 2 + 1);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            String newValue = values.get(oldValue);
            if (newValue == null) {
                newValue = oldValue;
            }
            sb.append(newValue);
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static StringBundler replaceWithStringBundler(String s, String begin, String end, Map<String, StringBundler> values) {
        if (s == null || begin == null || end == null || values == null || values.size() == 0) {
            return new StringBundler(s);
        }
        int size = values.size() + 1;
        for (StringBundler valueSB : values.values()) {
            size += valueSB.index();
        }
        StringBundler sb = new StringBundler(size);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            StringBundler newValue = values.get(oldValue);
            if (newValue == null) {
                sb.append(oldValue);
            } else {
                sb.append(newValue);
            }
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        char[] reverse = new char[chars.length];
        int i = 0;
        while (i < chars.length) {
            reverse[i] = chars[chars.length - i - 1];
            ++i;
        }
        return new String(reverse);
    }

    public static String safePath(String path) {
        return StringUtil.replace(path, "//", "/");
    }

    public static String shorten(String s) {
        return StringUtil.shorten(s, 20);
    }

    public static String shorten(String s, int length) {
        return StringUtil.shorten(s, length, "...");
    }

    public static String shorten(String s, int length, String suffix) {
        if (s == null || suffix == null) {
            return null;
        }
        if (s.length() <= length) {
            return s;
        }
        if (length < suffix.length()) {
            return s.substring(0, length);
        }
        int curLength = length;
        int j = curLength - suffix.length();
        while (j >= 0) {
            if (Character.isWhitespace(s.charAt(j))) {
                curLength = j;
                break;
            }
            --j;
        }
        if (curLength == length) {
            curLength = length - suffix.length();
        }
        String temp = s.substring(0, curLength);
        return temp.concat(suffix);
    }

    public static String shorten(String s, String suffix) {
        return StringUtil.shorten(s, 20, suffix);
    }

    public static String[] split(String s) {
        return StringUtil.split(s, ',');
    }

    public static boolean[] split(String s, boolean x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, char delimiter) {
        if (Validator.isNull(s)) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).length() == 0) {
            return _emptyStringArray;
        }
        if (delimiter == '\r' || delimiter == '\n') {
            return StringUtil.splitLines(s);
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + 1;
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static double[] split(String s, double x) {
        return StringUtil.split(s, ",", x);
    }

    public static float[] split(String s, float x) {
        return StringUtil.split(s, ",", x);
    }

    public static int[] split(String s, int x) {
        return StringUtil.split(s, ",", x);
    }

    public static long[] split(String s, long x) {
        return StringUtil.split(s, ",", x);
    }

    public static short[] split(String s, short x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, String delimiter) {
        if (Validator.isNull(s) || delimiter == null || delimiter.equals("")) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).equals(delimiter)) {
            return _emptyStringArray;
        }
        if (delimiter.length() == 1) {
            return StringUtil.split(s, delimiter.charAt(0));
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + delimiter.length();
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static boolean[] split(String s, String delimiter, boolean x) {
        String[] array = StringUtil.split(s, delimiter);
        boolean[] newArray = new boolean[array.length];
        int i = 0;
        while (i < array.length) {
            boolean value = x;
            try {
                value = Boolean.valueOf(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static double[] split(String s, String delimiter, double x) {
        String[] array = StringUtil.split(s, delimiter);
        double[] newArray = new double[array.length];
        int i = 0;
        while (i < array.length) {
            double value = x;
            try {
                value = Double.parseDouble(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static float[] split(String s, String delimiter, float x) {
        String[] array = StringUtil.split(s, delimiter);
        float[] newArray = new float[array.length];
        int i = 0;
        while (i < array.length) {
            float value = x;
            try {
                value = Float.parseFloat(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static int[] split(String s, String delimiter, int x) {
        String[] array = StringUtil.split(s, delimiter);
        int[] newArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            int value = x;
            try {
                value = Integer.parseInt(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static long[] split(String s, String delimiter, long x) {
        String[] array = StringUtil.split(s, delimiter);
        long[] newArray = new long[array.length];
        int i = 0;
        while (i < array.length) {
            long value = x;
            try {
                value = Long.parseLong(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static short[] split(String s, String delimiter, short x) {
        String[] array = StringUtil.split(s, delimiter);
        short[] newArray = new short[array.length];
        int i = 0;
        while (i < array.length) {
            short value = x;
            try {
                value = Short.parseShort(array[i]);
            }
            catch (Exception exception) {}
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static String[] splitLines(String s) {
        if (Validator.isNull(s)) {
            return _emptyStringArray;
        }
        s = s.trim();
        ArrayList<String> lines = new ArrayList<String>();
        int lastIndex = 0;
        while (true) {
            int returnIndex = s.indexOf(13, lastIndex);
            int newLineIndex = s.indexOf(10, lastIndex);
            if (returnIndex == -1 && newLineIndex == -1) break;
            if (returnIndex == -1) {
                lines.add(s.substring(lastIndex, newLineIndex));
                lastIndex = newLineIndex + 1;
                continue;
            }
            if (newLineIndex == -1) {
                lines.add(s.substring(lastIndex, returnIndex));
                lastIndex = returnIndex + 1;
                continue;
            }
            if (newLineIndex < returnIndex) {
                lines.add(s.substring(lastIndex, newLineIndex));
                lastIndex = newLineIndex + 1;
                continue;
            }
            lines.add(s.substring(lastIndex, returnIndex));
            lastIndex = returnIndex + 1;
            if (lastIndex != newLineIndex) continue;
            ++lastIndex;
        }
        if (lastIndex < s.length()) {
            lines.add(s.substring(lastIndex));
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static boolean startsWith(String s, char begin) {
        return StringUtil.startsWith(s, new Character(begin).toString());
    }

    public static boolean startsWith(String s, String start) {
        if (s == null || start == null) {
            return false;
        }
        if (start.length() > s.length()) {
            return false;
        }
        String temp = s.substring(0, start.length());
        return temp.equalsIgnoreCase(start);
    }

    public static int startsWithWeight(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        int i = 0;
        while (i < chars1.length && i < chars2.length) {
            if (chars1[i] != chars2[i]) break;
            ++i;
        }
        return i;
    }

    public static String strip(String s, char remove) {
        if (s == null) {
            return null;
        }
        int x = s.indexOf(remove);
        if (x < 0) {
            return s;
        }
        int y = 0;
        StringBundler sb = new StringBundler(s.length());
        while (x >= 0) {
            sb.append(s.subSequence(y, x));
            y = x + 1;
            x = s.indexOf(remove, y);
        }
        sb.append(s.substring(y));
        return sb.toString();
    }

    public static String stripBetween(String s, String begin, String end) {
        if (s == null || begin == null || end == null) {
            return s;
        }
        StringBundler sb = new StringBundler(s.length());
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb.toString();
    }

    public static String toCharCode(String s) {
        StringBundler sb = new StringBundler(s.length());
        int i = 0;
        while (i < s.length()) {
            sb.append(s.codePointAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String toHexString(int i) {
        char[] buffer = new char[8];
        int index = 8;
        do {
            buffer[--index] = _HEX_DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        return new String(buffer, index, 8 - index);
    }

    public static String toHexString(long l) {
        char[] buffer = new char[16];
        int index = 16;
        do {
            buffer[--index] = _HEX_DIGITS[(int)(l & 0xFL)];
        } while ((l >>>= 4) != 0L);
        return new String(buffer, index, 16 - index);
    }

    public static String toHexString(Object obj) {
        if (obj instanceof Integer) {
            return StringUtil.toHexString((Integer)obj);
        }
        if (obj instanceof Long) {
            return StringUtil.toHexString((Long)obj);
        }
        return String.valueOf(obj);
    }

    public static String trim(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                x = i;
                break;
            }
            ++i;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        int i2 = len - 1;
        while (i2 > x) {
            char c = s.charAt(i2);
            if (!Character.isWhitespace(c)) {
                y = i2 + 1;
                break;
            }
            --i2;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trim(String s, char c) {
        return StringUtil.trim(s, new char[]{c});
    }

    public static String trim(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (exceptions == null || exceptions.length == 0) {
            return StringUtil.trim(s);
        }
        int x = len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!StringUtil._isTrimable(c, exceptions)) {
                x = i;
                break;
            }
            ++i;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        int i2 = len - 1;
        while (i2 > x) {
            char c = s.charAt(i2);
            if (!StringUtil._isTrimable(c, exceptions)) {
                y = i2 + 1;
                break;
            }
            --i2;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trimLeading(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                x = i;
                break;
            }
            ++i;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimLeading(String s, char c) {
        return StringUtil.trimLeading(s, new char[]{c});
    }

    public static String trimLeading(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (exceptions == null || exceptions.length == 0) {
            return StringUtil.trimLeading(s);
        }
        int x = len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!StringUtil._isTrimable(c, exceptions)) {
                x = i;
                break;
            }
            ++i;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int len = s.length();
        int x = 0;
        int i = len - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                x = i + 1;
                break;
            }
            --i;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String trimTrailing(String s, char c) {
        return StringUtil.trimTrailing(s, new char[]{c});
    }

    public static String trimTrailing(String s, char[] exceptions) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (exceptions == null || exceptions.length == 0) {
            return StringUtil.trimTrailing(s);
        }
        int len = s.length();
        int x = 0;
        int i = len - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (!StringUtil._isTrimable(c, exceptions)) {
                x = i + 1;
                break;
            }
            --i;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String unquote(String s) {
        if (Validator.isNull(s)) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String upperCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public static String upperCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }

    public static String valueOf(Object obj) {
        return String.valueOf(obj);
    }

    public static String wrap(String text) {
        return StringUtil.wrap(text, 80, "\n");
    }

    public static String wrap(String text, int width, String lineSeparator) {
        try {
            return StringUtil._wrap(text, width, lineSeparator);
        }
        catch (IOException ioe) {
            _log.error(ioe.getMessage());
            return text;
        }
    }

    private static String _highlight(String s, Pattern pattern, String highlight1, String highlight2) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * st.countTokens() - 1);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Matcher matcher = pattern.matcher(token);
            if (matcher.find()) {
                StringBuffer hightlighted = new StringBuffer();
                do {
                    matcher.appendReplacement(hightlighted, String.valueOf(highlight1) + matcher.group() + highlight2);
                } while (matcher.find());
                matcher.appendTail(hightlighted);
                sb.append(hightlighted);
            } else {
                sb.append(token);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private static boolean _isTrimable(char c, char[] exceptions) {
        char[] cArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            char exception = cArray[n2];
            if (c == exception) {
                return false;
            }
            ++n2;
        }
        return Character.isWhitespace(c);
    }

    private static String _wrap(String text, int width, String lineSeparator) throws IOException {
        if (text == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(text));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            String[] tokens;
            if (s.length() == 0) {
                sb.append(lineSeparator);
                continue;
            }
            int lineLength = 0;
            String[] stringArray = tokens = s.split(" ");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (lineLength + token.length() + 1 > width) {
                    if (lineLength > 0) {
                        sb.append(lineSeparator);
                    }
                    if (token.length() > width) {
                        int pos = token.indexOf(40);
                        if (pos != -1) {
                            sb.append(token.substring(0, pos + 1));
                            sb.append(lineSeparator);
                            token = token.substring(pos + 1);
                            sb.append(token);
                            lineLength = token.length();
                        } else {
                            sb.append(token);
                            lineLength = token.length();
                        }
                    } else {
                        sb.append(token);
                        lineLength = token.length();
                    }
                } else {
                    if (lineLength > 0) {
                        sb.append(" ");
                        ++lineLength;
                    }
                    sb.append(token);
                    lineLength += token.length();
                }
                ++n2;
            }
            sb.append(lineSeparator);
        }
        return sb.toString();
    }
}

