/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.ArrayList;

public class MethodParameter {
    private Class<?>[] _genericTypes;
    private boolean _initialized;
    private String _name;
    private String _signatures;
    private Class<?> _type;

    public MethodParameter(String name, String signatures, Class<?> type) {
        this._name = name;
        this._signatures = signatures;
        this._type = type;
    }

    public Class<?>[] getGenericTypes() throws ClassNotFoundException {
        if (this._initialized) {
            return this._genericTypes;
        }
        String[] genericSignatures = MethodParameter._extractTopLevelGenericSignatures(this._signatures);
        this._genericTypes = genericSignatures == null ? null : MethodParameter._loadGenericTypes(genericSignatures);
        this._initialized = true;
        return this._genericTypes;
    }

    public String getName() {
        return this._name;
    }

    public String getSignature() {
        return this._signatures;
    }

    public Class<?> getType() {
        return this._type;
    }

    private static String[] _extractTopLevelGenericSignatures(String signature) {
        if (signature == null) {
            return null;
        }
        int leftBracketIndex = signature.indexOf(60);
        if (leftBracketIndex == -1) {
            return null;
        }
        int rightBracketIndex = signature.lastIndexOf(62);
        if (rightBracketIndex == -1) {
            return null;
        }
        String generics = signature.substring(leftBracketIndex + 1, rightBracketIndex);
        StringBuilder sb = new StringBuilder(generics.length());
        ArrayList<String> list = new ArrayList<String>();
        int level = 0;
        int i = 0;
        while (i < generics.length()) {
            char c = generics.charAt(i);
            if (c == '<') {
                ++level;
            } else if (c == '>') {
                --level;
            } else if (level == 0) {
                sb.append(c);
                if (c == ';') {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private static Class<?>[] _loadGenericTypes(String[] signatures) throws ClassNotFoundException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class[] types = new Class[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            String className = signatures[i];
            char c = className.charAt(0);
            if (c == 'B') {
                types[i] = Byte.TYPE;
            } else if (c == 'C') {
                types[i] = Character.TYPE;
            } else if (c == 'D') {
                types[i] = Double.TYPE;
            } else if (c == 'F') {
                types[i] = Float.TYPE;
            } else if (c == 'I') {
                types[i] = Integer.TYPE;
            } else if (c == 'J') {
                types[i] = Long.TYPE;
            } else if (c == 'L') {
                className = className.substring(1, className.length() - 1);
                className = className.replace('/', '.');
                types[i] = contextClassLoader.loadClass(className);
            } else if (c == 'S') {
                types[i] = Short.TYPE;
            } else if (c == 'Z') {
                types[i] = Boolean.TYPE;
            } else if (c == 'V') {
                types[i] = Void.TYPE;
            } else if (c == '[') {
                className = className.replace('/', '.');
                types[i] = contextClassLoader.loadClass(className);
            } else {
                throw new ClassNotFoundException(className);
            }
            ++i;
        }
        return types;
    }
}

