/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LocaleUtil {
    private static final String _BETA_SUFFIX = " [Beta]";
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static LocaleUtil _instance = new LocaleUtil();
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static boolean equals(Locale locale1, Locale locale2) {
        return LocaleUtil.getInstance()._equals(locale1, locale2);
    }

    public static Locale fromLanguageId(String languageId) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, true);
    }

    public static Locale fromLanguageId(String languageId, boolean validate) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, validate);
    }

    public static Locale[] fromLanguageIds(List<String> languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return LocaleUtil.getInstance()._getDefault();
    }

    public static LocaleUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(LocaleUtil.class);
        return _instance;
    }

    public static Map<String, String> getISOLanguages(Locale locale) {
        return LocaleUtil.getInstance()._getISOLanguages(locale);
    }

    public static String getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return LocaleUtil.getInstance()._getLongDisplayName(locale, duplicateLanguages);
    }

    public static Locale getMostRelevantLocale() {
        return LocaleUtil.getInstance()._getMostRelevantLocale();
    }

    public static String getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return LocaleUtil.getInstance()._getShortDisplayName(locale, duplicateLanguages);
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        LocaleUtil.getInstance()._setDefault(userLanguage, userCountry, userVariant);
    }

    public static String toLanguageId(Locale locale) {
        return LocaleUtil.getInstance()._toLanguageId(locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return LocaleUtil.getInstance()._toLanguageIds(locales);
    }

    public static String toW3cLanguageId(Locale locale) {
        return LocaleUtil.getInstance()._toW3cLanguageId(locale);
    }

    public static String toW3cLanguageId(String languageId) {
        return LocaleUtil.getInstance()._toW3cLanguageId(languageId);
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return LocaleUtil.getInstance()._toW3cLanguageIds(locales);
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._toW3cLanguageIds(languageIds);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
    }

    private boolean _equals(Locale locale1, Locale locale2) {
        String languageId1 = this._toLanguageId(locale1);
        String languageId2 = this._toLanguageId(locale2);
        return languageId1.equalsIgnoreCase(languageId2);
    }

    private Locale _fromLanguageId(String languageId, boolean validate) {
        Locale locale;
        block9: {
            if (languageId == null) {
                return this._locale;
            }
            locale = this._locales.get(languageId);
            if (locale != null) {
                return locale;
            }
            try {
                int pos = languageId.indexOf(95);
                if (pos == -1) {
                    locale = new Locale(languageId);
                } else {
                    String[] languageIdParts = StringUtil.split(languageId, '_');
                    String languageCode = languageIdParts[0];
                    String countryCode = languageIdParts[1];
                    String variant = null;
                    if (languageIdParts.length > 2) {
                        variant = languageIdParts[2];
                    }
                    locale = Validator.isNotNull(variant) ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
                }
                if (validate && !LanguageUtil.isAvailableLanguageCode(languageId)) {
                    throw new IllegalArgumentException("Invalid locale " + locale);
                }
                this._locales.put(languageId, locale);
            }
            catch (Exception exception) {
                locale = null;
                if (!_log.isWarnEnabled()) break block9;
                _log.warn(String.valueOf(languageId) + " is not a valid language id");
            }
        }
        if (locale == null) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(List<String> languageIds) {
        Locale[] locales = new Locale[languageIds.size()];
        int i = 0;
        while (i < languageIds.size()) {
            locales[i] = this._fromLanguageId(languageIds.get(i), true);
            ++i;
        }
        return locales;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            locales[i] = this._fromLanguageId(languageIds[i], true);
            ++i;
        }
        return locales;
    }

    private Locale _getDefault() {
        Locale locale = LocaleThreadLocal.getDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return this._locale;
    }

    private String _getDisplayName(String language, String country, Locale locale, Set<String> duplicateLanguages) {
        StringBundler sb = new StringBundler(6);
        sb.append(language);
        if (duplicateLanguages.contains(locale.getLanguage())) {
            sb.append(" ");
            sb.append("(");
            sb.append(country);
            sb.append(")");
        }
        if (LanguageUtil.isBetaLocale(locale)) {
            sb.append(_BETA_SUFFIX);
        }
        return sb.toString();
    }

    private Map<String, String> _getISOLanguages(Locale locale) {
        TreeMap<String, String> isoLanguages = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String isoLanguageId = stringArray[n2];
            Locale isoLocale = this._fromLanguageId(isoLanguageId, true);
            isoLanguages.put(isoLocale.getDisplayLanguage(locale), isoLanguageId);
            ++n2;
        }
        return isoLanguages;
    }

    private String _getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return this._getDisplayName(locale.getDisplayLanguage(locale), locale.getDisplayCountry(locale), locale, duplicateLanguages);
    }

    private Locale _getMostRelevantLocale() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = this._getDefault();
        }
        return locale;
    }

    private String _getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        String language = locale.getDisplayLanguage(locale);
        if (language.length() > 3) {
            language = locale.getLanguage();
            language = language.toUpperCase();
        }
        String country = locale.getCountry();
        return this._getDisplayName(language, country.toUpperCase(), locale, duplicateLanguages);
    }

    private void _setDefault(String userLanguage, String userCountry, String userVariant) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry, userVariant);
        }
    }

    private String _toLanguageId(Locale locale) {
        if (locale == null) {
            locale = this._locale;
        }
        String country = locale.getCountry();
        boolean hasCountry = false;
        if (country.length() != 0) {
            hasCountry = true;
        }
        String variant = locale.getVariant();
        boolean hasVariant = false;
        if (variant.length() != 0) {
            hasVariant = true;
        }
        if (!hasCountry && !hasVariant) {
            return locale.getLanguage();
        }
        int length = 3;
        if (hasCountry && hasVariant) {
            length = 5;
        }
        StringBundler sb = new StringBundler(length);
        sb.append(locale.getLanguage());
        if (hasCountry) {
            sb.append("_");
            sb.append(country);
        }
        if (hasVariant) {
            sb.append("_");
            sb.append(variant);
        }
        return sb.toString();
    }

    private String[] _toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            languageIds[i] = this._toLanguageId(locales[i]);
            ++i;
        }
        return languageIds;
    }

    private String _toW3cLanguageId(Locale locale) {
        return this._toW3cLanguageId(this._toLanguageId(locale));
    }

    private String _toW3cLanguageId(String languageId) {
        return StringUtil.replace(languageId, '_', '-');
    }

    private String[] _toW3cLanguageIds(Locale[] locales) {
        return this._toW3cLanguageIds(this._toLanguageIds(locales));
    }

    private String[] _toW3cLanguageIds(String[] languageIds) {
        String[] w3cLanguageIds = new String[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            w3cLanguageIds[i] = this._toW3cLanguageId(languageIds[i]);
            ++i;
        }
        return w3cLanguageIds;
    }
}

