/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListUtil {
    public static <E> List<E> copy(List<E> master) {
        if (master == null) {
            return null;
        }
        return new ArrayList<E>(master);
    }

    public static <E> void copy(List<E> master, List<? super E> copy) {
        if (master == null || copy == null) {
            return;
        }
        copy.clear();
        copy.addAll(master);
    }

    public static void distinct(List<?> list) {
        ListUtil.distinct(list, null);
    }

    public static <E> void distinct(List<E> list, Comparator<E> comparator) {
        if (list == null || list.isEmpty()) {
            return;
        }
        HashSet<E> set = new HashSet<E>();
        Iterator<E> itr = list.iterator();
        while (itr.hasNext()) {
            E obj = itr.next();
            if (set.contains(obj)) {
                itr.remove();
                continue;
            }
            set.add(obj);
        }
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    public static <E> List<E> fromArray(E[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static <E> List<E> fromCollection(Collection<E> c) {
        if (c != null && List.class.isAssignableFrom(c.getClass())) {
            return (List)c;
        }
        if (c == null || c.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(c.size());
        list.addAll(c);
        return list;
    }

    public static <E> List<E> fromEnumeration(Enumeration<E> enu) {
        ArrayList<E> list = new ArrayList<E>();
        while (enu.hasMoreElements()) {
            E obj = enu.nextElement();
            list.add(obj);
        }
        return list;
    }

    public static List<String> fromFile(File file) throws IOException {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(file));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            list.add(s);
        }
        unsyncBufferedReader.close();
        return list;
    }

    public static List<String> fromFile(String fileName) throws IOException {
        return ListUtil.fromFile(new File(fileName));
    }

    public static <E> List<E> fromMapKeys(Map<E, ?> map) {
        if (map == null || map.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(map.size());
        for (Map.Entry<E, ?> entry : map.entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public static <E> List<E> fromMapValues(Map<?, E> map) {
        if (map == null || map.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(map.size());
        for (Map.Entry<?, E> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static List<String> fromString(String s) {
        return ListUtil.fromArray(StringUtil.splitLines(s));
    }

    public static <E> boolean remove(List<E> list, E element) {
        Iterator<E> itr = list.iterator();
        while (itr.hasNext()) {
            E curElement = itr.next();
            if (curElement != element && !curElement.equals(element)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static <E> List<E> sort(List<E> list) {
        return ListUtil.sort(list, null);
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        if (UnmodifiableList.class.isAssignableFrom(list.getClass())) {
            list = ListUtil.copy(list);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> subList(List<E> list, int start, int end) {
        ArrayList<E> newList = new ArrayList<E>();
        int normalizedSize = list.size() - 1;
        if (start < 0 || start > normalizedSize || end < 0 || start > end) {
            return newList;
        }
        int i = start;
        while (i < end && i <= normalizedSize) {
            newList.add(list.get(i));
            ++i;
        }
        return newList;
    }

    public static List<Boolean> toList(boolean[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value = blArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }

    public static List<Character> toList(char[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> list = new ArrayList<Character>(array.length);
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char value = cArray[n2];
            list.add(Character.valueOf(value));
            ++n2;
        }
        return list;
    }

    public static List<Double> toList(double[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }

    public static <E> List<E> toList(E[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static List<Float> toList(float[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            list.add(Float.valueOf(value));
            ++n2;
        }
        return list;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }

    public static List<Long> toList(long[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }

    public static List<Short> toList(short[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        short[] sArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            short value = sArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }

    public static String toString(List<?> list, String param) {
        return ListUtil.toString(list, param, ",");
    }

    public static String toString(List<?> list, String param, String delimiter) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.size() - 1);
        int i = 0;
        while (i < list.size()) {
            Object bean = list.get(i);
            Object value = BeanPropertiesUtil.getObject(bean, param);
            if (value != null) {
                sb.append(value);
            }
            if (i + 1 != list.size()) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static <T, V> String toString(List<T> list, Accessor<T, V> accessor) {
        return ListUtil.toString(list, accessor, ",");
    }

    public static <T, V> String toString(List<T> list, Accessor<T, V> accessor, String delimiter) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.size() - 1);
        int i = 0;
        while (i < list.size()) {
            T bean = list.get(i);
            V value = accessor.get(bean);
            if (value != null) {
                sb.append(value);
            }
            if (i + 1 != list.size()) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }
}

