/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.dao.orm;

import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeOptimizedResultSetHandler
implements InvocationHandler {
    private static final int _LONGNVARCHAR = -16;
    private static final int _NCHAR = -15;
    private static final int _NCLOB = 2011;
    private static final int _NVARCHAR = -9;
    private static final int _SQLXML = 2009;
    private List<String> _columnNames = new ArrayList<String>();
    private Map<Object, Integer> _columnTypes = new HashMap<Object, Integer>();
    private Map<Object, Object> _columnValues = new HashMap<Object, Object>();
    private boolean _next;
    private ResultSet _resultSet;

    public UpgradeOptimizedResultSetHandler(ResultSet resultSet) throws SQLException {
        this._resultSet = resultSet;
        this._columnNames.add("");
        ResultSetMetaData resultSetMetaData = this._resultSet.getMetaData();
        int i = 1;
        while (i <= resultSetMetaData.getColumnCount()) {
            int columnType = resultSetMetaData.getColumnType(i);
            this._columnTypes.put(i, columnType);
            String columnName = resultSetMetaData.getColumnName(i);
            this._columnNames.add(columnName);
            String lowerCaseColumnName = columnName.toLowerCase();
            this._columnTypes.put(lowerCaseColumnName, columnType);
            ++i;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("close")) {
            this._resultSet.close();
            return null;
        }
        if (methodName.equals("next")) {
            if (this._resultSet.isBeforeFirst()) {
                this._next = this._resultSet.next();
            }
            Boolean returnValue = this._next;
            this._cacheColumnValues();
            if (this._next) {
                this._next = this._resultSet.next();
            }
            return returnValue;
        }
        Object column = arguments[0];
        if (column instanceof String) {
            String columnString = (String)column;
            column = columnString.toLowerCase();
        }
        Object returnValue = this._columnValues.get(column);
        if (methodName.equals("getBoolean")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return GetterUtil.getBoolean(returnValue);
            }
            Number number = (Number)returnValue;
            double doubleValue = number.doubleValue();
            if (doubleValue == 0.0) {
                return false;
            }
            return true;
        }
        if (methodName.equals("getDouble")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return GetterUtil.getDouble(returnValue);
            }
            Number number = (Number)returnValue;
            return number.doubleValue();
        }
        if (methodName.equals("getFloat")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return Float.valueOf(GetterUtil.getFloat(returnValue));
            }
            Number number = (Number)returnValue;
            return Float.valueOf(number.floatValue());
        }
        if (methodName.equals("getInt")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return GetterUtil.getInteger(returnValue);
            }
            Number number = (Number)returnValue;
            return number.intValue();
        }
        if (methodName.equals("getLong")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return GetterUtil.getLong(returnValue);
            }
            Number number = (Number)returnValue;
            return number.longValue();
        }
        if (methodName.equals("getShort")) {
            if (returnValue == null || !(returnValue instanceof Number)) {
                return GetterUtil.getShort(returnValue);
            }
            Number number = (Number)returnValue;
            return number.shortValue();
        }
        if (methodName.equals("getString")) {
            if (returnValue == null || returnValue instanceof String) {
                return returnValue;
            }
            return String.valueOf(returnValue);
        }
        return returnValue;
    }

    private void _cacheColumnValues() throws Exception {
        this._columnValues.clear();
        if (!this._next) {
            return;
        }
        int i = 1;
        while (i < this._columnNames.size()) {
            String columnName = this._columnNames.get(i);
            String lowerCaseColumnName = columnName.toLowerCase();
            Integer columnType = this._columnTypes.get(lowerCaseColumnName);
            Object value = this._getValue(columnName, columnType);
            this._columnValues.put(i, value);
            this._columnValues.put(lowerCaseColumnName, value);
            ++i;
        }
    }

    private Object _getValue(String name, Integer type) throws Exception {
        Object value = null;
        int t = type;
        if (t == -5) {
            value = GetterUtil.getLong(this._resultSet.getLong(name));
        } else if (t == -2) {
            value = this._resultSet.getBytes(name);
        } else if (t == -7) {
            value = GetterUtil.getBoolean(this._resultSet.getBoolean(name));
        } else if (t == 2004) {
            value = this._resultSet.getBytes(name);
        } else if (t == 16) {
            value = GetterUtil.getBoolean(this._resultSet.getBoolean(name));
        } else if (t == 1) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 2005) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 91) {
            value = this._resultSet.getDate(name);
        } else if (t == 3) {
            value = this._resultSet.getBigDecimal(name);
        } else if (t == 8) {
            value = GetterUtil.getDouble(this._resultSet.getDouble(name));
        } else if (t == 6) {
            value = Float.valueOf(GetterUtil.getFloat(Float.valueOf(this._resultSet.getFloat(name))));
        } else if (t == 4) {
            value = GetterUtil.getInteger(this._resultSet.getInt(name));
        } else if (t == -16) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == -4) {
            value = this._resultSet.getBytes(name);
        } else if (t == -1) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == -15) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 2011) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 2) {
            value = GetterUtil.getLong(this._resultSet.getLong(name));
        } else if (t == -9) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 7) {
            value = Float.valueOf(GetterUtil.getFloat(Float.valueOf(this._resultSet.getFloat(name))));
        } else if (t == -8) {
            value = Float.valueOf(GetterUtil.getFloat(Float.valueOf(this._resultSet.getFloat(name))));
        } else if (t == 5) {
            value = GetterUtil.getShort(this._resultSet.getShort(name));
        } else if (t == 2009) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else if (t == 92) {
            value = this._resultSet.getTime(name);
        } else if (t == 93) {
            value = this._resultSet.getTimestamp(name);
        } else if (t == -6) {
            value = GetterUtil.getShort(this._resultSet.getShort(name));
        } else if (t == -3) {
            value = this._resultSet.getBytes(name);
        } else if (t == 12) {
            value = GetterUtil.getString(this._resultSet.getString(name));
        } else {
            throw new UpgradeException("Upgrade code using unsupported class type " + type);
        }
        return value;
    }
}

