/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.TemplateParser;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.templateparser.Transformer;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.Map;

public abstract class BaseTransformer
implements Transformer {
    private static Log _log = LogFactoryUtil.getLog(BaseTransformer.class);
    private static Log _logOutputAfterListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".OutputAfterListener");
    private static Log _logOutputBeforeListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".OutputBeforeListener");
    private static Log _logScriptAfterListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".ScriptAfterListener");
    private static Log _logScriptBeforeListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".ScriptBeforeListener");
    private static Log _logTokens = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".Tokens");
    private static Log _logTransformBefore = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".TransformBefore");
    private static Log _logTransfromAfter = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".TransformAfter");
    private static Log _logXmlAfterListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".XmlAfterListener");
    private static Log _logXmlBeforeListener = LogFactoryUtil.getLog(String.valueOf(BaseTransformer.class.getName()) + ".XmlBeforeListener");

    @Override
    public String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script, String langType) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Language " + languageId);
        }
        if (Validator.isNull(viewMode)) {
            viewMode = "view";
        }
        if (_logTokens.isDebugEnabled()) {
            String tokensString = PropertiesUtil.list(tokens);
            _logTokens.debug(tokensString);
        }
        if (_logTransformBefore.isDebugEnabled()) {
            _logTransformBefore.debug(xml);
        }
        ArrayList<TransformerListener> listenersList = new ArrayList<TransformerListener>();
        String[] listeners = this.getTransformerListenersClassNames();
        int i = 0;
        while (i < listeners.length) {
            TransformerListener listener = null;
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Instantiate listener " + listeners[i]);
                }
                boolean templateDriven = Validator.isNotNull(langType);
                ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
                listener = (TransformerListener)InstanceFactory.newInstance(classLoader, listeners[i]);
                listener.setTemplateDriven(templateDriven);
                listener.setLanguageId(languageId);
                listener.setTokens(tokens);
                listenersList.add(listener);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            if (_logXmlBeforeListener.isDebugEnabled()) {
                _logXmlBeforeListener.debug(xml);
            }
            if (listener != null) {
                xml = listener.onXml(xml);
                if (_logXmlAfterListener.isDebugEnabled()) {
                    _logXmlAfterListener.debug(xml);
                }
            }
            if (_logScriptBeforeListener.isDebugEnabled()) {
                _logScriptBeforeListener.debug(script);
            }
            if (listener != null) {
                script = listener.onScript(script);
                if (_logScriptAfterListener.isDebugEnabled()) {
                    _logScriptAfterListener.debug(script);
                }
            }
            ++i;
        }
        String output = null;
        if (Validator.isNull(langType)) {
            output = LocalizationUtil.getLocalization(xml, languageId);
        } else {
            String templateParserClassName = this.getTemplateParserClassName(langType);
            if (_log.isDebugEnabled()) {
                _log.debug("Template parser class name " + templateParserClassName);
            }
            if (Validator.isNotNull(templateParserClassName)) {
                TemplateParser templateParser = null;
                try {
                    templateParser = (TemplateParser)InstanceFactory.newInstance(PortalClassLoaderUtil.getClassLoader(), templateParserClassName);
                }
                catch (Exception e) {
                    throw new TransformException(e);
                }
                templateParser.setLanguageId(languageId);
                templateParser.setScript(script);
                templateParser.setThemeDisplay(themeDisplay);
                templateParser.setTokens(tokens);
                templateParser.setViewMode(viewMode);
                templateParser.setXML(xml);
                output = templateParser.transform();
            }
        }
        int i2 = 0;
        while (i2 < listenersList.size()) {
            TransformerListener listener = (TransformerListener)listenersList.get(i2);
            if (_logOutputBeforeListener.isDebugEnabled()) {
                _logOutputBeforeListener.debug(output);
            }
            output = listener.onOutput(output);
            if (_logOutputAfterListener.isDebugEnabled()) {
                _logOutputAfterListener.debug(output);
            }
            ++i2;
        }
        if (_logTransfromAfter.isDebugEnabled()) {
            _logTransfromAfter.debug(output);
        }
        return output;
    }

    protected abstract String getTemplateParserClassName(String var1);

    protected abstract String[] getTransformerListenersClassNames();
}

