/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TemplateParser;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BaseTemplateParser
implements TemplateParser {
    private Map<String, Object> _contextObjects = new HashMap<String, Object>();
    private String _languageId;
    private String _script;
    private ThemeDisplay _themeDisplay;
    private Map<String, String> _tokens;
    private String _viewMode;
    private String _xml;

    @Override
    public String getLanguageId() {
        return this._languageId;
    }

    @Override
    public String getScript() {
        return this._script;
    }

    @Override
    public ThemeDisplay getThemeDisplay() {
        return this._themeDisplay;
    }

    @Override
    public Map<String, String> getTokens() {
        return this._tokens;
    }

    @Override
    public String getViewMode() {
        return this._viewMode;
    }

    @Override
    public String getXML() {
        return this._xml;
    }

    public void setContextObjects(Map<String, Object> contextObjects) {
        this._contextObjects = contextObjects;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    @Override
    public void setScript(String script) {
        this._script = script;
    }

    @Override
    public void setThemeDisplay(ThemeDisplay themeDisplay) {
        this._themeDisplay = themeDisplay;
    }

    @Override
    public void setTokens(Map<String, String> tokens) {
        this._tokens = tokens;
    }

    @Override
    public void setViewMode(String viewMode) {
        this._viewMode = viewMode;
    }

    @Override
    public void setXML(String xml) {
        this._xml = xml;
    }

    @Override
    public String transform() throws TransformException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        boolean load = false;
        try {
            TemplateContext templateContext = this.getTemplateContext();
            if (Validator.isNotNull(this._xml)) {
                Document document = SAXReaderUtil.read(this._xml);
                Element rootElement = document.getRootElement();
                List<TemplateNode> templateNodes = this.getTemplateNodes(rootElement);
                if (templateNodes != null) {
                    for (TemplateNode templateNode : templateNodes) {
                        templateContext.put(templateNode.getName(), templateNode);
                    }
                }
                Element requestElement = rootElement.element("request");
                templateContext.put("request", this.insertRequestVariables(requestElement));
                templateContext.put("xmlRequest", requestElement.asXML());
            }
            if (this._contextObjects != null) {
                for (String key : this._contextObjects.keySet()) {
                    templateContext.put(key, this._contextObjects.get(key));
                }
            }
            this.populateTemplateContext(templateContext);
            load = this.mergeTemplate(templateContext, unsyncStringWriter);
        }
        catch (Exception e) {
            if (e instanceof DocumentException) {
                throw new TransformException("Unable to read XML document", e);
            }
            if (e instanceof IOException) {
                throw new TransformException("Error reading template", e);
            }
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            throw new TransformException("Unhandled exception", e);
        }
        if (!load) {
            throw new TransformException("Unable to dynamically load transform script");
        }
        return unsyncStringWriter.toString();
    }

    protected long getArticleGroupId() {
        return GetterUtil.getLong(this._tokens.get("article_group_id"));
    }

    protected Company getCompany() throws Exception {
        if (this._themeDisplay != null) {
            return this._themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany(this.getCompanyId());
    }

    protected long getCompanyGroupId() {
        if (this._themeDisplay != null) {
            return this._themeDisplay.getCompanyGroupId();
        }
        return GetterUtil.getLong(this._tokens.get("company_group_id"));
    }

    protected long getCompanyId() {
        if (this._themeDisplay != null) {
            return this._themeDisplay.getCompanyId();
        }
        return GetterUtil.getLong(this._tokens.get("company_id"));
    }

    protected Device getDevice() {
        if (this._themeDisplay != null) {
            return this._themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    protected long getGroupId() {
        return this.getArticleGroupId();
    }

    protected long getScopeGroupId() {
        return GetterUtil.getLong(this._tokens.get("scope_group_id"));
    }

    protected abstract TemplateContext getTemplateContext() throws Exception;

    protected String getTemplateId() {
        long companyGroupId = this.getCompanyGroupId();
        String templateId = null;
        if (this._tokens != null) {
            templateId = this._tokens.get("template_id");
        }
        if (Validator.isNull(templateId)) {
            templateId = String.valueOf(this._contextObjects.get("template_id"));
        }
        StringBundler sb = new StringBundler(5);
        sb.append(this.getCompanyId());
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(this.getGroupId());
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    protected abstract List<TemplateNode> getTemplateNodes(Element var1) throws Exception;

    protected Map<String, Object> insertRequestVariables(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (element == null) {
            return map;
        }
        for (Element childElement : element.elements()) {
            Element nameElement;
            String name = childElement.getName();
            if (name.equals("attribute")) {
                nameElement = childElement.element("name");
                Element valueElement = childElement.element("value");
                map.put(nameElement.getText(), valueElement.getText());
                continue;
            }
            if (name.equals("parameter")) {
                nameElement = childElement.element("name");
                List<Element> valueElements = childElement.elements("value");
                if (valueElements.size() == 1) {
                    Element valueElement = valueElements.get(0);
                    map.put(nameElement.getText(), valueElement.getText());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueElement : valueElements) {
                    values.add(valueElement.getText());
                }
                map.put(nameElement.getText(), values);
                continue;
            }
            if (childElement.elements().size() > 0) {
                map.put(name, this.insertRequestVariables(childElement));
                continue;
            }
            map.put(name, childElement.getText());
        }
        return map;
    }

    protected abstract boolean mergeTemplate(TemplateContext var1, UnsyncStringWriter var2) throws Exception;

    protected void populateTemplateContext(TemplateContext templateContext) throws Exception {
        templateContext.put("articleGroupId", this.getArticleGroupId());
        templateContext.put("company", this.getCompany());
        templateContext.put("companyId", this.getCompanyId());
        templateContext.put("device", this.getDevice());
        templateContext.put("groupId", this.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId(this._languageId);
        templateContext.put("locale", locale);
        templateContext.put("permissionChecker", PermissionThreadLocal.getPermissionChecker());
        templateContext.put("scopeGroupId", this.getScopeGroupId());
        templateContext.put("viewMode", this._viewMode);
    }
}

