/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdHttpSession;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortletSessionListenerManager
implements HttpSessionListener {
    private static List<HttpSessionListener> _httpSessionListeners = new ArrayList<HttpSessionListener>();

    public static void addHttpSessionListener(HttpSessionListener httpSessionListener) {
        _httpSessionListeners.add(httpSessionListener);
    }

    public static void removeHttpSessionListener(HttpSessionListener httpSessionListener) {
        _httpSessionListeners.remove(httpSessionListener);
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            for (HttpSessionListener httpSessionListener : _httpSessionListeners) {
                Class<?> clazz = httpSessionListener.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                currentThread.setContextClassLoader(classLoader);
                httpSessionListener.sessionCreated(httpSessionEvent);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        httpSessionEvent = this.getHttpSessionEvent(httpSessionEvent);
        for (HttpSessionListener httpSessionListener : _httpSessionListeners) {
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
    }

    protected HttpSessionEvent getHttpSessionEvent(HttpSessionEvent httpSessionEvent) {
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            CompoundSessionIdHttpSession compoundSessionIdHttpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
            httpSessionEvent = new HttpSessionEvent((HttpSession)compoundSessionIdHttpSession);
        }
        return httpSessionEvent;
    }
}

