/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.log;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.log.LoggingProcessCallable;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class ProcessOutputStream
extends UnsyncByteArrayOutputStream {
    private final boolean _error;
    private final ObjectOutputStream _objectOutputStream;

    public ProcessOutputStream(ObjectOutputStream objectOutputStream) {
        this(objectOutputStream, false);
    }

    public ProcessOutputStream(ObjectOutputStream objectOutputStream, boolean error) {
        this._objectOutputStream = objectOutputStream;
        this._error = error;
    }

    @Override
    public void close() throws IOException {
        this._objectOutputStream.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.index > 0) {
            byte[] bytes = this.toByteArray();
            LoggingProcessCallable loggingProcessCallable = new LoggingProcessCallable(bytes, this._error);
            this.writeProcessCallable(loggingProcessCallable);
            this.reset();
        }
    }

    public void writeProcessCallable(ProcessCallable<?> processCallable) throws IOException {
        this._objectOutputStream.writeObject(processCallable);
        this._objectOutputStream.flush();
    }
}

