/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.monitoring.statistics;

import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSampleThreadLocal
implements Cloneable {
    private static ThreadLocal<DataSampleThreadLocal> _dataSampleThreadLocal = new AutoResetThreadLocal<DataSampleThreadLocal>(DataSampleThreadLocal.class + "._dataSampleThreadLocal", new DataSampleThreadLocal());
    private static boolean _monitoringDataSampleThreadLocal;
    private List<DataSample> _dataSamples = new ArrayList<DataSample>();
    private long _monitorTime = System.currentTimeMillis();

    public static void addDataSample(DataSample dataSample) {
        if (!_monitoringDataSampleThreadLocal) {
            return;
        }
        _dataSampleThreadLocal.get()._addDataSample(dataSample);
    }

    public static void clearDataSamples() {
        _dataSampleThreadLocal.remove();
    }

    public static List<DataSample> getDataSamples() {
        if (!_monitoringDataSampleThreadLocal) {
            return Collections.emptyList();
        }
        return _dataSampleThreadLocal.get()._getDataSamples();
    }

    public static boolean isMonitoringDataSampleThreadLocal() {
        return _monitoringDataSampleThreadLocal;
    }

    public static void setMonitoringDataSampleThreadLocal(boolean monitoringDataSampleThreadLocal) {
        _monitoringDataSampleThreadLocal = monitoringDataSampleThreadLocal;
    }

    public Object clone() {
        return new DataSampleThreadLocal();
    }

    public long getMonitorTime() {
        return this._monitorTime;
    }

    private DataSampleThreadLocal() {
    }

    private void _addDataSample(DataSample dataSample) {
        this._dataSamples.add(dataSample);
    }

    private List<DataSample> _getDataSamples() {
        return this._dataSamples;
    }
}

