/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;

public class HotDeployEvent {
    private static Log _log = LogFactoryUtil.getLog(HotDeployEvent.class);
    private ClassLoader _contextClassLoader;
    private boolean _dependencyManagementEnabled = true;
    private Set<String> _dependentServletContextNames = new HashSet<String>();
    private PluginPackage _pluginPackage;
    private ServletContext _servletContext;

    public HotDeployEvent(ServletContext servletContext, ClassLoader contextClassLoader) {
        this(servletContext, contextClassLoader, true);
    }

    public HotDeployEvent(ServletContext servletContext, ClassLoader contextClassLoader, boolean dependencyManagementEnabled) {
        this._servletContext = servletContext;
        this._contextClassLoader = contextClassLoader;
        this._dependencyManagementEnabled = dependencyManagementEnabled;
        try {
            this.initDependentServletContextNames();
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
    }

    public ClassLoader getContextClassLoader() {
        return this._contextClassLoader;
    }

    public Set<String> getDependentServletContextNames() {
        return this._dependentServletContextNames;
    }

    public PluginPackage getPluginPackage() {
        return this._pluginPackage;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getServletContextName() {
        return this._servletContext.getServletContextName();
    }

    public boolean isDependencyManagementEnabled() {
        return this._dependencyManagementEnabled;
    }

    public void setPluginPackage(PluginPackage pluginPackage) {
        this._pluginPackage = pluginPackage;
    }

    protected void initDependentServletContextNames() throws IOException {
        if (!this._dependencyManagementEnabled) {
            return;
        }
        InputStream is = this._servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.properties");
        if (is != null) {
            String propertiesString = StringUtil.read(is);
            is.close();
            Properties properties = PropertiesUtil.load(propertiesString);
            Object[] requiredDeploymentContexts = StringUtil.split(properties.getProperty("required-deployment-contexts"));
            if (requiredDeploymentContexts.length > 0 && _log.isInfoEnabled()) {
                _log.info("Plugin " + this._servletContext.getServletContextName() + " requires " + StringUtil.merge(requiredDeploymentContexts, ", "));
            }
            Object[] objectArray = requiredDeploymentContexts;
            int n = requiredDeploymentContexts.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredDeploymentContext = objectArray[n2];
                this._dependentServletContextNames.add(requiredDeploymentContext.trim());
                ++n2;
            }
        }
    }
}

