/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.BaseLocalService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class BaseActionableDynamicQuery
implements ActionableDynamicQuery {
    private BaseLocalService _baseLocalService;
    private ClassLoader _classLoader;
    private Class<?> _clazz;
    private long _companyId;
    private Method _dynamicQueryMethod;
    private long _groupId;
    private int _interval = 10000;
    private String _primaryKeyPropertyName;

    @Override
    public void performActions() throws PortalException, SystemException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(this._clazz, this._classLoader);
        Projection minPrimaryKeyProjection = ProjectionFactoryUtil.min(this._primaryKeyPropertyName);
        Projection maxPrimaryKeyProjection = ProjectionFactoryUtil.max(this._primaryKeyPropertyName);
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minPrimaryKeyProjection);
        projectionList.add(maxPrimaryKeyProjection);
        dynamicQuery.setProjection(projectionList);
        this.addDefaultCriteria(dynamicQuery);
        this.addCriteria(dynamicQuery);
        List results = this.dynamicQuery(dynamicQuery);
        Object[] minAndMaxPrimaryKeys = (Object[])results.get(0);
        if (minAndMaxPrimaryKeys[0] == null || minAndMaxPrimaryKeys[1] == null) {
            return;
        }
        long minPrimaryKey = (Long)minAndMaxPrimaryKeys[0];
        long maxPrimaryKey = (Long)minAndMaxPrimaryKeys[1];
        long startPrimaryKey = minPrimaryKey;
        long endPrimaryKey = startPrimaryKey + (long)this._interval;
        while (startPrimaryKey <= maxPrimaryKey) {
            this.performActions(startPrimaryKey, endPrimaryKey);
            startPrimaryKey = endPrimaryKey;
            endPrimaryKey += (long)this._interval;
        }
    }

    public void performActions(long startPrimaryKey, long endPrimaryKey) throws PortalException, SystemException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(this._clazz, this._classLoader);
        Property property = PropertyFactoryUtil.forName(this._primaryKeyPropertyName);
        dynamicQuery.add(property.ge(startPrimaryKey));
        dynamicQuery.add(property.lt(endPrimaryKey));
        this.addDefaultCriteria(dynamicQuery);
        this.addCriteria(dynamicQuery);
        List objects = this.dynamicQuery(dynamicQuery);
        for (Object object : objects) {
            this.performAction(object);
        }
    }

    @Override
    public void setBaseLocalService(BaseLocalService baseLocalService) throws SystemException {
        this._baseLocalService = baseLocalService;
        Class<?> clazz = this._baseLocalService.getClass();
        try {
            this._dynamicQueryMethod = clazz.getMethod("dynamicQuery", DynamicQuery.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new SystemException(nsme);
        }
    }

    @Override
    public void setClass(Class<?> clazz) {
        this._clazz = clazz;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @Override
    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    @Override
    public void setInterval(int interval) {
        this._interval = interval;
    }

    @Override
    public void setPrimaryKeyPropertyName(String primaryKeyPropertyName) {
        this._primaryKeyPropertyName = primaryKeyPropertyName;
    }

    protected void addCriteria(DynamicQuery dynamicQuery) {
    }

    protected void addDefaultCriteria(DynamicQuery dynamicQuery) {
        Property property;
        if (this._companyId > 0L) {
            property = PropertyFactoryUtil.forName("companyId");
            dynamicQuery.add(property.eq(this._companyId));
        }
        if (this._groupId > 0L) {
            property = PropertyFactoryUtil.forName("groupId");
            dynamicQuery.add(property.eq(this._groupId));
        }
    }

    protected List dynamicQuery(DynamicQuery dynamicQuery) throws PortalException, SystemException {
        try {
            return (List)this._dynamicQueryMethod.invoke((Object)this._baseLocalService, dynamicQuery);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = ite.getCause();
            if (throwable instanceof PortalException) {
                throw (PortalException)throwable;
            }
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            throw new SystemException(ite);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    protected abstract void performAction(Object var1) throws PortalException, SystemException;
}

