/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.SpringFailOnTimeout;
import org.springframework.test.context.junit4.statements.SpringRepeat;
import org.springframework.util.ReflectionUtils;

public class SpringJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog(SpringJUnit4ClassRunner.class);
    private static final Method withRulesMethod = ReflectionUtils.findMethod(SpringJUnit4ClassRunner.class, (String)"withRules", (Class[])new Class[]{FrameworkMethod.class, Object.class, Statement.class});
    private final TestContextManager testContextManager;

    public SpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SpringJUnit4ClassRunner constructor called with [" + clazz + "]"));
        }
        this.testContextManager = this.createTestContextManager(clazz);
    }

    protected TestContextManager createTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    @Override
    public Description getDescription() {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            return Description.createSuiteDescription(this.getTestClass().getJavaClass());
        }
        return super.getDescription();
    }

    @Override
    public void run(RunNotifier notifier) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        super.run(notifier);
    }

    @Override
    protected Statement withBeforeClasses(Statement statement) {
        Statement junitBeforeClasses = super.withBeforeClasses(statement);
        return new RunBeforeTestClassCallbacks(junitBeforeClasses, this.getTestContextManager());
    }

    @Override
    protected Statement withAfterClasses(Statement statement) {
        Statement junitAfterClasses = super.withAfterClasses(statement);
        return new RunAfterTestClassCallbacks(junitAfterClasses, this.getTestContextManager());
    }

    @Override
    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.getTestContextManager().prepareTestInstance(testInstance);
        return testInstance;
    }

    @Override
    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier notifier) {
        Description description = this.describeChild(frameworkMethod);
        if (this.isTestMethodIgnored(frameworkMethod)) {
            notifier.fireTestIgnored(description);
        } else {
            Statement statement;
            try {
                statement = this.methodBlock(frameworkMethod);
            }
            catch (Throwable ex) {
                statement = new Fail(ex);
            }
            this.runLeaf(statement, description, notifier);
        }
    }

    @Override
    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                @Override
                protected Object runReflectiveCall() throws Throwable {
                    return SpringJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withRulesReflectively(frameworkMethod, testInstance, statement);
        statement = this.withPotentialRepeat(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        return statement;
    }

    private Statement withRulesReflectively(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        return (Statement)ReflectionUtils.invokeMethod((Method)withRulesMethod, (Object)this, (Object[])new Object[]{frameworkMethod, testInstance, statement});
    }

    protected boolean isTestMethodIgnored(FrameworkMethod frameworkMethod) {
        Method method = frameworkMethod.getMethod();
        return method.isAnnotationPresent(Ignore.class) || !ProfileValueUtils.isTestEnabledInThisEnvironment(method, this.getTestClass().getJavaClass());
    }

    @Override
    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Class<? extends Throwable> expectedException = this.getExpectedException(frameworkMethod);
        return expectedException != null ? new ExpectException(next, expectedException) : next;
    }

    protected Class<? extends Throwable> getExpectedException(FrameworkMethod frameworkMethod) {
        Test test = frameworkMethod.getAnnotation(Test.class);
        return test != null && test.expected() != Test.None.class ? test.expected() : null;
    }

    @Override
    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Statement statement = null;
        long springTimeout = this.getSpringTimeout(frameworkMethod);
        long junitTimeout = this.getJUnitTimeout(frameworkMethod);
        if (springTimeout > 0L && junitTimeout > 0L) {
            String msg = String.format("Test method [%s] has been configured with Spring's @Timed(millis=%s) and JUnit's @Test(timeout=%s) annotations, but only one declaration of a 'timeout' is permitted per test method.", frameworkMethod.getMethod(), springTimeout, junitTimeout);
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        statement = springTimeout > 0L ? new SpringFailOnTimeout(next, springTimeout) : (junitTimeout > 0L ? new FailOnTimeout(next, junitTimeout) : next);
        return statement;
    }

    protected long getJUnitTimeout(FrameworkMethod frameworkMethod) {
        Test test = frameworkMethod.getAnnotation(Test.class);
        return test != null && test.timeout() > 0L ? test.timeout() : 0L;
    }

    protected long getSpringTimeout(FrameworkMethod frameworkMethod) {
        AnnotationAttributes annAttrs = AnnotatedElementUtils.getAnnotationAttributes((AnnotatedElement)frameworkMethod.getMethod(), (String)Timed.class.getName());
        if (annAttrs == null) {
            return 0L;
        }
        long millis = (Long)annAttrs.getNumber("millis");
        return millis > 0L ? millis : 0L;
    }

    @Override
    protected Statement withBefores(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitBefores = super.withBefores(frameworkMethod, testInstance, statement);
        return new RunBeforeTestMethodCallbacks(junitBefores, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    @Override
    protected Statement withAfters(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitAfters = super.withAfters(frameworkMethod, testInstance, statement);
        return new RunAfterTestMethodCallbacks(junitAfters, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withPotentialRepeat(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Repeat repeatAnnotation = (Repeat)AnnotationUtils.getAnnotation((Method)frameworkMethod.getMethod(), Repeat.class);
        int repeat = repeatAnnotation != null ? repeatAnnotation.value() : 1;
        return new SpringRepeat(next, frameworkMethod.getMethod(), repeat);
    }

    static {
        if (withRulesMethod == null) {
            throw new IllegalStateException("Failed to find withRules() method: SpringJUnit4ClassRunner requires JUnit 4.9 or higher.");
        }
        ReflectionUtils.makeAccessible((Method)withRulesMethod);
    }
}

