/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.util.test;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.model.SocialActivityLimit;
import com.liferay.social.kernel.service.SocialActivityCounterLocalServiceUtil;
import com.liferay.social.kernel.service.SocialActivityLimitLocalServiceUtil;
import com.liferay.social.kernel.service.SocialActivityLocalServiceUtil;

public class SocialActivityTestUtil {
    private static final String _TEST_MODEL = "test-model";

    public static void addActivity(User user, Group group, AssetEntry assetEntry, int type) throws Exception {
        SocialActivityTestUtil.addActivity(user, group, assetEntry, type, "");
    }

    public static void addActivity(User user, Group group, AssetEntry assetEntry, int type, String extraData) throws Exception {
        SocialActivityLocalServiceUtil.addActivity((long)user.getUserId(), (long)group.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (int)type, (String)extraData, (long)0L);
    }

    public static AssetEntry addAssetEntry(User user, Group group) throws Exception {
        return AssetEntryLocalServiceUtil.updateEntry((long)user.getUserId(), (long)group.getGroupId(), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (long)RandomTestUtil.randomLong(), null, null);
    }

    public static AssetEntry addAssetEntry(User user, Group group, AssetEntry assetEntry) throws Exception {
        if (assetEntry != null) {
            AssetEntryLocalServiceUtil.deleteEntry((AssetEntry)assetEntry);
        }
        return AssetEntryLocalServiceUtil.updateEntry((long)user.getUserId(), (long)group.getGroupId(), (String)_TEST_MODEL, (long)1L, null, null);
    }

    public static String createExtraDataJSON(String key, String value) {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put(key, value);
        return extraDataJSONObject.toString();
    }

    public static SocialActivityCounter getActivityCounter(long groupId, String name, Object owner) throws Exception {
        long classNameId = 0L;
        long classPK = 0L;
        int ownerType = 1;
        if (owner instanceof User) {
            classNameId = PortalUtil.getClassNameId((String)User.class.getName());
            classPK = ((User)owner).getUserId();
        } else if (owner instanceof AssetEntry) {
            classNameId = ((AssetEntry)owner).getClassNameId();
            classPK = ((AssetEntry)owner).getClassPK();
            ownerType = 2;
        }
        if (name.equals("contribution")) {
            ownerType = 3;
        }
        return SocialActivityCounterLocalServiceUtil.fetchLatestActivityCounter((long)groupId, (long)classNameId, (long)classPK, (String)name, (int)ownerType);
    }

    public static SocialActivityLimit getActivityLimit(long groupId, User user, AssetEntry assetEntry, int activityType, String activityCounterName) throws Exception {
        long classPK = assetEntry.getClassPK();
        if (activityCounterName.equals("participation")) {
            classPK = 0L;
        }
        return SocialActivityLimitLocalServiceUtil.fetchActivityLimit((long)groupId, (long)user.getUserId(), (long)assetEntry.getClassNameId(), (long)classPK, (int)activityType, (String)activityCounterName);
    }
}

