/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.test;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portlet.ratings.util.test.RatingsTestUtil;
import com.liferay.ratings.kernel.exception.NoSuchStatsException;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalServiceUtil;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseRatingsTestCase {
    @DeleteAfterTestRun
    protected Group group;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
    }

    @Test(expected=NoSuchStatsException.class)
    public void testDeleteRatings() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        RatingsStats ratingsStats = RatingsTestUtil.addStats(this._getBaseModelClassName(), this.getRatingsClassPK((ClassedModel)baseModel));
        this.deleteBaseModel(baseModel, serviceContext);
        RatingsStatsLocalServiceUtil.getRatingsStats((long)ratingsStats.getStatsId());
    }

    protected abstract BaseModel<?> addBaseModel(BaseModel<?> var1, ServiceContext var2) throws Exception;

    protected abstract BaseModel<?> deleteBaseModel(BaseModel<?> var1, ServiceContext var2) throws Exception;

    protected abstract Class<?> getBaseModelClass();

    protected BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected long getRatingsClassPK(ClassedModel classedModel) {
        return (Long)classedModel.getPrimaryKeyObj();
    }

    private String _getBaseModelClassName() {
        Class<?> clazz = this.getBaseModelClass();
        return clazz.getName();
    }
}

