/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util.test;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.junit.Assert;

public class BlogsTestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlogsEntry addEntryWithWorkflow(long userId, String title, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            Calendar displayCalendar = CalendarFactoryUtil.getCalendar((int)2012, (int)1, (int)1);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            BlogsEntry entry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)title, (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (Date)displayCalendar.getTime(), (boolean)true, (boolean)true, (String[])new String[0], (String)"", null, null, (ServiceContext)serviceContext);
            if (approved) {
                BlogsEntry blogsEntry = BlogsTestUtil.updateStatus(entry, serviceContext);
                return blogsEntry;
            }
            BlogsEntry blogsEntry = entry;
            return blogsEntry;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public static void assertEquals(BlogsEntry expectedEntry, BlogsEntry actualEntry) {
        Assert.assertEquals(expectedEntry.getUserId(), actualEntry.getUserId());
        Assert.assertEquals(expectedEntry.getTitle(), actualEntry.getTitle());
        Assert.assertEquals(expectedEntry.getDescription(), actualEntry.getDescription());
        Assert.assertEquals(expectedEntry.getContent(), actualEntry.getContent());
        Assert.assertEquals(expectedEntry.getDisplayDate(), actualEntry.getDisplayDate());
        Assert.assertEquals(expectedEntry.isAllowPingbacks(), actualEntry.isAllowPingbacks());
        Assert.assertEquals(expectedEntry.isAllowTrackbacks(), actualEntry.isAllowTrackbacks());
        Assert.assertEquals(expectedEntry.isSmallImage(), actualEntry.isSmallImage());
        Assert.assertEquals(expectedEntry.getCoverImageFileEntryId(), actualEntry.getCoverImageFileEntryId());
    }

    public static String getTempBlogsEntryAttachmentFileEntryImgTag(long dataImageId, String url) {
        StringBundler sb = new StringBundler(7);
        sb.append("<img ");
        sb.append("data-image-id");
        sb.append("=\"");
        sb.append(dataImageId);
        sb.append("\" src=\"");
        sb.append(url);
        sb.append("\"/>");
        return sb.toString();
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull((String)command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    protected static BlogsEntry updateStatus(BlogsEntry entry, ServiceContext serviceContext) throws Exception {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", "http://localhost");
        workflowContext.put("userPortraitURL", "http://localhost");
        workflowContext.put("userURL", "http://localhost");
        return BlogsEntryLocalServiceUtil.updateStatus((long)entry.getUserId(), (long)entry.getEntryId(), (int)0, (ServiceContext)serviceContext, workflowContext);
    }
}

