/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.test;

import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;

public class AssetEntryQueryTestUtil {
    public static AssetEntryQuery createAssetEntryQuery(long groupId, long[] classNameIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNameIds, null, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String className, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, className, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String className, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, className, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames, long[] classTypeIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames, classTypeIds);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames, classTypeIds, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, long[] classNameIds, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassNameIds(classNameIds);
        if (Validator.isNotNull((Object)classTypeIds)) {
            assetEntryQuery.setClassTypeIds(classTypeIds);
        }
        if (Validator.isNotNull((Object)notAllCategoryIds)) {
            assetEntryQuery.setNotAllCategoryIds(notAllCategoryIds);
        }
        if (Validator.isNotNull((Object)notAnyCategoryIds)) {
            assetEntryQuery.setNotAnyCategoryIds(notAnyCategoryIds);
        }
        if (Validator.isNotNull((Object)anyCategoryIds)) {
            assetEntryQuery.setAnyCategoryIds(anyCategoryIds);
        }
        if (Validator.isNotNull((Object)allCategoryIds)) {
            assetEntryQuery.setAllCategoryIds(allCategoryIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])notAllTagNames)) {
            for (String assetTagName : notAllTagNames) {
                long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])groupIds, (String)assetTagName);
                assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])notAnyTagNames)) {
            assetEntryQuery.setNotAnyTagIds(AssetEntryQueryTestUtil.getAssetTagsIds(groupIds, notAnyTagNames));
        }
        if (ArrayUtil.isNotEmpty((Object[])anyTagNames)) {
            assetEntryQuery.setAnyTagIds(AssetEntryQueryTestUtil.getAssetTagsIds(groupIds, anyTagNames));
        }
        if (ArrayUtil.isNotEmpty((Object[])allTagNames)) {
            for (String assetTagName : allTagNames) {
                long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])groupIds, (String)assetTagName);
                assetEntryQuery.addAllTagIdsArray(allAssetTagIds);
            }
        }
        assetEntryQuery.setGroupIds(groupIds);
        return assetEntryQuery;
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String className, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, new String[]{className}, null, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String className, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, new String[]{className}, null, null, null, null, null, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNames, null, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames, long[] classTypeIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNames, classTypeIds, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        long[] classNameIds = new long[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            classNameIds[i] = PortalUtil.getClassNameId((String)classNames[i]);
        }
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNameIds, classTypeIds, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    protected static long[] getAssetTagsIds(long[] groupIds, String[] assetTagNames) throws Exception {
        if (ArrayUtil.isEmpty((Object[])assetTagNames)) {
            return new long[0];
        }
        return AssetTagLocalServiceUtil.getTagIds((long[])groupIds, (String[])assetTagNames);
    }
}

