/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy.util.test;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.OrganizationServiceUtil;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MembershipPolicyTestUtil {
    public static Group addGroup() throws Exception {
        String name = RandomTestUtil.randomString(new RandomizerBumper[0]);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        String friendlyURL = "/" + FriendlyURLNormalizerUtil.normalize((String)name);
        return GroupServiceUtil.addGroup((long)0L, (long)0L, nameMap, RandomTestUtil.randomLocaleStringMap(), (int)1, (boolean)true, (int)0, (String)friendlyURL, (boolean)true, (boolean)true, (ServiceContext)MembershipPolicyTestUtil.populateServiceContext(Group.class, true));
    }

    public static Organization addOrganization() throws Exception {
        String name = RandomTestUtil.randomString(new RandomizerBumper[0]);
        return OrganizationServiceUtil.addOrganization((long)0L, (String)name, (String)"organization", (long)0L, (long)0L, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, (String)"", (boolean)false, (ServiceContext)MembershipPolicyTestUtil.populateServiceContext(Organization.class, true));
    }

    public static Role addRole(int type) throws Exception {
        String name = RandomTestUtil.randomString(new RandomizerBumper[0]);
        return RoleServiceUtil.addRole(null, (long)0L, (String)name, RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), (int)type, (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (ServiceContext)MembershipPolicyTestUtil.populateServiceContext(Role.class, false));
    }

    public static User addUser(long[] organizationIds, long[] roleIds, long[] siteIds, long[] userGroupIds) throws Exception {
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = "UserServiceTest." + RandomTestUtil.nextLong() + "@liferay.com";
        long facebookId = 0L;
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = "UserServiceTest";
        String middleName = "";
        String lastName = "UserServiceTest";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        boolean sendMail = false;
        ServiceContext serviceContext = new ServiceContext();
        return UserServiceUtil.addUser((long)TestPropsValues.getCompanyId(), (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (long)prefixId, (long)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])siteIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendMail, (ServiceContext)serviceContext);
    }

    public static UserGroup addUserGroup() throws Exception {
        String name = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String description = RandomTestUtil.randomString(50, new RandomizerBumper[0]);
        return UserGroupServiceUtil.addUserGroup((String)name, (String)description, (ServiceContext)MembershipPolicyTestUtil.populateServiceContext(UserGroup.class, false));
    }

    public static void updateUser(User user, long[] organizationIds, long[] roleIds, long[] siteIds, long[] userGroupIds, List<UserGroupRole> userGroupRoles) throws Exception {
        String newPassword1;
        long userId = user.getUserId();
        String oldPassword = user.getPassword();
        String newPassword2 = newPassword1 = RandomTestUtil.randomString(new RandomizerBumper[0]);
        boolean passwordReset = true;
        String reminderQueryQuestion = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String reminderQueryAnswer = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String screenName = RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE);
        String emailAddress = "UserServiceTest." + RandomTestUtil.nextLong() + "@liferay.com";
        long facebookId = 0L;
        String openId = "";
        String languageId = LocaleUtil.toLanguageId((Locale)Locale.getDefault());
        String timeZoneId = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String greeting = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String comments = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String firstName = "UserServiceTest";
        String middleName = "";
        String lastName = "UserServiceTest";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        String smsSn = "UserServiceTestSmsSn." + RandomTestUtil.nextInt() + "@liferay.com";
        String facebookSn = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String jabberSn = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String skypeSn = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String twitterSn = RandomTestUtil.randomString(new RandomizerBumper[0]);
        ArrayList addresses = new ArrayList();
        ArrayList emailAddresses = new ArrayList();
        ArrayList phones = new ArrayList();
        ArrayList websites = new ArrayList();
        ArrayList announcementsDelivers = new ArrayList();
        ServiceContext serviceContext = new ServiceContext();
        UserServiceUtil.updateUser((long)userId, (String)oldPassword, (String)newPassword1, (String)newPassword2, (boolean)passwordReset, (String)reminderQueryQuestion, (String)reminderQueryAnswer, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (boolean)false, null, (String)languageId, (String)timeZoneId, (String)greeting, (String)comments, (String)firstName, (String)middleName, (String)lastName, (long)prefixId, (long)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)smsSn, (String)facebookSn, (String)jabberSn, (String)skypeSn, (String)twitterSn, (String)jobTitle, (long[])siteIds, (long[])organizationIds, (long[])roleIds, userGroupRoles, (long[])userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, (ServiceContext)serviceContext);
    }

    protected static Map<String, Serializable> addExpandoMap(Class<?> clazz) throws PortalException {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)TestPropsValues.getCompanyId(), (String)clazz.getName());
        expandoBridge.addAttribute("key1", false);
        expandoBridge.addAttribute("key2", false);
        expandoBridge.addAttribute("key3", false);
        expandoBridge.addAttribute("key4", false);
        HashMap<String, Serializable> expandoMap = new HashMap<String, Serializable>();
        expandoMap.put("key1", (Serializable)((Object)"value1"));
        expandoMap.put("key2", (Serializable)((Object)"value2"));
        expandoMap.put("key3", (Serializable)((Object)"value3"));
        expandoMap.put("key4", (Serializable)((Object)"value4"));
        return expandoMap;
    }

    protected static ServiceContext populateServiceContext(Class<?> clazz, boolean includeCategorization) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (includeCategorization) {
            AssetTag tag = AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)TestPropsValues.getGroupId(), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (ServiceContext)new ServiceContext());
            serviceContext.setAssetTagNames(new String[]{tag.getName()});
            Company company = CompanyLocalServiceUtil.getCompany((long)TestPropsValues.getCompanyId());
            serviceContext.setScopeGroupId(company.getGroupId());
            AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)TestPropsValues.getUserId(), (long)company.getGroupId(), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (ServiceContext)serviceContext);
            AssetCategory category = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)company.getGroupId(), (String)RandomTestUtil.randomString(new RandomizerBumper[0]), (long)vocabulary.getVocabularyId(), (ServiceContext)serviceContext);
            serviceContext.setAssetCategoryIds(new long[]{category.getCategoryId()});
        }
        serviceContext.setExpandoBridgeAttributes(MembershipPolicyTestUtil.addExpandoMap(clazz));
        return serviceContext;
    }
}

