/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.unit.test.stats;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.test.IdempotentRetryAssert;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.search.unit.test.BaseIndexingTestCase;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public abstract class BaseStatisticsTestCase
extends BaseIndexingTestCase {
    protected static final String STAT_FIELD = "priority";
    protected static final String STAT_SORTABLE_FIELD = "priority_Number_sortable";

    protected static String toString(StatsResults statsResults) {
        StringBundler sb = new StringBundler(19);
        sb.append("{count=");
        sb.append(statsResults.getCount());
        sb.append(", field=");
        sb.append(statsResults.getField());
        sb.append(", max=");
        sb.append(statsResults.getMax());
        sb.append(", mean=");
        sb.append(statsResults.getMean());
        sb.append(", min=");
        sb.append(statsResults.getMin());
        sb.append(", missing=");
        sb.append(statsResults.getMissing());
        sb.append(", standardDeviation=");
        sb.append(statsResults.getStandardDeviation());
        sb.append(", sum=");
        sb.append(statsResults.getSum());
        sb.append(", sumOfSquares=");
        sb.append(statsResults.getSumOfSquares());
        sb.append("}");
        return sb.toString();
    }

    protected void addDocuments(int count) throws Exception {
        String field = STAT_FIELD;
        int i = 1;
        while (i <= count) {
            final int value = i++;
            this.addDocument(new BaseIndexingTestCase.DocumentCreationHelper(){

                @Override
                public void populate(Document document) {
                    document.addNumberSortable(BaseStatisticsTestCase.STAT_FIELD, Integer.valueOf(value));
                }
            });
        }
    }

    protected void assertStats() throws Exception {
        String field = STAT_SORTABLE_FIELD;
        SearchContext searchContext = BaseStatisticsTestCase.createSearchContext();
        Stats stats = new Stats();
        stats.setCount(true);
        stats.setField(field);
        stats.setMax(true);
        stats.setMean(true);
        stats.setMin(true);
        stats.setSum(true);
        stats.setSumOfSquares(true);
        searchContext.addStats(stats);
        Hits hits = this.search(searchContext);
        Map statsResultsMap = hits.getStatsResults();
        Assert.assertNotNull(statsResultsMap);
        StatsResults statsResults = (StatsResults)statsResultsMap.get(field);
        Assert.assertNotNull(statsResults);
        StatsResults expectedStatsResults = new StatsResults(field);
        expectedStatsResults.setCount(31L);
        expectedStatsResults.setMax(31.0);
        expectedStatsResults.setMean(16.0);
        expectedStatsResults.setMin(1.0);
        expectedStatsResults.setSum(496.0);
        expectedStatsResults.setSumOfSquares(10416.0);
        Assert.assertEquals(BaseStatisticsTestCase.toString(expectedStatsResults), BaseStatisticsTestCase.toString(statsResults));
    }

    protected void testGetStats() throws Exception {
        this.addDocuments(31);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseStatisticsTestCase.this.assertStats();
                return null;
            }
        });
    }
}

