/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.unit.test.groupby;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.test.IdempotentRetryAssert;
import com.liferay.portal.search.unit.test.BaseIndexingTestCase;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public abstract class BaseGroupByTestCase
extends BaseIndexingTestCase {
    protected static final String GROUP_FIELD = "userName";

    protected void addDocuments(final String name, int count) throws Exception {
        String field = GROUP_FIELD;
        for (int i = 1; i <= count; ++i) {
            this.addDocument(new BaseIndexingTestCase.DocumentCreationHelper(){

                @Override
                public void populate(Document document) {
                    document.addKeyword(BaseGroupByTestCase.GROUP_FIELD, name);
                }
            });
        }
    }

    protected void assertGroup(String key, int hitsCount, int docsCount, Map<String, Hits> groupedHitsMap) {
        Hits hits = groupedHitsMap.get(key);
        Assert.assertNotNull(hits);
        Assert.assertEquals(hitsCount, hits.getLength());
        Document[] docs = hits.getDocs();
        Assert.assertEquals(docsCount, docs.length);
    }

    protected void assertGroup(String key, int count, Map<String, Hits> groupedHitsMap) {
        this.assertGroup(key, count, count, groupedHitsMap);
    }

    protected Map<String, Hits> searchGroups(SearchContext searchContext) throws Exception {
        Hits hits = this.search(searchContext);
        Map groupedHitsMap = hits.getGroupedHits();
        Assert.assertNotNull(groupedHitsMap);
        return groupedHitsMap;
    }

    protected void testGroupBy() throws Exception {
        this.addDocuments("sixteen", 16);
        this.addDocuments("three", 3);
        this.addDocuments("two", 2);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
                searchContext.setGroupBy(new GroupBy(BaseGroupByTestCase.GROUP_FIELD));
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                Assert.assertEquals(3L, groupedHitsMap.size());
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, groupedHitsMap);
                BaseGroupByTestCase.this.assertGroup("three", 3, groupedHitsMap);
                BaseGroupByTestCase.this.assertGroup("two", 2, groupedHitsMap);
                return null;
            }
        });
    }

    protected void testStartAndEnd() throws Exception {
        this.addDocuments("sixteen", 16);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
                searchContext.setEnd(9);
                searchContext.setGroupBy(new GroupBy(BaseGroupByTestCase.GROUP_FIELD));
                searchContext.setStart(4);
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, 6, groupedHitsMap);
                return null;
            }
        });
    }

    protected void testStartAndSize() throws Exception {
        this.addDocuments("sixteen", 16);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
                GroupBy groupBy = new GroupBy(BaseGroupByTestCase.GROUP_FIELD);
                groupBy.setSize(3);
                groupBy.setStart(8);
                searchContext.setGroupBy(groupBy);
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, 3, groupedHitsMap);
                return null;
            }
        });
    }
}

